/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket.internals;

import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputArraysJVMKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.websocket.internals.BytePacketUtilsKt;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"EMPTY_CHUNK", "", "PADDED_EMPTY_CHUNK", "deflateFully", "Ljava/util/zip/Deflater;", "data", "deflateTo", "", "Lio/ktor/utils/io/core/BytePacketBuilder;", "deflater", "buffer", "Ljava/nio/ByteBuffer;", "flush", "", "inflateFully", "Ljava/util/zip/Inflater;", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nDeflaterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Pool.kt\nio/ktor/utils/io/pool/PoolKt\n*L\n1#1,85:1\n12#2,7:86\n19#2,4:98\n12#2,11:102\n12#2,7:113\n19#2,4:125\n159#3,5:93\n159#3,5:120\n*S KotlinDebug\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n*L\n19#1:86,7\n19#1:98,4\n35#1:102,11\n45#1:113,7\n45#1:125,4\n20#1:93,5\n46#1:120,5\n*E\n"})
public final class DeflaterUtilsKt {
    @NotNull
    private static final byte[] PADDED_EMPTY_CHUNK;
    @NotNull
    private static final byte[] EMPTY_CHUNK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] deflateFully(@NotNull Deflater $this$deflateFully, @NotNull byte[] data) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        Intrinsics.checkNotNullParameter((Object)$this$deflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $this$deflateFully.setInput(data);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u241 = builder$iv;
            boolean bl = false;
            ObjectPool $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            Object instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = (ByteBuffer)instance$iv;
                boolean bl2 = false;
                while (!$this$deflateFully.needsInput()) {
                    DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, false);
                }
                while (DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, true) != 0) {
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket deflatedBytes = byteReadPacket2;
        if (BytePacketUtilsKt.endsWith(deflatedBytes, PADDED_EMPTY_CHUNK)) {
            byte[] it = $i$f$buildPacket = StringsKt.readBytes((ByteReadPacket)deflatedBytes, (int)((int)deflatedBytes.getRemaining() - EMPTY_CHUNK.length));
            boolean bl = false;
            deflatedBytes.release();
            return $i$f$buildPacket;
        }
        $i$f$buildPacket = false;
        builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u243 = builder$iv;
            boolean bl = false;
            $this$deflateFully_u24lambda_u243.writePacket(deflatedBytes);
            $this$deflateFully_u24lambda_u243.writeByte((byte)0);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes$default((ByteReadPacket)byteReadPacket, (int)0, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] inflateFully(@NotNull Inflater $this$inflateFully, @NotNull byte[] data) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$inflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] dataToInflate = ArraysKt.plus((byte[])data, (byte[])EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$inflateFully_u24lambda_u245 = builder$iv;
            boolean bl = false;
            ObjectPool $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            Object instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = (ByteBuffer)instance$iv;
                boolean bl2 = false;
                long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
                while ($this$inflateFully.getBytesRead() < limit) {
                    buffer.clear();
                    int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                    buffer.position(buffer.position() + inflated);
                    buffer.flip();
                    OutputArraysJVMKt.writeFully((Output)((Output)$this$inflateFully_u24lambda_u245), (ByteBuffer)buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet = byteReadPacket;
        return StringsKt.readBytes$default((ByteReadPacket)packet, (int)0, (int)1, null);
    }

    private static final int deflateTo(BytePacketBuilder $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        int deflated;
        buffer.clear();
        int n = deflated = flush2 ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated == 0) {
            return 0;
        }
        buffer.position(buffer.position() + deflated);
        buffer.flip();
        OutputArraysJVMKt.writeFully((Output)((Output)$this$deflateTo), (ByteBuffer)buffer);
        return deflated;
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, -1, -1};
        PADDED_EMPTY_CHUNK = byArray;
        byArray = new byte[]{0, 0, -1, -1};
        EMPTY_CHUNK = byArray;
    }
}

