/*
Copyright 2022 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

/** Generated */
public interface V1ContainerFluent<A extends V1ContainerFluent<A>> extends Fluent<A> {
  public A addToArgs(Integer index, String item);

  public A setToArgs(java.lang.Integer index, java.lang.String item);

  public A addToArgs(java.lang.String... items);

  public A addAllToArgs(Collection<java.lang.String> items);

  public A removeFromArgs(java.lang.String... items);

  public A removeAllFromArgs(java.util.Collection<java.lang.String> items);

  public List<java.lang.String> getArgs();

  public java.lang.String getArg(java.lang.Integer index);

  public java.lang.String getFirstArg();

  public java.lang.String getLastArg();

  public java.lang.String getMatchingArg(Predicate<java.lang.String> predicate);

  public Boolean hasMatchingArg(java.util.function.Predicate<java.lang.String> predicate);

  public A withArgs(java.util.List<java.lang.String> args);

  public A withArgs(java.lang.String... args);

  public java.lang.Boolean hasArgs();

  public A addToCommand(java.lang.Integer index, java.lang.String item);

  public A setToCommand(java.lang.Integer index, java.lang.String item);

  public A addToCommand(java.lang.String... items);

  public A addAllToCommand(java.util.Collection<java.lang.String> items);

  public A removeFromCommand(java.lang.String... items);

  public A removeAllFromCommand(java.util.Collection<java.lang.String> items);

  public java.util.List<java.lang.String> getCommand();

  public java.lang.String getCommand(java.lang.Integer index);

  public java.lang.String getFirstCommand();

  public java.lang.String getLastCommand();

  public java.lang.String getMatchingCommand(
      java.util.function.Predicate<java.lang.String> predicate);

  public java.lang.Boolean hasMatchingCommand(
      java.util.function.Predicate<java.lang.String> predicate);

  public A withCommand(java.util.List<java.lang.String> command);

  public A withCommand(java.lang.String... command);

  public java.lang.Boolean hasCommand();

  public A addToEnv(java.lang.Integer index, V1EnvVar item);

  public A setToEnv(java.lang.Integer index, io.kubernetes.client.openapi.models.V1EnvVar item);

  public A addToEnv(io.kubernetes.client.openapi.models.V1EnvVar... items);

  public A addAllToEnv(java.util.Collection<io.kubernetes.client.openapi.models.V1EnvVar> items);

  public A removeFromEnv(io.kubernetes.client.openapi.models.V1EnvVar... items);

  public A removeAllFromEnv(
      java.util.Collection<io.kubernetes.client.openapi.models.V1EnvVar> items);

  public A removeMatchingFromEnv(java.util.function.Predicate<V1EnvVarBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildEnv instead.
   *
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.kubernetes.client.openapi.models.V1EnvVar> getEnv();

  public java.util.List<io.kubernetes.client.openapi.models.V1EnvVar> buildEnv();

  public io.kubernetes.client.openapi.models.V1EnvVar buildEnv(java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1EnvVar buildFirstEnv();

  public io.kubernetes.client.openapi.models.V1EnvVar buildLastEnv();

  public io.kubernetes.client.openapi.models.V1EnvVar buildMatchingEnv(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EnvVarBuilder> predicate);

  public java.lang.Boolean hasMatchingEnv(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EnvVarBuilder> predicate);

  public A withEnv(java.util.List<io.kubernetes.client.openapi.models.V1EnvVar> env);

  public A withEnv(io.kubernetes.client.openapi.models.V1EnvVar... env);

  public java.lang.Boolean hasEnv();

  public V1ContainerFluent.EnvNested<A> addNewEnv();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvNested<A> addNewEnvLike(
      io.kubernetes.client.openapi.models.V1EnvVar item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvNested<A> setNewEnvLike(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1EnvVar item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvNested<A> editEnv(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvNested<A> editFirstEnv();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvNested<A> editLastEnv();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvNested<A> editMatchingEnv(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EnvVarBuilder> predicate);

  public A addToEnvFrom(java.lang.Integer index, V1EnvFromSource item);

  public A setToEnvFrom(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1EnvFromSource item);

  public A addToEnvFrom(io.kubernetes.client.openapi.models.V1EnvFromSource... items);

  public A addAllToEnvFrom(
      java.util.Collection<io.kubernetes.client.openapi.models.V1EnvFromSource> items);

  public A removeFromEnvFrom(io.kubernetes.client.openapi.models.V1EnvFromSource... items);

  public A removeAllFromEnvFrom(
      java.util.Collection<io.kubernetes.client.openapi.models.V1EnvFromSource> items);

  public A removeMatchingFromEnvFrom(
      java.util.function.Predicate<V1EnvFromSourceBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildEnvFrom instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.kubernetes.client.openapi.models.V1EnvFromSource> getEnvFrom();

  public java.util.List<io.kubernetes.client.openapi.models.V1EnvFromSource> buildEnvFrom();

  public io.kubernetes.client.openapi.models.V1EnvFromSource buildEnvFrom(java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1EnvFromSource buildFirstEnvFrom();

  public io.kubernetes.client.openapi.models.V1EnvFromSource buildLastEnvFrom();

  public io.kubernetes.client.openapi.models.V1EnvFromSource buildMatchingEnvFrom(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EnvFromSourceBuilder>
          predicate);

  public java.lang.Boolean hasMatchingEnvFrom(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EnvFromSourceBuilder>
          predicate);

  public A withEnvFrom(java.util.List<io.kubernetes.client.openapi.models.V1EnvFromSource> envFrom);

  public A withEnvFrom(io.kubernetes.client.openapi.models.V1EnvFromSource... envFrom);

  public java.lang.Boolean hasEnvFrom();

  public V1ContainerFluent.EnvFromNested<A> addNewEnvFrom();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvFromNested<A> addNewEnvFromLike(
      io.kubernetes.client.openapi.models.V1EnvFromSource item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvFromNested<A> setNewEnvFromLike(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1EnvFromSource item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvFromNested<A> editEnvFrom(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvFromNested<A> editFirstEnvFrom();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvFromNested<A> editLastEnvFrom();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.EnvFromNested<A> editMatchingEnvFrom(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1EnvFromSourceBuilder>
          predicate);

  public java.lang.String getImage();

  public A withImage(java.lang.String image);

  public java.lang.Boolean hasImage();

  public java.lang.String getImagePullPolicy();

  public A withImagePullPolicy(java.lang.String imagePullPolicy);

  public java.lang.Boolean hasImagePullPolicy();

  /**
   * This method has been deprecated, please use method buildLifecycle instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public V1Lifecycle getLifecycle();

  public io.kubernetes.client.openapi.models.V1Lifecycle buildLifecycle();

  public A withLifecycle(io.kubernetes.client.openapi.models.V1Lifecycle lifecycle);

  public java.lang.Boolean hasLifecycle();

  public V1ContainerFluent.LifecycleNested<A> withNewLifecycle();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LifecycleNested<A>
      withNewLifecycleLike(io.kubernetes.client.openapi.models.V1Lifecycle item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LifecycleNested<A> editLifecycle();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LifecycleNested<A>
      editOrNewLifecycle();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LifecycleNested<A>
      editOrNewLifecycleLike(io.kubernetes.client.openapi.models.V1Lifecycle item);

  /**
   * This method has been deprecated, please use method buildLivenessProbe instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public V1Probe getLivenessProbe();

  public io.kubernetes.client.openapi.models.V1Probe buildLivenessProbe();

  public A withLivenessProbe(io.kubernetes.client.openapi.models.V1Probe livenessProbe);

  public java.lang.Boolean hasLivenessProbe();

  public V1ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LivenessProbeNested<A>
      withNewLivenessProbeLike(io.kubernetes.client.openapi.models.V1Probe item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LivenessProbeNested<A>
      editLivenessProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LivenessProbeNested<A>
      editOrNewLivenessProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.LivenessProbeNested<A>
      editOrNewLivenessProbeLike(io.kubernetes.client.openapi.models.V1Probe item);

  public java.lang.String getName();

  public A withName(java.lang.String name);

  public java.lang.Boolean hasName();

  public A addToPorts(java.lang.Integer index, V1ContainerPort item);

  public A setToPorts(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1ContainerPort item);

  public A addToPorts(io.kubernetes.client.openapi.models.V1ContainerPort... items);

  public A addAllToPorts(
      java.util.Collection<io.kubernetes.client.openapi.models.V1ContainerPort> items);

  public A removeFromPorts(io.kubernetes.client.openapi.models.V1ContainerPort... items);

  public A removeAllFromPorts(
      java.util.Collection<io.kubernetes.client.openapi.models.V1ContainerPort> items);

  public A removeMatchingFromPorts(java.util.function.Predicate<V1ContainerPortBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildPorts instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.kubernetes.client.openapi.models.V1ContainerPort> getPorts();

  public java.util.List<io.kubernetes.client.openapi.models.V1ContainerPort> buildPorts();

  public io.kubernetes.client.openapi.models.V1ContainerPort buildPort(java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1ContainerPort buildFirstPort();

  public io.kubernetes.client.openapi.models.V1ContainerPort buildLastPort();

  public io.kubernetes.client.openapi.models.V1ContainerPort buildMatchingPort(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1ContainerPortBuilder>
          predicate);

  public java.lang.Boolean hasMatchingPort(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1ContainerPortBuilder>
          predicate);

  public A withPorts(java.util.List<io.kubernetes.client.openapi.models.V1ContainerPort> ports);

  public A withPorts(io.kubernetes.client.openapi.models.V1ContainerPort... ports);

  public java.lang.Boolean hasPorts();

  public V1ContainerFluent.PortsNested<A> addNewPort();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.PortsNested<A> addNewPortLike(
      io.kubernetes.client.openapi.models.V1ContainerPort item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.PortsNested<A> setNewPortLike(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1ContainerPort item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.PortsNested<A> editPort(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.PortsNested<A> editFirstPort();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.PortsNested<A> editLastPort();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.PortsNested<A> editMatchingPort(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1ContainerPortBuilder>
          predicate);

  /**
   * This method has been deprecated, please use method buildReadinessProbe instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.kubernetes.client.openapi.models.V1Probe getReadinessProbe();

  public io.kubernetes.client.openapi.models.V1Probe buildReadinessProbe();

  public A withReadinessProbe(io.kubernetes.client.openapi.models.V1Probe readinessProbe);

  public java.lang.Boolean hasReadinessProbe();

  public V1ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ReadinessProbeNested<A>
      withNewReadinessProbeLike(io.kubernetes.client.openapi.models.V1Probe item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ReadinessProbeNested<A>
      editReadinessProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ReadinessProbeNested<A>
      editOrNewReadinessProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ReadinessProbeNested<A>
      editOrNewReadinessProbeLike(io.kubernetes.client.openapi.models.V1Probe item);

  /**
   * This method has been deprecated, please use method buildResources instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public V1ResourceRequirements getResources();

  public io.kubernetes.client.openapi.models.V1ResourceRequirements buildResources();

  public A withResources(io.kubernetes.client.openapi.models.V1ResourceRequirements resources);

  public java.lang.Boolean hasResources();

  public V1ContainerFluent.ResourcesNested<A> withNewResources();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ResourcesNested<A>
      withNewResourcesLike(io.kubernetes.client.openapi.models.V1ResourceRequirements item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ResourcesNested<A> editResources();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ResourcesNested<A>
      editOrNewResources();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.ResourcesNested<A>
      editOrNewResourcesLike(io.kubernetes.client.openapi.models.V1ResourceRequirements item);

  /**
   * This method has been deprecated, please use method buildSecurityContext instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public V1SecurityContext getSecurityContext();

  public io.kubernetes.client.openapi.models.V1SecurityContext buildSecurityContext();

  public A withSecurityContext(
      io.kubernetes.client.openapi.models.V1SecurityContext securityContext);

  public java.lang.Boolean hasSecurityContext();

  public V1ContainerFluent.SecurityContextNested<A> withNewSecurityContext();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.SecurityContextNested<A>
      withNewSecurityContextLike(io.kubernetes.client.openapi.models.V1SecurityContext item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.SecurityContextNested<A>
      editSecurityContext();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.SecurityContextNested<A>
      editOrNewSecurityContext();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.SecurityContextNested<A>
      editOrNewSecurityContextLike(io.kubernetes.client.openapi.models.V1SecurityContext item);

  /**
   * This method has been deprecated, please use method buildStartupProbe instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.kubernetes.client.openapi.models.V1Probe getStartupProbe();

  public io.kubernetes.client.openapi.models.V1Probe buildStartupProbe();

  public A withStartupProbe(io.kubernetes.client.openapi.models.V1Probe startupProbe);

  public java.lang.Boolean hasStartupProbe();

  public V1ContainerFluent.StartupProbeNested<A> withNewStartupProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.StartupProbeNested<A>
      withNewStartupProbeLike(io.kubernetes.client.openapi.models.V1Probe item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.StartupProbeNested<A>
      editStartupProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.StartupProbeNested<A>
      editOrNewStartupProbe();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.StartupProbeNested<A>
      editOrNewStartupProbeLike(io.kubernetes.client.openapi.models.V1Probe item);

  public java.lang.Boolean getStdin();

  public A withStdin(java.lang.Boolean stdin);

  public java.lang.Boolean hasStdin();

  public java.lang.Boolean getStdinOnce();

  public A withStdinOnce(java.lang.Boolean stdinOnce);

  public java.lang.Boolean hasStdinOnce();

  public java.lang.String getTerminationMessagePath();

  public A withTerminationMessagePath(java.lang.String terminationMessagePath);

  public java.lang.Boolean hasTerminationMessagePath();

  public java.lang.String getTerminationMessagePolicy();

  public A withTerminationMessagePolicy(java.lang.String terminationMessagePolicy);

  public java.lang.Boolean hasTerminationMessagePolicy();

  public java.lang.Boolean getTty();

  public A withTty(java.lang.Boolean tty);

  public java.lang.Boolean hasTty();

  public A addToVolumeDevices(java.lang.Integer index, V1VolumeDevice item);

  public A setToVolumeDevices(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1VolumeDevice item);

  public A addToVolumeDevices(io.kubernetes.client.openapi.models.V1VolumeDevice... items);

  public A addAllToVolumeDevices(
      java.util.Collection<io.kubernetes.client.openapi.models.V1VolumeDevice> items);

  public A removeFromVolumeDevices(io.kubernetes.client.openapi.models.V1VolumeDevice... items);

  public A removeAllFromVolumeDevices(
      java.util.Collection<io.kubernetes.client.openapi.models.V1VolumeDevice> items);

  public A removeMatchingFromVolumeDevices(
      java.util.function.Predicate<V1VolumeDeviceBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildVolumeDevices instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.kubernetes.client.openapi.models.V1VolumeDevice> getVolumeDevices();

  public java.util.List<io.kubernetes.client.openapi.models.V1VolumeDevice> buildVolumeDevices();

  public io.kubernetes.client.openapi.models.V1VolumeDevice buildVolumeDevice(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1VolumeDevice buildFirstVolumeDevice();

  public io.kubernetes.client.openapi.models.V1VolumeDevice buildLastVolumeDevice();

  public io.kubernetes.client.openapi.models.V1VolumeDevice buildMatchingVolumeDevice(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1VolumeDeviceBuilder>
          predicate);

  public java.lang.Boolean hasMatchingVolumeDevice(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1VolumeDeviceBuilder>
          predicate);

  public A withVolumeDevices(
      java.util.List<io.kubernetes.client.openapi.models.V1VolumeDevice> volumeDevices);

  public A withVolumeDevices(io.kubernetes.client.openapi.models.V1VolumeDevice... volumeDevices);

  public java.lang.Boolean hasVolumeDevices();

  public V1ContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeDevicesNested<A>
      addNewVolumeDeviceLike(io.kubernetes.client.openapi.models.V1VolumeDevice item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeDevicesNested<A>
      setNewVolumeDeviceLike(
          java.lang.Integer index, io.kubernetes.client.openapi.models.V1VolumeDevice item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeDevicesNested<A>
      editVolumeDevice(java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeDevicesNested<A>
      editFirstVolumeDevice();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeDevicesNested<A>
      editLastVolumeDevice();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeDevicesNested<A>
      editMatchingVolumeDevice(
          java.util.function.Predicate<io.kubernetes.client.openapi.models.V1VolumeDeviceBuilder>
              predicate);

  public A addToVolumeMounts(java.lang.Integer index, V1VolumeMount item);

  public A setToVolumeMounts(
      java.lang.Integer index, io.kubernetes.client.openapi.models.V1VolumeMount item);

  public A addToVolumeMounts(io.kubernetes.client.openapi.models.V1VolumeMount... items);

  public A addAllToVolumeMounts(
      java.util.Collection<io.kubernetes.client.openapi.models.V1VolumeMount> items);

  public A removeFromVolumeMounts(io.kubernetes.client.openapi.models.V1VolumeMount... items);

  public A removeAllFromVolumeMounts(
      java.util.Collection<io.kubernetes.client.openapi.models.V1VolumeMount> items);

  public A removeMatchingFromVolumeMounts(
      java.util.function.Predicate<V1VolumeMountBuilder> predicate);

  /**
   * This method has been deprecated, please use method buildVolumeMounts instead.
   *
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.kubernetes.client.openapi.models.V1VolumeMount> getVolumeMounts();

  public java.util.List<io.kubernetes.client.openapi.models.V1VolumeMount> buildVolumeMounts();

  public io.kubernetes.client.openapi.models.V1VolumeMount buildVolumeMount(
      java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1VolumeMount buildFirstVolumeMount();

  public io.kubernetes.client.openapi.models.V1VolumeMount buildLastVolumeMount();

  public io.kubernetes.client.openapi.models.V1VolumeMount buildMatchingVolumeMount(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1VolumeMountBuilder>
          predicate);

  public java.lang.Boolean hasMatchingVolumeMount(
      java.util.function.Predicate<io.kubernetes.client.openapi.models.V1VolumeMountBuilder>
          predicate);

  public A withVolumeMounts(
      java.util.List<io.kubernetes.client.openapi.models.V1VolumeMount> volumeMounts);

  public A withVolumeMounts(io.kubernetes.client.openapi.models.V1VolumeMount... volumeMounts);

  public java.lang.Boolean hasVolumeMounts();

  public V1ContainerFluent.VolumeMountsNested<A> addNewVolumeMount();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeMountsNested<A>
      addNewVolumeMountLike(io.kubernetes.client.openapi.models.V1VolumeMount item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeMountsNested<A>
      setNewVolumeMountLike(
          java.lang.Integer index, io.kubernetes.client.openapi.models.V1VolumeMount item);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeMountsNested<A>
      editVolumeMount(java.lang.Integer index);

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeMountsNested<A>
      editFirstVolumeMount();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeMountsNested<A>
      editLastVolumeMount();

  public io.kubernetes.client.openapi.models.V1ContainerFluent.VolumeMountsNested<A>
      editMatchingVolumeMount(
          java.util.function.Predicate<io.kubernetes.client.openapi.models.V1VolumeMountBuilder>
              predicate);

  public java.lang.String getWorkingDir();

  public A withWorkingDir(java.lang.String workingDir);

  public java.lang.Boolean hasWorkingDir();

  public A withStdin();

  public A withStdinOnce();

  public A withTty();

  public interface EnvNested<N> extends Nested<N>, V1EnvVarFluent<V1ContainerFluent.EnvNested<N>> {
    public N and();

    public N endEnv();
  }

  public interface EnvFromNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1EnvFromSourceFluent<V1ContainerFluent.EnvFromNested<N>> {
    public N and();

    public N endEnvFrom();
  }

  public interface LifecycleNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1LifecycleFluent<V1ContainerFluent.LifecycleNested<N>> {
    public N and();

    public N endLifecycle();
  }

  public interface LivenessProbeNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1ProbeFluent<V1ContainerFluent.LivenessProbeNested<N>> {
    public N and();

    public N endLivenessProbe();
  }

  public interface PortsNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1ContainerPortFluent<V1ContainerFluent.PortsNested<N>> {
    public N and();

    public N endPort();
  }

  public interface ReadinessProbeNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1ProbeFluent<V1ContainerFluent.ReadinessProbeNested<N>> {
    public N and();

    public N endReadinessProbe();
  }

  public interface ResourcesNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1ResourceRequirementsFluent<V1ContainerFluent.ResourcesNested<N>> {
    public N and();

    public N endResources();
  }

  public interface SecurityContextNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1SecurityContextFluent<V1ContainerFluent.SecurityContextNested<N>> {
    public N and();

    public N endSecurityContext();
  }

  public interface StartupProbeNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1ProbeFluent<V1ContainerFluent.StartupProbeNested<N>> {
    public N and();

    public N endStartupProbe();
  }

  public interface VolumeDevicesNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1VolumeDeviceFluent<V1ContainerFluent.VolumeDevicesNested<N>> {
    public N and();

    public N endVolumeDevice();
  }

  public interface VolumeMountsNested<N>
      extends io.kubernetes.client.fluent.Nested<N>,
          V1VolumeMountFluent<V1ContainerFluent.VolumeMountsNested<N>> {
    public N and();

    public N endVolumeMount();
  }
}
