/*
Copyright 2022 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;

public class V1alpha1StorageVersionConditionBuilder
    extends V1alpha1StorageVersionConditionFluentImpl<V1alpha1StorageVersionConditionBuilder>
    implements VisitableBuilder<
        io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition,
        V1alpha1StorageVersionConditionBuilder> {
  public V1alpha1StorageVersionConditionBuilder() {
    this(false);
  }

  public V1alpha1StorageVersionConditionBuilder(Boolean validationEnabled) {
    this(new V1alpha1StorageVersionCondition(), validationEnabled);
  }

  public V1alpha1StorageVersionConditionBuilder(
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionFluent<?> fluent) {
    this(fluent, false);
  }

  public V1alpha1StorageVersionConditionBuilder(
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionFluent<?> fluent,
      java.lang.Boolean validationEnabled) {
    this(fluent, new V1alpha1StorageVersionCondition(), validationEnabled);
  }

  public V1alpha1StorageVersionConditionBuilder(
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionFluent<?> fluent,
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition instance) {
    this(fluent, instance, false);
  }

  public V1alpha1StorageVersionConditionBuilder(
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionFluent<?> fluent,
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition instance,
      java.lang.Boolean validationEnabled) {
    this.fluent = fluent;
    fluent.withLastTransitionTime(instance.getLastTransitionTime());

    fluent.withMessage(instance.getMessage());

    fluent.withObservedGeneration(instance.getObservedGeneration());

    fluent.withReason(instance.getReason());

    fluent.withStatus(instance.getStatus());

    fluent.withType(instance.getType());

    this.validationEnabled = validationEnabled;
  }

  public V1alpha1StorageVersionConditionBuilder(
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition instance) {
    this(instance, false);
  }

  public V1alpha1StorageVersionConditionBuilder(
      io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition instance,
      java.lang.Boolean validationEnabled) {
    this.fluent = this;
    this.withLastTransitionTime(instance.getLastTransitionTime());

    this.withMessage(instance.getMessage());

    this.withObservedGeneration(instance.getObservedGeneration());

    this.withReason(instance.getReason());

    this.withStatus(instance.getStatus());

    this.withType(instance.getType());

    this.validationEnabled = validationEnabled;
  }

  io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;

  public io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition build() {
    V1alpha1StorageVersionCondition buildable = new V1alpha1StorageVersionCondition();
    buildable.setLastTransitionTime(fluent.getLastTransitionTime());
    buildable.setMessage(fluent.getMessage());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    buildable.setReason(fluent.getReason());
    buildable.setStatus(fluent.getStatus());
    buildable.setType(fluent.getType());
    return buildable;
  }
}
