/*
Copyright 2022 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;

public class V1beta1FlowSchemaStatusBuilder
    extends V1beta1FlowSchemaStatusFluentImpl<V1beta1FlowSchemaStatusBuilder>
    implements VisitableBuilder<
        V1beta1FlowSchemaStatus,
        io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatusBuilder> {
  public V1beta1FlowSchemaStatusBuilder() {
    this(false);
  }

  public V1beta1FlowSchemaStatusBuilder(Boolean validationEnabled) {
    this(new V1beta1FlowSchemaStatus(), validationEnabled);
  }

  public V1beta1FlowSchemaStatusBuilder(V1beta1FlowSchemaStatusFluent<?> fluent) {
    this(fluent, false);
  }

  public V1beta1FlowSchemaStatusBuilder(
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatusFluent<?> fluent,
      java.lang.Boolean validationEnabled) {
    this(fluent, new V1beta1FlowSchemaStatus(), validationEnabled);
  }

  public V1beta1FlowSchemaStatusBuilder(
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatusFluent<?> fluent,
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatus instance) {
    this(fluent, instance, false);
  }

  public V1beta1FlowSchemaStatusBuilder(
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatusFluent<?> fluent,
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatus instance,
      java.lang.Boolean validationEnabled) {
    this.fluent = fluent;
    fluent.withConditions(instance.getConditions());

    this.validationEnabled = validationEnabled;
  }

  public V1beta1FlowSchemaStatusBuilder(
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatus instance) {
    this(instance, false);
  }

  public V1beta1FlowSchemaStatusBuilder(
      io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatus instance,
      java.lang.Boolean validationEnabled) {
    this.fluent = this;
    this.withConditions(instance.getConditions());

    this.validationEnabled = validationEnabled;
  }

  io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;

  public io.kubernetes.client.openapi.models.V1beta1FlowSchemaStatus build() {
    V1beta1FlowSchemaStatus buildable = new V1beta1FlowSchemaStatus();
    buildable.setConditions(fluent.getConditions());
    return buildable;
  }
}
