/*
Copyright 2022 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;

/** Generated */
public interface V2beta2ResourceMetricSourceFluent<A extends V2beta2ResourceMetricSourceFluent<A>>
    extends Fluent<A> {
  public String getName();

  public A withName(java.lang.String name);

  public Boolean hasName();

  /**
   * This method has been deprecated, please use method buildTarget instead.
   *
   * @return The buildable object.
   */
  @Deprecated
  public V2beta2MetricTarget getTarget();

  public io.kubernetes.client.openapi.models.V2beta2MetricTarget buildTarget();

  public A withTarget(io.kubernetes.client.openapi.models.V2beta2MetricTarget target);

  public java.lang.Boolean hasTarget();

  public V2beta2ResourceMetricSourceFluent.TargetNested<A> withNewTarget();

  public io.kubernetes.client.openapi.models.V2beta2ResourceMetricSourceFluent.TargetNested<A>
      withNewTargetLike(io.kubernetes.client.openapi.models.V2beta2MetricTarget item);

  public io.kubernetes.client.openapi.models.V2beta2ResourceMetricSourceFluent.TargetNested<A>
      editTarget();

  public io.kubernetes.client.openapi.models.V2beta2ResourceMetricSourceFluent.TargetNested<A>
      editOrNewTarget();

  public io.kubernetes.client.openapi.models.V2beta2ResourceMetricSourceFluent.TargetNested<A>
      editOrNewTargetLike(io.kubernetes.client.openapi.models.V2beta2MetricTarget item);

  public interface TargetNested<N>
      extends Nested<N>,
          V2beta2MetricTargetFluent<V2beta2ResourceMetricSourceFluent.TargetNested<N>> {
    public N and();

    public N endTarget();
  }
}
