/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestSpec;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CertificateSigningRequestSpecFluentImpl<A extends V1CertificateSigningRequestSpecFluent<A>>
extends BaseFluent<A>
implements V1CertificateSigningRequestSpecFluent<A> {
    private Integer expirationSeconds;
    private Map<String, List<String>> extra;
    private List<String> groups;
    private List<Byte> request;
    private String signerName;
    private String uid;
    private List<String> usages;
    private String username;

    public V1CertificateSigningRequestSpecFluentImpl() {
    }

    public V1CertificateSigningRequestSpecFluentImpl(V1CertificateSigningRequestSpec instance) {
        this.withExpirationSeconds(instance.getExpirationSeconds());
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withRequest(instance.getRequest());
        this.withSignerName(instance.getSignerName());
        this.withUid(instance.getUid());
        this.withUsages(instance.getUsages());
        this.withUsername(instance.getUsername());
    }

    @Override
    public Integer getExpirationSeconds() {
        return this.expirationSeconds;
    }

    @Override
    public A withExpirationSeconds(Integer expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    @Override
    public A addToExtra(String key, List<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, List<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, List<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    @Override
    public <K, V> A withExtra(Map<String, List<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, List<String>>(extra);
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(Integer index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A withRequest(byte ... request) {
        if (this.request != null) {
            this.request.clear();
        }
        if (request != null) {
            for (byte item : request) {
                this.addToRequest(item);
            }
        }
        return (A)this;
    }

    @Override
    public byte[] getRequest() {
        int size = this.request != null ? this.request.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.request) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToRequest(Integer index, Byte item) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        this.request.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequest(Integer index, Byte item) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        this.request.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequest(Byte ... items) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.request.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequest(Collection<Byte> items) {
        if (this.request == null) {
            this.request = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.request.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequest(Byte ... items) {
        for (Byte item : items) {
            if (this.request == null) continue;
            this.request.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequest(Collection<Byte> items) {
        for (Byte item : items) {
            if (this.request == null) continue;
            this.request.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    @Override
    public String getSignerName() {
        return this.signerName;
    }

    @Override
    public A withSignerName(String signerName) {
        this.signerName = signerName;
        return (A)this;
    }

    @Override
    public Boolean hasSignerName() {
        return this.signerName != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A addToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsages(String ... items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsages() {
        return this.usages;
    }

    @Override
    public String getUsage(Integer index) {
        return this.usages.get(index);
    }

    @Override
    public String getFirstUsage() {
        return this.usages.get(0);
    }

    @Override
    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    @Override
    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)this;
    }

    @Override
    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CertificateSigningRequestSpecFluentImpl that = (V1CertificateSigningRequestSpecFluentImpl)o;
        if (this.expirationSeconds != null ? !this.expirationSeconds.equals(that.expirationSeconds) : that.expirationSeconds != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        if (this.signerName != null ? !this.signerName.equals(that.signerName) : that.signerName != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        if (this.usages != null ? !this.usages.equals(that.usages) : that.usages != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expirationSeconds, this.extra, this.groups, this.request, this.signerName, this.uid, this.usages, this.username, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.expirationSeconds != null) {
            sb.append("expirationSeconds:");
            sb.append(this.expirationSeconds + ",");
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.request != null && !this.request.isEmpty()) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.signerName != null) {
            sb.append("signerName:");
            sb.append(this.signerName + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
        }
        sb.append("}");
        return sb.toString();
    }
}

