/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class V1ConfigMapFluentImpl<A extends V1ConfigMapFluent<A>>
extends BaseFluent<A>
implements V1ConfigMapFluent<A> {
    private String apiVersion;
    private Map<String, byte[]> binaryData;
    private Map<String, String> data;
    private Boolean immutable;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1ConfigMapFluentImpl() {
    }

    public V1ConfigMapFluentImpl(V1ConfigMap instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withBinaryData(instance.getBinaryData());
        this.withData(instance.getData());
        this.withImmutable(instance.getImmutable());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToBinaryData(String key, byte[] value) {
        if (this.binaryData == null && key != null && value != null) {
            this.binaryData = new LinkedHashMap<String, byte[]>();
        }
        if (key != null && value != null) {
            this.binaryData.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToBinaryData(Map<String, byte[]> map) {
        if (this.binaryData == null && map != null) {
            this.binaryData = new LinkedHashMap<String, byte[]>();
        }
        if (map != null) {
            this.binaryData.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromBinaryData(String key) {
        if (this.binaryData == null) {
            return (A)this;
        }
        if (key != null && this.binaryData != null) {
            this.binaryData.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromBinaryData(Map<String, byte[]> map) {
        if (this.binaryData == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.binaryData == null) continue;
                this.binaryData.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, byte[]> getBinaryData() {
        return this.binaryData;
    }

    @Override
    public <K, V> A withBinaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData == null ? null : new LinkedHashMap<String, byte[]>(binaryData);
        return (A)this;
    }

    @Override
    public Boolean hasBinaryData() {
        return this.binaryData != null;
    }

    @Override
    public A addToData(String key, String value) {
        if (this.data == null && key != null && value != null) {
            this.data = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.data.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToData(Map<String, String> map) {
        if (this.data == null && map != null) {
            this.data = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.data.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromData(String key) {
        if (this.data == null) {
            return (A)this;
        }
        if (key != null && this.data != null) {
            this.data.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromData(Map<String, String> map) {
        if (this.data == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.data == null) continue;
                this.data.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public <K, V> A withData(Map<String, String> data) {
        this.data = data == null ? null : new LinkedHashMap<String, String>(data);
        return (A)this;
    }

    @Override
    public Boolean hasData() {
        return this.data != null;
    }

    @Override
    public Boolean getImmutable() {
        return this.immutable;
    }

    @Override
    public A withImmutable(Boolean immutable) {
        this.immutable = immutable;
        return (A)this;
    }

    @Override
    public Boolean hasImmutable() {
        return this.immutable != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ConfigMapFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ConfigMapFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ConfigMapFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ConfigMapFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ConfigMapFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMapFluentImpl that = (V1ConfigMapFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.binaryData != null ? !this.binaryData.equals(that.binaryData) : that.binaryData != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.immutable != null ? !this.immutable.equals(that.immutable) : that.immutable != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binaryData, this.data, this.immutable, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.binaryData != null && !this.binaryData.isEmpty()) {
            sb.append("binaryData:");
            sb.append(this.binaryData + ",");
        }
        if (this.data != null && !this.data.isEmpty()) {
            sb.append("data:");
            sb.append(this.data + ",");
        }
        if (this.immutable != null) {
            sb.append("immutable:");
            sb.append(this.immutable + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withImmutable() {
        return this.withImmutable(true);
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ConfigMapFluent.MetadataNested<N>>
    implements V1ConfigMapFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ConfigMapFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

