/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateBuilder;
import io.kubernetes.client.openapi.models.V1ContainerStateFluentImpl;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ContainerStatusFluent;
import java.util.Objects;

public class V1ContainerStatusFluentImpl<A extends V1ContainerStatusFluent<A>>
extends BaseFluent<A>
implements V1ContainerStatusFluent<A> {
    private String containerID;
    private String image;
    private String imageID;
    private V1ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private Integer restartCount;
    private Boolean started;
    private V1ContainerStateBuilder state;

    public V1ContainerStatusFluentImpl() {
    }

    public V1ContainerStatusFluentImpl(V1ContainerStatus instance) {
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withStarted(instance.getStarted());
        this.withState(instance.getState());
    }

    @Override
    public String getContainerID() {
        return this.containerID;
    }

    @Override
    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    @Override
    public Boolean hasContainerID() {
        return this.containerID != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    @Override
    public Boolean hasImageID() {
        return this.imageID != null;
    }

    @Override
    @Deprecated
    public V1ContainerState getLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public V1ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public A withLastState(V1ContainerState lastState) {
        this._visitables.get("lastState").remove(this.lastState);
        if (lastState != null) {
            this.lastState = new V1ContainerStateBuilder(lastState);
            this._visitables.get("lastState").add(this.lastState);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastState() {
        return this.lastState != null;
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> withNewLastState() {
        return new LastStateNestedImpl();
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(V1ContainerState item) {
        return new LastStateNestedImpl(item);
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(this.getLastState());
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : new V1ContainerStateBuilder().build());
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(V1ContainerState item) {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Boolean getReady() {
        return this.ready;
    }

    @Override
    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Boolean hasReady() {
        return this.ready != null;
    }

    @Override
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @Override
    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)this;
    }

    @Override
    public Boolean hasRestartCount() {
        return this.restartCount != null;
    }

    @Override
    public Boolean getStarted() {
        return this.started;
    }

    @Override
    public A withStarted(Boolean started) {
        this.started = started;
        return (A)this;
    }

    @Override
    public Boolean hasStarted() {
        return this.started != null;
    }

    @Override
    @Deprecated
    public V1ContainerState getState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public V1ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public A withState(V1ContainerState state) {
        this._visitables.get("state").remove(this.state);
        if (state != null) {
            this.state = new V1ContainerStateBuilder(state);
            this._visitables.get("state").add(this.state);
        }
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> withNewState() {
        return new StateNestedImpl();
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> withNewStateLike(V1ContainerState item) {
        return new StateNestedImpl(item);
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> editState() {
        return this.withNewStateLike(this.getState());
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> editOrNewState() {
        return this.withNewStateLike(this.getState() != null ? this.getState() : new V1ContainerStateBuilder().build());
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> editOrNewStateLike(V1ContainerState item) {
        return this.withNewStateLike(this.getState() != null ? this.getState() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatusFluentImpl that = (V1ContainerStatusFluentImpl)o;
        if (this.containerID != null ? !this.containerID.equals(that.containerID) : that.containerID != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageID != null ? !this.imageID.equals(that.imageID) : that.imageID != null) {
            return false;
        }
        if (this.lastState != null ? !this.lastState.equals(that.lastState) : that.lastState != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ready != null ? !this.ready.equals(that.ready) : that.ready != null) {
            return false;
        }
        if (this.restartCount != null ? !this.restartCount.equals(that.restartCount) : that.restartCount != null) {
            return false;
        }
        if (this.started != null ? !this.started.equals(that.started) : that.started != null) {
            return false;
        }
        return !(this.state != null ? !this.state.equals(that.state) : that.state != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.restartCount, this.started, this.state, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerID != null) {
            sb.append("containerID:");
            sb.append(this.containerID + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.lastState != null) {
            sb.append("lastState:");
            sb.append(this.lastState + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.started != null) {
            sb.append("started:");
            sb.append(this.started + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReady() {
        return this.withReady(true);
    }

    @Override
    public A withStarted() {
        return this.withStarted(true);
    }

    class StateNestedImpl<N>
    extends V1ContainerStateFluentImpl<V1ContainerStatusFluent.StateNested<N>>
    implements V1ContainerStatusFluent.StateNested<N>,
    Nested<N> {
        V1ContainerStateBuilder builder;

        StateNestedImpl(V1ContainerState item) {
            this.builder = new V1ContainerStateBuilder(this, item);
        }

        StateNestedImpl() {
            this.builder = new V1ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluentImpl.this.withState(this.builder.build());
        }

        @Override
        public N endState() {
            return this.and();
        }
    }

    class LastStateNestedImpl<N>
    extends V1ContainerStateFluentImpl<V1ContainerStatusFluent.LastStateNested<N>>
    implements V1ContainerStatusFluent.LastStateNested<N>,
    Nested<N> {
        V1ContainerStateBuilder builder;

        LastStateNestedImpl(V1ContainerState item) {
            this.builder = new V1ContainerStateBuilder(this, item);
        }

        LastStateNestedImpl() {
            this.builder = new V1ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluentImpl.this.withLastState(this.builder.build());
        }

        @Override
        public N endLastState() {
            return this.and();
        }
    }
}

