/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2beta1CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2beta1CrossVersionObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V2beta1CrossVersionObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V2beta1HorizontalPodAutoscalerSpec;
import io.kubernetes.client.openapi.models.V2beta1HorizontalPodAutoscalerSpecFluent;
import io.kubernetes.client.openapi.models.V2beta1MetricSpec;
import io.kubernetes.client.openapi.models.V2beta1MetricSpecBuilder;
import io.kubernetes.client.openapi.models.V2beta1MetricSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V2beta1HorizontalPodAutoscalerSpecFluentImpl<A extends V2beta1HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements V2beta1HorizontalPodAutoscalerSpecFluent<A> {
    private Integer maxReplicas;
    private ArrayList<V2beta1MetricSpecBuilder> metrics;
    private Integer minReplicas;
    private V2beta1CrossVersionObjectReferenceBuilder scaleTargetRef;

    public V2beta1HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public V2beta1HorizontalPodAutoscalerSpecFluentImpl(V2beta1HorizontalPodAutoscalerSpec instance) {
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMetrics(instance.getMetrics());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public A addToMetrics(Integer index, V2beta1MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        V2beta1MetricSpecBuilder builder = new V2beta1MetricSpecBuilder(item);
        this._visitables.get("metrics").add(index >= 0 ? index.intValue() : this._visitables.get("metrics").size(), builder);
        this.metrics.add(index >= 0 ? index.intValue() : this.metrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetrics(Integer index, V2beta1MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        V2beta1MetricSpecBuilder builder = new V2beta1MetricSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("metrics").size()) {
            this._visitables.get("metrics").add(builder);
        } else {
            this._visitables.get("metrics").set(index, builder);
        }
        if (index < 0 || index >= this.metrics.size()) {
            this.metrics.add(builder);
        } else {
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(V2beta1MetricSpec ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (V2beta1MetricSpec item : items) {
            V2beta1MetricSpecBuilder builder = new V2beta1MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetrics(Collection<V2beta1MetricSpec> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (V2beta1MetricSpec item : items) {
            V2beta1MetricSpecBuilder builder = new V2beta1MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(V2beta1MetricSpec ... items) {
        for (V2beta1MetricSpec item : items) {
            V2beta1MetricSpecBuilder builder = new V2beta1MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetrics(Collection<V2beta1MetricSpec> items) {
        for (V2beta1MetricSpec item : items) {
            V2beta1MetricSpecBuilder builder = new V2beta1MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMetrics(Predicate<V2beta1MetricSpecBuilder> predicate) {
        if (this.metrics == null) {
            return (A)this;
        }
        Iterator<V2beta1MetricSpecBuilder> each = this.metrics.iterator();
        Object visitables = this._visitables.get("metrics");
        while (each.hasNext()) {
            V2beta1MetricSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V2beta1MetricSpec> getMetrics() {
        return this.metrics != null ? V2beta1HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics) : null;
    }

    @Override
    public List<V2beta1MetricSpec> buildMetrics() {
        return this.metrics != null ? V2beta1HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics) : null;
    }

    @Override
    public V2beta1MetricSpec buildMetric(Integer index) {
        return this.metrics.get(index).build();
    }

    @Override
    public V2beta1MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    @Override
    public V2beta1MetricSpec buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    @Override
    public V2beta1MetricSpec buildMatchingMetric(Predicate<V2beta1MetricSpecBuilder> predicate) {
        for (V2beta1MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMetric(Predicate<V2beta1MetricSpecBuilder> predicate) {
        for (V2beta1MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMetrics(List<V2beta1MetricSpec> metrics) {
        if (this.metrics != null) {
            this._visitables.get("metrics").removeAll(this.metrics);
        }
        if (metrics != null) {
            this.metrics = new ArrayList();
            for (V2beta1MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    @Override
    public A withMetrics(V2beta1MetricSpec ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
        }
        if (metrics != null) {
            for (V2beta1MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
        return new MetricsNestedImpl();
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(V2beta1MetricSpec item) {
        return new MetricsNestedImpl(-1, item);
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(Integer index, V2beta1MetricSpec item) {
        return new MetricsNestedImpl(index, item);
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(Integer index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<V2beta1MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.test(this.metrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    @Deprecated
    public V2beta1CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public V2beta1CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(V2beta1CrossVersionObjectReference scaleTargetRef) {
        this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new V2beta1CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(V2beta1CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new V2beta1CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(V2beta1CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1HorizontalPodAutoscalerSpecFluentImpl that = (V2beta1HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        return !(this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.metrics != null && !this.metrics.isEmpty()) {
            sb.append("metrics:");
            sb.append(this.metrics + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef);
        }
        sb.append("}");
        return sb.toString();
    }

    class ScaleTargetRefNestedImpl<N>
    extends V2beta1CrossVersionObjectReferenceFluentImpl<V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements V2beta1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        V2beta1CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(V2beta1CrossVersionObjectReference item) {
            this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }

    class MetricsNestedImpl<N>
    extends V2beta1MetricSpecFluentImpl<V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<N>>
    implements V2beta1HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,
    Nested<N> {
        V2beta1MetricSpecBuilder builder;
        Integer index;

        MetricsNestedImpl(Integer index, V2beta1MetricSpec item) {
            this.index = index;
            this.builder = new V2beta1MetricSpecBuilder(this, item);
        }

        MetricsNestedImpl() {
            this.index = -1;
            this.builder = new V2beta1MetricSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(this.index, this.builder.build());
        }

        @Override
        public N endMetric() {
            return this.and();
        }
    }
}

