/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValue;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValueBuilder;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValueFluent;
import io.kubernetes.client.openapi.models.V1IngressRule;
import java.util.Objects;
import java.util.Optional;

public class V1IngressRuleFluent<A extends V1IngressRuleFluent<A>>
extends BaseFluent<A> {
    private String host;
    private V1HTTPIngressRuleValueBuilder http;

    public V1IngressRuleFluent() {
    }

    public V1IngressRuleFluent(V1IngressRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IngressRule instance) {
        V1IngressRule v1IngressRule = instance = instance != null ? instance : new V1IngressRule();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttp(instance.getHttp());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public V1HTTPIngressRuleValue buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    public A withHttp(V1HTTPIngressRuleValue http) {
        this._visitables.remove("http");
        if (http != null) {
            this.http = new V1HTTPIngressRuleValueBuilder(http);
            this._visitables.get("http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get("http").remove(this.http);
        }
        return (A)this;
    }

    public boolean hasHttp() {
        return this.http != null;
    }

    public HttpNested<A> withNewHttp() {
        return new HttpNested(null);
    }

    public HttpNested<A> withNewHttpLike(V1HTTPIngressRuleValue item) {
        return new HttpNested(item);
    }

    public HttpNested<A> editHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(null));
    }

    public HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(new V1HTTPIngressRuleValueBuilder().build()));
    }

    public HttpNested<A> editOrNewHttpLike(V1HTTPIngressRuleValue item) {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressRuleFluent that = (V1IngressRuleFluent)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        return Objects.equals(this.http, that.http);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.http, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append(this.http);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpNested<N>
    extends V1HTTPIngressRuleValueFluent<HttpNested<N>>
    implements Nested<N> {
        V1HTTPIngressRuleValueBuilder builder;

        HttpNested(V1HTTPIngressRuleValue item) {
            this.builder = new V1HTTPIngressRuleValueBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressRuleFluent.this.withHttp(this.builder.build());
        }

        public N endHttp() {
            return this.and();
        }
    }
}

