/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1PodFailurePolicy;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyBuilder;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyFluent;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import java.util.Objects;
import java.util.Optional;

public class V1JobSpecFluent<A extends V1JobSpecFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private Integer backoffLimit;
    private Integer backoffLimitPerIndex;
    private String completionMode;
    private Integer completions;
    private Boolean manualSelector;
    private Integer maxFailedIndexes;
    private Integer parallelism;
    private V1PodFailurePolicyBuilder podFailurePolicy;
    private String podReplacementPolicy;
    private V1LabelSelectorBuilder selector;
    private Boolean suspend;
    private V1PodTemplateSpecBuilder template;
    private Integer ttlSecondsAfterFinished;

    public V1JobSpecFluent() {
    }

    public V1JobSpecFluent(V1JobSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1JobSpec instance) {
        V1JobSpec v1JobSpec = instance = instance != null ? instance : new V1JobSpec();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withBackoffLimit(instance.getBackoffLimit());
            this.withBackoffLimitPerIndex(instance.getBackoffLimitPerIndex());
            this.withCompletionMode(instance.getCompletionMode());
            this.withCompletions(instance.getCompletions());
            this.withManualSelector(instance.getManualSelector());
            this.withMaxFailedIndexes(instance.getMaxFailedIndexes());
            this.withParallelism(instance.getParallelism());
            this.withPodFailurePolicy(instance.getPodFailurePolicy());
            this.withPodReplacementPolicy(instance.getPodReplacementPolicy());
            this.withSelector(instance.getSelector());
            this.withSuspend(instance.getSuspend());
            this.withTemplate(instance.getTemplate());
            this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)this;
    }

    public boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    public Integer getBackoffLimitPerIndex() {
        return this.backoffLimitPerIndex;
    }

    public A withBackoffLimitPerIndex(Integer backoffLimitPerIndex) {
        this.backoffLimitPerIndex = backoffLimitPerIndex;
        return (A)this;
    }

    public boolean hasBackoffLimitPerIndex() {
        return this.backoffLimitPerIndex != null;
    }

    public String getCompletionMode() {
        return this.completionMode;
    }

    public A withCompletionMode(String completionMode) {
        this.completionMode = completionMode;
        return (A)this;
    }

    public boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    public Integer getCompletions() {
        return this.completions;
    }

    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)this;
    }

    public boolean hasCompletions() {
        return this.completions != null;
    }

    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    public A withManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return (A)this;
    }

    public boolean hasManualSelector() {
        return this.manualSelector != null;
    }

    public Integer getMaxFailedIndexes() {
        return this.maxFailedIndexes;
    }

    public A withMaxFailedIndexes(Integer maxFailedIndexes) {
        this.maxFailedIndexes = maxFailedIndexes;
        return (A)this;
    }

    public boolean hasMaxFailedIndexes() {
        return this.maxFailedIndexes != null;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)this;
    }

    public boolean hasParallelism() {
        return this.parallelism != null;
    }

    public V1PodFailurePolicy buildPodFailurePolicy() {
        return this.podFailurePolicy != null ? this.podFailurePolicy.build() : null;
    }

    public A withPodFailurePolicy(V1PodFailurePolicy podFailurePolicy) {
        this._visitables.remove("podFailurePolicy");
        if (podFailurePolicy != null) {
            this.podFailurePolicy = new V1PodFailurePolicyBuilder(podFailurePolicy);
            this._visitables.get("podFailurePolicy").add(this.podFailurePolicy);
        } else {
            this.podFailurePolicy = null;
            this._visitables.get("podFailurePolicy").remove(this.podFailurePolicy);
        }
        return (A)this;
    }

    public boolean hasPodFailurePolicy() {
        return this.podFailurePolicy != null;
    }

    public PodFailurePolicyNested<A> withNewPodFailurePolicy() {
        return new PodFailurePolicyNested(null);
    }

    public PodFailurePolicyNested<A> withNewPodFailurePolicyLike(V1PodFailurePolicy item) {
        return new PodFailurePolicyNested(item);
    }

    public PodFailurePolicyNested<A> editPodFailurePolicy() {
        return this.withNewPodFailurePolicyLike(Optional.ofNullable(this.buildPodFailurePolicy()).orElse(null));
    }

    public PodFailurePolicyNested<A> editOrNewPodFailurePolicy() {
        return this.withNewPodFailurePolicyLike(Optional.ofNullable(this.buildPodFailurePolicy()).orElse(new V1PodFailurePolicyBuilder().build()));
    }

    public PodFailurePolicyNested<A> editOrNewPodFailurePolicyLike(V1PodFailurePolicy item) {
        return this.withNewPodFailurePolicyLike(Optional.ofNullable(this.buildPodFailurePolicy()).orElse(item));
    }

    public String getPodReplacementPolicy() {
        return this.podReplacementPolicy;
    }

    public A withPodReplacementPolicy(String podReplacementPolicy) {
        this.podReplacementPolicy = podReplacementPolicy;
        return (A)this;
    }

    public boolean hasPodReplacementPolicy() {
        return this.podReplacementPolicy != null;
    }

    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(V1LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new V1PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)this;
    }

    public boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1JobSpecFluent that = (V1JobSpecFluent)o;
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimit, that.backoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimitPerIndex, that.backoffLimitPerIndex)) {
            return false;
        }
        if (!Objects.equals(this.completionMode, that.completionMode)) {
            return false;
        }
        if (!Objects.equals(this.completions, that.completions)) {
            return false;
        }
        if (!Objects.equals(this.manualSelector, that.manualSelector)) {
            return false;
        }
        if (!Objects.equals(this.maxFailedIndexes, that.maxFailedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.parallelism, that.parallelism)) {
            return false;
        }
        if (!Objects.equals(this.podFailurePolicy, that.podFailurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.podReplacementPolicy, that.podReplacementPolicy)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.ttlSecondsAfterFinished, that.ttlSecondsAfterFinished);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.backoffLimitPerIndex, this.completionMode, this.completions, this.manualSelector, this.maxFailedIndexes, this.parallelism, this.podFailurePolicy, this.podReplacementPolicy, this.selector, this.suspend, this.template, this.ttlSecondsAfterFinished, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.backoffLimit != null) {
            sb.append("backoffLimit:");
            sb.append(this.backoffLimit + ",");
        }
        if (this.backoffLimitPerIndex != null) {
            sb.append("backoffLimitPerIndex:");
            sb.append(this.backoffLimitPerIndex + ",");
        }
        if (this.completionMode != null) {
            sb.append("completionMode:");
            sb.append(this.completionMode + ",");
        }
        if (this.completions != null) {
            sb.append("completions:");
            sb.append(this.completions + ",");
        }
        if (this.manualSelector != null) {
            sb.append("manualSelector:");
            sb.append(this.manualSelector + ",");
        }
        if (this.maxFailedIndexes != null) {
            sb.append("maxFailedIndexes:");
            sb.append(this.maxFailedIndexes + ",");
        }
        if (this.parallelism != null) {
            sb.append("parallelism:");
            sb.append(this.parallelism + ",");
        }
        if (this.podFailurePolicy != null) {
            sb.append("podFailurePolicy:");
            sb.append(this.podFailurePolicy + ",");
        }
        if (this.podReplacementPolicy != null) {
            sb.append("podReplacementPolicy:");
            sb.append(this.podReplacementPolicy + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.ttlSecondsAfterFinished != null) {
            sb.append("ttlSecondsAfterFinished:");
            sb.append(this.ttlSecondsAfterFinished);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withManualSelector() {
        return this.withManualSelector(true);
    }

    public A withSuspend() {
        return this.withSuspend(true);
    }

    public class PodFailurePolicyNested<N>
    extends V1PodFailurePolicyFluent<PodFailurePolicyNested<N>>
    implements Nested<N> {
        V1PodFailurePolicyBuilder builder;

        PodFailurePolicyNested(V1PodFailurePolicy item) {
            this.builder = new V1PodFailurePolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1JobSpecFluent.this.withPodFailurePolicy(this.builder.build());
        }

        public N endPodFailurePolicy() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends V1LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1JobSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends V1PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        V1PodTemplateSpecBuilder builder;

        TemplateNested(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1JobSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

