/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1PortStatus;
import io.kubernetes.client.openapi.models.V1PortStatusBuilder;
import io.kubernetes.client.openapi.models.V1PortStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LoadBalancerIngressFluent<A extends V1LoadBalancerIngressFluent<A>>
extends BaseFluent<A> {
    private String hostname;
    private String ip;
    private ArrayList<V1PortStatusBuilder> ports;

    public V1LoadBalancerIngressFluent() {
    }

    public V1LoadBalancerIngressFluent(V1LoadBalancerIngress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1LoadBalancerIngress instance) {
        V1LoadBalancerIngress v1LoadBalancerIngress = instance = instance != null ? instance : new V1LoadBalancerIngress();
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withIp(instance.getIp());
            this.withPorts(instance.getPorts());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    public A addToPorts(int index, V1PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, V1PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(V1PortStatus ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<V1PortStatus> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(V1PortStatus ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<V1PortStatus> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<V1PortStatusBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1PortStatusBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1PortStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PortStatus> buildPorts() {
        return this.ports != null ? V1LoadBalancerIngressFluent.build(this.ports) : null;
    }

    public V1PortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    public V1PortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    public V1PortStatus buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public V1PortStatus buildMatchingPort(Predicate<V1PortStatusBuilder> predicate) {
        for (V1PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<V1PortStatusBuilder> predicate) {
        for (V1PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<V1PortStatus> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (V1PortStatus item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(V1PortStatus ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (V1PortStatus item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(V1PortStatus item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, V1PortStatus item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<V1PortStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LoadBalancerIngressFluent that = (V1LoadBalancerIngressFluent)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        return Objects.equals(this.ports, that.ports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortsNested<N>
    extends V1PortStatusFluent<PortsNested<N>>
    implements Nested<N> {
        V1PortStatusBuilder builder;
        int index;

        PortsNested(int index, V1PortStatus item) {
            this.index = index;
            this.builder = new V1PortStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1LoadBalancerIngressFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

