/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1beta3LimitResponse;
import io.kubernetes.client.openapi.models.V1beta3LimitResponseBuilder;
import io.kubernetes.client.openapi.models.V1beta3LimitResponseFluent;
import io.kubernetes.client.openapi.models.V1beta3LimitedPriorityLevelConfiguration;
import java.util.Objects;
import java.util.Optional;

public class V1beta3LimitedPriorityLevelConfigurationFluent<A extends V1beta3LimitedPriorityLevelConfigurationFluent<A>>
extends BaseFluent<A> {
    private Integer borrowingLimitPercent;
    private Integer lendablePercent;
    private V1beta3LimitResponseBuilder limitResponse;
    private Integer nominalConcurrencyShares;

    public V1beta3LimitedPriorityLevelConfigurationFluent() {
    }

    public V1beta3LimitedPriorityLevelConfigurationFluent(V1beta3LimitedPriorityLevelConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta3LimitedPriorityLevelConfiguration instance) {
        V1beta3LimitedPriorityLevelConfiguration v1beta3LimitedPriorityLevelConfiguration = instance = instance != null ? instance : new V1beta3LimitedPriorityLevelConfiguration();
        if (instance != null) {
            this.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
            this.withLendablePercent(instance.getLendablePercent());
            this.withLimitResponse(instance.getLimitResponse());
            this.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
        }
    }

    public Integer getBorrowingLimitPercent() {
        return this.borrowingLimitPercent;
    }

    public A withBorrowingLimitPercent(Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
        return (A)this;
    }

    public boolean hasBorrowingLimitPercent() {
        return this.borrowingLimitPercent != null;
    }

    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    public A withLendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return (A)this;
    }

    public boolean hasLendablePercent() {
        return this.lendablePercent != null;
    }

    public V1beta3LimitResponse buildLimitResponse() {
        return this.limitResponse != null ? this.limitResponse.build() : null;
    }

    public A withLimitResponse(V1beta3LimitResponse limitResponse) {
        this._visitables.remove("limitResponse");
        if (limitResponse != null) {
            this.limitResponse = new V1beta3LimitResponseBuilder(limitResponse);
            this._visitables.get("limitResponse").add(this.limitResponse);
        } else {
            this.limitResponse = null;
            this._visitables.get("limitResponse").remove(this.limitResponse);
        }
        return (A)this;
    }

    public boolean hasLimitResponse() {
        return this.limitResponse != null;
    }

    public LimitResponseNested<A> withNewLimitResponse() {
        return new LimitResponseNested(null);
    }

    public LimitResponseNested<A> withNewLimitResponseLike(V1beta3LimitResponse item) {
        return new LimitResponseNested(item);
    }

    public LimitResponseNested<A> editLimitResponse() {
        return this.withNewLimitResponseLike(Optional.ofNullable(this.buildLimitResponse()).orElse(null));
    }

    public LimitResponseNested<A> editOrNewLimitResponse() {
        return this.withNewLimitResponseLike(Optional.ofNullable(this.buildLimitResponse()).orElse(new V1beta3LimitResponseBuilder().build()));
    }

    public LimitResponseNested<A> editOrNewLimitResponseLike(V1beta3LimitResponse item) {
        return this.withNewLimitResponseLike(Optional.ofNullable(this.buildLimitResponse()).orElse(item));
    }

    public Integer getNominalConcurrencyShares() {
        return this.nominalConcurrencyShares;
    }

    public A withNominalConcurrencyShares(Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
        return (A)this;
    }

    public boolean hasNominalConcurrencyShares() {
        return this.nominalConcurrencyShares != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta3LimitedPriorityLevelConfigurationFluent that = (V1beta3LimitedPriorityLevelConfigurationFluent)o;
        if (!Objects.equals(this.borrowingLimitPercent, that.borrowingLimitPercent)) {
            return false;
        }
        if (!Objects.equals(this.lendablePercent, that.lendablePercent)) {
            return false;
        }
        if (!Objects.equals(this.limitResponse, that.limitResponse)) {
            return false;
        }
        return Objects.equals(this.nominalConcurrencyShares, that.nominalConcurrencyShares);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.borrowingLimitPercent, this.lendablePercent, this.limitResponse, this.nominalConcurrencyShares, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.borrowingLimitPercent != null) {
            sb.append("borrowingLimitPercent:");
            sb.append(this.borrowingLimitPercent + ",");
        }
        if (this.lendablePercent != null) {
            sb.append("lendablePercent:");
            sb.append(this.lendablePercent + ",");
        }
        if (this.limitResponse != null) {
            sb.append("limitResponse:");
            sb.append(this.limitResponse + ",");
        }
        if (this.nominalConcurrencyShares != null) {
            sb.append("nominalConcurrencyShares:");
            sb.append(this.nominalConcurrencyShares);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LimitResponseNested<N>
    extends V1beta3LimitResponseFluent<LimitResponseNested<N>>
    implements Nested<N> {
        V1beta3LimitResponseBuilder builder;

        LimitResponseNested(V1beta3LimitResponse item) {
            this.builder = new V1beta3LimitResponseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta3LimitedPriorityLevelConfigurationFluent.this.withLimitResponse(this.builder.build());
        }

        public N endLimitResponse() {
            return this.and();
        }
    }
}

