/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CertificateSigningRequestStatus contains conditions used to indicate approved/denied/failed status of the request, and the issued certificate.")
public class V1CertificateSigningRequestStatus {
    public static final String SERIALIZED_NAME_CERTIFICATE = "certificate";
    @SerializedName(value="certificate")
    private byte[] certificate;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1CertificateSigningRequestCondition> conditions = null;

    public V1CertificateSigningRequestStatus certificate(byte[] certificate) {
        this.certificate = certificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="certificate is populated with an issued certificate by the signer after an Approved condition is present. This field is set via the /status subresource. Once populated, this field is immutable.  If the certificate signing request is denied, a condition of type \"Denied\" is added and this field remains empty. If the signer cannot issue the certificate, a condition of type \"Failed\" is added and this field remains empty.  Validation requirements:  1. certificate must contain one or more PEM blocks.  2. All PEM blocks must have the \"CERTIFICATE\" label, contain no headers, and the encoded data   must be a BER-encoded ASN.1 Certificate structure as described in section 4 of RFC5280.  3. Non-PEM content may appear before or after the \"CERTIFICATE\" PEM blocks and is unvalidated,   to allow for explanatory text as described in section 5.2 of RFC7468.  If more than one PEM block is present, and the definition of the requested spec.signerName does not indicate otherwise, the first block is the issued certificate, and subsequent blocks should be treated as intermediate certificates and presented in TLS handshakes.  The certificate is encoded in PEM format.  When serialized as JSON or YAML, the data is additionally base64-encoded, so it consists of:      base64(     -----BEGIN CERTIFICATE-----     ...     -----END CERTIFICATE-----     )")
    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public V1CertificateSigningRequestStatus conditions(List<V1CertificateSigningRequestCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1CertificateSigningRequestStatus addConditionsItem(V1CertificateSigningRequestCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1CertificateSigningRequestCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="conditions applied to the request. Known conditions are \"Approved\", \"Denied\", and \"Failed\".")
    public List<V1CertificateSigningRequestCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1CertificateSigningRequestCondition> conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CertificateSigningRequestStatus v1CertificateSigningRequestStatus = (V1CertificateSigningRequestStatus)o;
        return Arrays.equals(this.certificate, v1CertificateSigningRequestStatus.certificate) && Objects.equals(this.conditions, v1CertificateSigningRequestStatus.conditions);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.certificate), this.conditions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CertificateSigningRequestStatus {\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

