/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressBackendBuilder;
import io.kubernetes.client.openapi.models.V1IngressBackendFluent;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressRuleBuilder;
import io.kubernetes.client.openapi.models.V1IngressRuleFluent;
import io.kubernetes.client.openapi.models.V1IngressSpec;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1IngressTLSBuilder;
import io.kubernetes.client.openapi.models.V1IngressTLSFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1IngressSpecFluent<A extends V1IngressSpecFluent<A>>
extends BaseFluent<A> {
    private V1IngressBackendBuilder defaultBackend;
    private String ingressClassName;
    private ArrayList<V1IngressRuleBuilder> rules;
    private ArrayList<V1IngressTLSBuilder> tls;

    public V1IngressSpecFluent() {
    }

    public V1IngressSpecFluent(V1IngressSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IngressSpec instance) {
        V1IngressSpec v1IngressSpec = instance = instance != null ? instance : new V1IngressSpec();
        if (instance != null) {
            this.withDefaultBackend(instance.getDefaultBackend());
            this.withIngressClassName(instance.getIngressClassName());
            this.withRules(instance.getRules());
            this.withTls(instance.getTls());
        }
    }

    public V1IngressBackend buildDefaultBackend() {
        return this.defaultBackend != null ? this.defaultBackend.build() : null;
    }

    public A withDefaultBackend(V1IngressBackend defaultBackend) {
        this._visitables.remove("defaultBackend");
        if (defaultBackend != null) {
            this.defaultBackend = new V1IngressBackendBuilder(defaultBackend);
            this._visitables.get("defaultBackend").add(this.defaultBackend);
        } else {
            this.defaultBackend = null;
            this._visitables.get("defaultBackend").remove(this.defaultBackend);
        }
        return (A)this;
    }

    public boolean hasDefaultBackend() {
        return this.defaultBackend != null;
    }

    public DefaultBackendNested<A> withNewDefaultBackend() {
        return new DefaultBackendNested(null);
    }

    public DefaultBackendNested<A> withNewDefaultBackendLike(V1IngressBackend item) {
        return new DefaultBackendNested(item);
    }

    public DefaultBackendNested<A> editDefaultBackend() {
        return this.withNewDefaultBackendLike(Optional.ofNullable(this.buildDefaultBackend()).orElse(null));
    }

    public DefaultBackendNested<A> editOrNewDefaultBackend() {
        return this.withNewDefaultBackendLike(Optional.ofNullable(this.buildDefaultBackend()).orElse(new V1IngressBackendBuilder().build()));
    }

    public DefaultBackendNested<A> editOrNewDefaultBackendLike(V1IngressBackend item) {
        return this.withNewDefaultBackendLike(Optional.ofNullable(this.buildDefaultBackend()).orElse(item));
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)this;
    }

    public boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    public A addToRules(int index, V1IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    public A setToRules(int index, V1IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    public A addToRules(V1IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<V1IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A removeFromRules(V1IngressRule ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<V1IngressRule> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRules(Predicate<V1IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1IngressRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1IngressRule> buildRules() {
        return this.rules != null ? V1IngressSpecFluent.build(this.rules) : null;
    }

    public V1IngressRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public V1IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public V1IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public V1IngressRule buildMatchingRule(Predicate<V1IngressRuleBuilder> predicate) {
        for (V1IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<V1IngressRuleBuilder> predicate) {
        for (V1IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<V1IngressRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (V1IngressRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(V1IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (V1IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(V1IngressRule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, V1IngressRule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<V1IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public A addToTls(int index, V1IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get("tls").add(index, builder);
            this.tls.add(index, builder);
        }
        return (A)this;
    }

    public A setToTls(int index, V1IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get("tls").set(index, builder);
            this.tls.set(index, builder);
        }
        return (A)this;
    }

    public A addToTls(V1IngressTLS ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    public A addAllToTls(Collection<V1IngressTLS> items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    public A removeFromTls(V1IngressTLS ... items) {
        if (this.tls == null) {
            return (A)this;
        }
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").remove(builder);
            this.tls.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTls(Collection<V1IngressTLS> items) {
        if (this.tls == null) {
            return (A)this;
        }
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").remove(builder);
            this.tls.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTls(Predicate<V1IngressTLSBuilder> predicate) {
        if (this.tls == null) {
            return (A)this;
        }
        Iterator<V1IngressTLSBuilder> each = this.tls.iterator();
        Object visitables = this._visitables.get("tls");
        while (each.hasNext()) {
            V1IngressTLSBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1IngressTLS> buildTls() {
        return this.tls != null ? V1IngressSpecFluent.build(this.tls) : null;
    }

    public V1IngressTLS buildTl(int index) {
        return this.tls.get(index).build();
    }

    public V1IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    public V1IngressTLS buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    public V1IngressTLS buildMatchingTl(Predicate<V1IngressTLSBuilder> predicate) {
        for (V1IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTl(Predicate<V1IngressTLSBuilder> predicate) {
        for (V1IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTls(List<V1IngressTLS> tls) {
        if (this.tls != null) {
            this._visitables.get("tls").clear();
        }
        if (tls != null) {
            this.tls = new ArrayList();
            for (V1IngressTLS item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)this;
    }

    public A withTls(V1IngressTLS ... tls) {
        if (this.tls != null) {
            this.tls.clear();
            this._visitables.remove("tls");
        }
        if (tls != null) {
            for (V1IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    public boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    public TlsNested<A> addNewTl() {
        return new TlsNested(-1, null);
    }

    public TlsNested<A> addNewTlLike(V1IngressTLS item) {
        return new TlsNested(-1, item);
    }

    public TlsNested<A> setNewTlLike(int index, V1IngressTLS item) {
        return new TlsNested(index, item);
    }

    public TlsNested<A> editTl(int index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    public TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editMatchingTl(Predicate<V1IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressSpecFluent that = (V1IngressSpecFluent)o;
        if (!Objects.equals(this.defaultBackend, that.defaultBackend)) {
            return false;
        }
        if (!Objects.equals(this.ingressClassName, that.ingressClassName)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.tls, that.tls);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.ingressClassName, this.rules, this.tls, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultBackend != null) {
            sb.append("defaultBackend:");
            sb.append(this.defaultBackend + ",");
        }
        if (this.ingressClassName != null) {
            sb.append("ingressClassName:");
            sb.append(this.ingressClassName + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.tls != null && !this.tls.isEmpty()) {
            sb.append("tls:");
            sb.append(this.tls);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultBackendNested<N>
    extends V1IngressBackendFluent<DefaultBackendNested<N>>
    implements Nested<N> {
        V1IngressBackendBuilder builder;

        DefaultBackendNested(V1IngressBackend item) {
            this.builder = new V1IngressBackendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressSpecFluent.this.withDefaultBackend(this.builder.build());
        }

        public N endDefaultBackend() {
            return this.and();
        }
    }

    public class RulesNested<N>
    extends V1IngressRuleFluent<RulesNested<N>>
    implements Nested<N> {
        V1IngressRuleBuilder builder;
        int index;

        RulesNested(int index, V1IngressRule item) {
            this.index = index;
            this.builder = new V1IngressRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressSpecFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class TlsNested<N>
    extends V1IngressTLSFluent<TlsNested<N>>
    implements Nested<N> {
        V1IngressTLSBuilder builder;
        int index;

        TlsNested(int index, V1IngressTLS item) {
            this.index = index;
            this.builder = new V1IngressTLSBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressSpecFluent.this.setToTls(this.index, this.builder.build());
        }

        public N endTl() {
            return this.and();
        }
    }
}

