/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerSpec;
import io.kubernetes.client.openapi.models.V1ReplicationControllerSpecBuilder;
import io.kubernetes.client.openapi.models.V1ReplicationControllerSpecFluent;
import io.kubernetes.client.openapi.models.V1ReplicationControllerStatus;
import io.kubernetes.client.openapi.models.V1ReplicationControllerStatusBuilder;
import io.kubernetes.client.openapi.models.V1ReplicationControllerStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class V1ReplicationControllerFluent<A extends V1ReplicationControllerFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1ReplicationControllerSpecBuilder spec;
    private V1ReplicationControllerStatusBuilder status;

    public V1ReplicationControllerFluent() {
    }

    public V1ReplicationControllerFluent(V1ReplicationController instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ReplicationController instance) {
        V1ReplicationController v1ReplicationController = instance = instance != null ? instance : new V1ReplicationController();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1ReplicationControllerSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(V1ReplicationControllerSpec spec) {
        this._visitables.remove("spec");
        if (spec != null) {
            this.spec = new V1ReplicationControllerSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(V1ReplicationControllerSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new V1ReplicationControllerSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(V1ReplicationControllerSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public V1ReplicationControllerStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(V1ReplicationControllerStatus status) {
        this._visitables.remove("status");
        if (status != null) {
            this.status = new V1ReplicationControllerStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(V1ReplicationControllerStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new V1ReplicationControllerStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(V1ReplicationControllerStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ReplicationControllerFluent that = (V1ReplicationControllerFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends V1ReplicationControllerSpecFluent<SpecNested<N>>
    implements Nested<N> {
        V1ReplicationControllerSpecBuilder builder;

        SpecNested(V1ReplicationControllerSpec item) {
            this.builder = new V1ReplicationControllerSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends V1ReplicationControllerStatusFluent<StatusNested<N>>
    implements Nested<N> {
        V1ReplicationControllerStatusBuilder builder;

        StatusNested(V1ReplicationControllerStatus item) {
            this.builder = new V1ReplicationControllerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

