/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha1MatchResources;
import io.kubernetes.client.openapi.models.V1alpha1MatchResourcesBuilder;
import io.kubernetes.client.openapi.models.V1alpha1MatchResourcesFluent;
import io.kubernetes.client.openapi.models.V1alpha1ParamRef;
import io.kubernetes.client.openapi.models.V1alpha1ParamRefBuilder;
import io.kubernetes.client.openapi.models.V1alpha1ParamRefFluent;
import io.kubernetes.client.openapi.models.V1alpha1ValidatingAdmissionPolicyBindingSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1alpha1ValidatingAdmissionPolicyBindingSpecFluent<A extends V1alpha1ValidatingAdmissionPolicyBindingSpecFluent<A>>
extends BaseFluent<A> {
    private V1alpha1MatchResourcesBuilder matchResources;
    private V1alpha1ParamRefBuilder paramRef;
    private String policyName;
    private List<String> validationActions;

    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent() {
    }

    public V1alpha1ValidatingAdmissionPolicyBindingSpecFluent(V1alpha1ValidatingAdmissionPolicyBindingSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha1ValidatingAdmissionPolicyBindingSpec instance) {
        V1alpha1ValidatingAdmissionPolicyBindingSpec v1alpha1ValidatingAdmissionPolicyBindingSpec = instance = instance != null ? instance : new V1alpha1ValidatingAdmissionPolicyBindingSpec();
        if (instance != null) {
            this.withMatchResources(instance.getMatchResources());
            this.withParamRef(instance.getParamRef());
            this.withPolicyName(instance.getPolicyName());
            this.withValidationActions(instance.getValidationActions());
        }
    }

    public V1alpha1MatchResources buildMatchResources() {
        return this.matchResources != null ? this.matchResources.build() : null;
    }

    public A withMatchResources(V1alpha1MatchResources matchResources) {
        this._visitables.remove("matchResources");
        if (matchResources != null) {
            this.matchResources = new V1alpha1MatchResourcesBuilder(matchResources);
            this._visitables.get("matchResources").add(this.matchResources);
        } else {
            this.matchResources = null;
            this._visitables.get("matchResources").remove(this.matchResources);
        }
        return (A)this;
    }

    public boolean hasMatchResources() {
        return this.matchResources != null;
    }

    public MatchResourcesNested<A> withNewMatchResources() {
        return new MatchResourcesNested(null);
    }

    public MatchResourcesNested<A> withNewMatchResourcesLike(V1alpha1MatchResources item) {
        return new MatchResourcesNested(item);
    }

    public MatchResourcesNested<A> editMatchResources() {
        return this.withNewMatchResourcesLike(Optional.ofNullable(this.buildMatchResources()).orElse(null));
    }

    public MatchResourcesNested<A> editOrNewMatchResources() {
        return this.withNewMatchResourcesLike(Optional.ofNullable(this.buildMatchResources()).orElse(new V1alpha1MatchResourcesBuilder().build()));
    }

    public MatchResourcesNested<A> editOrNewMatchResourcesLike(V1alpha1MatchResources item) {
        return this.withNewMatchResourcesLike(Optional.ofNullable(this.buildMatchResources()).orElse(item));
    }

    public V1alpha1ParamRef buildParamRef() {
        return this.paramRef != null ? this.paramRef.build() : null;
    }

    public A withParamRef(V1alpha1ParamRef paramRef) {
        this._visitables.remove("paramRef");
        if (paramRef != null) {
            this.paramRef = new V1alpha1ParamRefBuilder(paramRef);
            this._visitables.get("paramRef").add(this.paramRef);
        } else {
            this.paramRef = null;
            this._visitables.get("paramRef").remove(this.paramRef);
        }
        return (A)this;
    }

    public boolean hasParamRef() {
        return this.paramRef != null;
    }

    public ParamRefNested<A> withNewParamRef() {
        return new ParamRefNested(null);
    }

    public ParamRefNested<A> withNewParamRefLike(V1alpha1ParamRef item) {
        return new ParamRefNested(item);
    }

    public ParamRefNested<A> editParamRef() {
        return this.withNewParamRefLike(Optional.ofNullable(this.buildParamRef()).orElse(null));
    }

    public ParamRefNested<A> editOrNewParamRef() {
        return this.withNewParamRefLike(Optional.ofNullable(this.buildParamRef()).orElse(new V1alpha1ParamRefBuilder().build()));
    }

    public ParamRefNested<A> editOrNewParamRefLike(V1alpha1ParamRef item) {
        return this.withNewParamRefLike(Optional.ofNullable(this.buildParamRef()).orElse(item));
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public A withPolicyName(String policyName) {
        this.policyName = policyName;
        return (A)this;
    }

    public boolean hasPolicyName() {
        return this.policyName != null;
    }

    public A addToValidationActions(int index, String item) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.add(index, item);
        return (A)this;
    }

    public A setToValidationActions(int index, String item) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.set(index, item);
        return (A)this;
    }

    public A addToValidationActions(String ... items) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        for (String item : items) {
            this.validationActions.add(item);
        }
        return (A)this;
    }

    public A addAllToValidationActions(Collection<String> items) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        for (String item : items) {
            this.validationActions.add(item);
        }
        return (A)this;
    }

    public A removeFromValidationActions(String ... items) {
        if (this.validationActions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.validationActions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromValidationActions(Collection<String> items) {
        if (this.validationActions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.validationActions.remove(item);
        }
        return (A)this;
    }

    public List<String> getValidationActions() {
        return this.validationActions;
    }

    public String getValidationAction(int index) {
        return this.validationActions.get(index);
    }

    public String getFirstValidationAction() {
        return this.validationActions.get(0);
    }

    public String getLastValidationAction() {
        return this.validationActions.get(this.validationActions.size() - 1);
    }

    public String getMatchingValidationAction(Predicate<String> predicate) {
        for (String item : this.validationActions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingValidationAction(Predicate<String> predicate) {
        for (String item : this.validationActions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValidationActions(List<String> validationActions) {
        if (validationActions != null) {
            this.validationActions = new ArrayList<String>();
            for (String item : validationActions) {
                this.addToValidationActions(item);
            }
        } else {
            this.validationActions = null;
        }
        return (A)this;
    }

    public A withValidationActions(String ... validationActions) {
        if (this.validationActions != null) {
            this.validationActions.clear();
            this._visitables.remove("validationActions");
        }
        if (validationActions != null) {
            for (String item : validationActions) {
                this.addToValidationActions(item);
            }
        }
        return (A)this;
    }

    public boolean hasValidationActions() {
        return this.validationActions != null && !this.validationActions.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1ValidatingAdmissionPolicyBindingSpecFluent that = (V1alpha1ValidatingAdmissionPolicyBindingSpecFluent)o;
        if (!Objects.equals(this.matchResources, that.matchResources)) {
            return false;
        }
        if (!Objects.equals(this.paramRef, that.paramRef)) {
            return false;
        }
        if (!Objects.equals(this.policyName, that.policyName)) {
            return false;
        }
        return Objects.equals(this.validationActions, that.validationActions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.matchResources, this.paramRef, this.policyName, this.validationActions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchResources != null) {
            sb.append("matchResources:");
            sb.append(this.matchResources + ",");
        }
        if (this.paramRef != null) {
            sb.append("paramRef:");
            sb.append(this.paramRef + ",");
        }
        if (this.policyName != null) {
            sb.append("policyName:");
            sb.append(this.policyName + ",");
        }
        if (this.validationActions != null && !this.validationActions.isEmpty()) {
            sb.append("validationActions:");
            sb.append(this.validationActions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchResourcesNested<N>
    extends V1alpha1MatchResourcesFluent<MatchResourcesNested<N>>
    implements Nested<N> {
        V1alpha1MatchResourcesBuilder builder;

        MatchResourcesNested(V1alpha1MatchResources item) {
            this.builder = new V1alpha1MatchResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.this.withMatchResources(this.builder.build());
        }

        public N endMatchResources() {
            return this.and();
        }
    }

    public class ParamRefNested<N>
    extends V1alpha1ParamRefFluent<ParamRefNested<N>>
    implements Nested<N> {
        V1alpha1ParamRefBuilder builder;

        ParamRefNested(V1alpha1ParamRef item) {
            this.builder = new V1alpha1ParamRefBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1ValidatingAdmissionPolicyBindingSpecFluent.this.withParamRef(this.builder.build());
        }

        public N endParamRef() {
            return this.and();
        }
    }
}

