/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClaim;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClaimConfiguration;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClaimConfigurationBuilder;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClaimConfigurationFluent;
import io.kubernetes.client.openapi.models.V1alpha3DeviceConstraint;
import io.kubernetes.client.openapi.models.V1alpha3DeviceConstraintBuilder;
import io.kubernetes.client.openapi.models.V1alpha3DeviceConstraintFluent;
import io.kubernetes.client.openapi.models.V1alpha3DeviceRequest;
import io.kubernetes.client.openapi.models.V1alpha3DeviceRequestBuilder;
import io.kubernetes.client.openapi.models.V1alpha3DeviceRequestFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha3DeviceClaimFluent<A extends V1alpha3DeviceClaimFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1alpha3DeviceClaimConfigurationBuilder> config;
    private ArrayList<V1alpha3DeviceConstraintBuilder> constraints;
    private ArrayList<V1alpha3DeviceRequestBuilder> requests;

    public V1alpha3DeviceClaimFluent() {
    }

    public V1alpha3DeviceClaimFluent(V1alpha3DeviceClaim instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha3DeviceClaim instance) {
        V1alpha3DeviceClaim v1alpha3DeviceClaim = instance = instance != null ? instance : new V1alpha3DeviceClaim();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withConstraints(instance.getConstraints());
            this.withRequests(instance.getRequests());
        }
    }

    public A addToConfig(int index, V1alpha3DeviceClaimConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        V1alpha3DeviceClaimConfigurationBuilder builder = new V1alpha3DeviceClaimConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get("config").add(index, builder);
            this.config.add(index, builder);
        }
        return (A)this;
    }

    public A setToConfig(int index, V1alpha3DeviceClaimConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        V1alpha3DeviceClaimConfigurationBuilder builder = new V1alpha3DeviceClaimConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get("config").set(index, builder);
            this.config.set(index, builder);
        }
        return (A)this;
    }

    public A addToConfig(V1alpha3DeviceClaimConfiguration ... items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (V1alpha3DeviceClaimConfiguration item : items) {
            V1alpha3DeviceClaimConfigurationBuilder builder = new V1alpha3DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        }
        return (A)this;
    }

    public A addAllToConfig(Collection<V1alpha3DeviceClaimConfiguration> items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (V1alpha3DeviceClaimConfiguration item : items) {
            V1alpha3DeviceClaimConfigurationBuilder builder = new V1alpha3DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        }
        return (A)this;
    }

    public A removeFromConfig(V1alpha3DeviceClaimConfiguration ... items) {
        if (this.config == null) {
            return (A)this;
        }
        for (V1alpha3DeviceClaimConfiguration item : items) {
            V1alpha3DeviceClaimConfigurationBuilder builder = new V1alpha3DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").remove(builder);
            this.config.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConfig(Collection<V1alpha3DeviceClaimConfiguration> items) {
        if (this.config == null) {
            return (A)this;
        }
        for (V1alpha3DeviceClaimConfiguration item : items) {
            V1alpha3DeviceClaimConfigurationBuilder builder = new V1alpha3DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").remove(builder);
            this.config.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConfig(Predicate<V1alpha3DeviceClaimConfigurationBuilder> predicate) {
        if (this.config == null) {
            return (A)this;
        }
        Iterator<V1alpha3DeviceClaimConfigurationBuilder> each = this.config.iterator();
        Object visitables = this._visitables.get("config");
        while (each.hasNext()) {
            V1alpha3DeviceClaimConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha3DeviceClaimConfiguration> buildConfig() {
        return this.config != null ? V1alpha3DeviceClaimFluent.build(this.config) : null;
    }

    public V1alpha3DeviceClaimConfiguration buildConfig(int index) {
        return this.config.get(index).build();
    }

    public V1alpha3DeviceClaimConfiguration buildFirstConfig() {
        return this.config.get(0).build();
    }

    public V1alpha3DeviceClaimConfiguration buildLastConfig() {
        return this.config.get(this.config.size() - 1).build();
    }

    public V1alpha3DeviceClaimConfiguration buildMatchingConfig(Predicate<V1alpha3DeviceClaimConfigurationBuilder> predicate) {
        for (V1alpha3DeviceClaimConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfig(Predicate<V1alpha3DeviceClaimConfigurationBuilder> predicate) {
        for (V1alpha3DeviceClaimConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfig(List<V1alpha3DeviceClaimConfiguration> config) {
        if (this.config != null) {
            this._visitables.get("config").clear();
        }
        if (config != null) {
            this.config = new ArrayList();
            for (V1alpha3DeviceClaimConfiguration item : config) {
                this.addToConfig(item);
            }
        } else {
            this.config = null;
        }
        return (A)this;
    }

    public A withConfig(V1alpha3DeviceClaimConfiguration ... config) {
        if (this.config != null) {
            this.config.clear();
            this._visitables.remove("config");
        }
        if (config != null) {
            for (V1alpha3DeviceClaimConfiguration item : config) {
                this.addToConfig(item);
            }
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null && !this.config.isEmpty();
    }

    public ConfigNested<A> addNewConfig() {
        return new ConfigNested(-1, null);
    }

    public ConfigNested<A> addNewConfigLike(V1alpha3DeviceClaimConfiguration item) {
        return new ConfigNested(-1, item);
    }

    public ConfigNested<A> setNewConfigLike(int index, V1alpha3DeviceClaimConfiguration item) {
        return new ConfigNested(index, item);
    }

    public ConfigNested<A> editConfig(int index) {
        if (this.config.size() <= index) {
            throw new RuntimeException("Can't edit config. Index exceeds size.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editFirstConfig() {
        if (this.config.size() == 0) {
            throw new RuntimeException("Can't edit first config. The list is empty.");
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    public ConfigNested<A> editLastConfig() {
        int index = this.config.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last config. The list is empty.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editMatchingConfig(Predicate<V1alpha3DeviceClaimConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.config.size(); ++i) {
            if (!predicate.test(this.config.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching config. No match found.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public A addToConstraints(int index, V1alpha3DeviceConstraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        V1alpha3DeviceConstraintBuilder builder = new V1alpha3DeviceConstraintBuilder(item);
        if (index < 0 || index >= this.constraints.size()) {
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        } else {
            this._visitables.get("constraints").add(index, builder);
            this.constraints.add(index, builder);
        }
        return (A)this;
    }

    public A setToConstraints(int index, V1alpha3DeviceConstraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        V1alpha3DeviceConstraintBuilder builder = new V1alpha3DeviceConstraintBuilder(item);
        if (index < 0 || index >= this.constraints.size()) {
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        } else {
            this._visitables.get("constraints").set(index, builder);
            this.constraints.set(index, builder);
        }
        return (A)this;
    }

    public A addToConstraints(V1alpha3DeviceConstraint ... items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        for (V1alpha3DeviceConstraint item : items) {
            V1alpha3DeviceConstraintBuilder builder = new V1alpha3DeviceConstraintBuilder(item);
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    public A addAllToConstraints(Collection<V1alpha3DeviceConstraint> items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        for (V1alpha3DeviceConstraint item : items) {
            V1alpha3DeviceConstraintBuilder builder = new V1alpha3DeviceConstraintBuilder(item);
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    public A removeFromConstraints(V1alpha3DeviceConstraint ... items) {
        if (this.constraints == null) {
            return (A)this;
        }
        for (V1alpha3DeviceConstraint item : items) {
            V1alpha3DeviceConstraintBuilder builder = new V1alpha3DeviceConstraintBuilder(item);
            this._visitables.get("constraints").remove(builder);
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConstraints(Collection<V1alpha3DeviceConstraint> items) {
        if (this.constraints == null) {
            return (A)this;
        }
        for (V1alpha3DeviceConstraint item : items) {
            V1alpha3DeviceConstraintBuilder builder = new V1alpha3DeviceConstraintBuilder(item);
            this._visitables.get("constraints").remove(builder);
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConstraints(Predicate<V1alpha3DeviceConstraintBuilder> predicate) {
        if (this.constraints == null) {
            return (A)this;
        }
        Iterator<V1alpha3DeviceConstraintBuilder> each = this.constraints.iterator();
        Object visitables = this._visitables.get("constraints");
        while (each.hasNext()) {
            V1alpha3DeviceConstraintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha3DeviceConstraint> buildConstraints() {
        return this.constraints != null ? V1alpha3DeviceClaimFluent.build(this.constraints) : null;
    }

    public V1alpha3DeviceConstraint buildConstraint(int index) {
        return this.constraints.get(index).build();
    }

    public V1alpha3DeviceConstraint buildFirstConstraint() {
        return this.constraints.get(0).build();
    }

    public V1alpha3DeviceConstraint buildLastConstraint() {
        return this.constraints.get(this.constraints.size() - 1).build();
    }

    public V1alpha3DeviceConstraint buildMatchingConstraint(Predicate<V1alpha3DeviceConstraintBuilder> predicate) {
        for (V1alpha3DeviceConstraintBuilder item : this.constraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConstraint(Predicate<V1alpha3DeviceConstraintBuilder> predicate) {
        for (V1alpha3DeviceConstraintBuilder item : this.constraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConstraints(List<V1alpha3DeviceConstraint> constraints) {
        if (this.constraints != null) {
            this._visitables.get("constraints").clear();
        }
        if (constraints != null) {
            this.constraints = new ArrayList();
            for (V1alpha3DeviceConstraint item : constraints) {
                this.addToConstraints(item);
            }
        } else {
            this.constraints = null;
        }
        return (A)this;
    }

    public A withConstraints(V1alpha3DeviceConstraint ... constraints) {
        if (this.constraints != null) {
            this.constraints.clear();
            this._visitables.remove("constraints");
        }
        if (constraints != null) {
            for (V1alpha3DeviceConstraint item : constraints) {
                this.addToConstraints(item);
            }
        }
        return (A)this;
    }

    public boolean hasConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    public ConstraintsNested<A> addNewConstraint() {
        return new ConstraintsNested(-1, null);
    }

    public ConstraintsNested<A> addNewConstraintLike(V1alpha3DeviceConstraint item) {
        return new ConstraintsNested(-1, item);
    }

    public ConstraintsNested<A> setNewConstraintLike(int index, V1alpha3DeviceConstraint item) {
        return new ConstraintsNested(index, item);
    }

    public ConstraintsNested<A> editConstraint(int index) {
        if (this.constraints.size() <= index) {
            throw new RuntimeException("Can't edit constraints. Index exceeds size.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    public ConstraintsNested<A> editFirstConstraint() {
        if (this.constraints.size() == 0) {
            throw new RuntimeException("Can't edit first constraints. The list is empty.");
        }
        return this.setNewConstraintLike(0, this.buildConstraint(0));
    }

    public ConstraintsNested<A> editLastConstraint() {
        int index = this.constraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last constraints. The list is empty.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    public ConstraintsNested<A> editMatchingConstraint(Predicate<V1alpha3DeviceConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (!predicate.test(this.constraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching constraints. No match found.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    public A addToRequests(int index, V1alpha3DeviceRequest item) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        V1alpha3DeviceRequestBuilder builder = new V1alpha3DeviceRequestBuilder(item);
        if (index < 0 || index >= this.requests.size()) {
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        } else {
            this._visitables.get("requests").add(index, builder);
            this.requests.add(index, builder);
        }
        return (A)this;
    }

    public A setToRequests(int index, V1alpha3DeviceRequest item) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        V1alpha3DeviceRequestBuilder builder = new V1alpha3DeviceRequestBuilder(item);
        if (index < 0 || index >= this.requests.size()) {
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        } else {
            this._visitables.get("requests").set(index, builder);
            this.requests.set(index, builder);
        }
        return (A)this;
    }

    public A addToRequests(V1alpha3DeviceRequest ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        for (V1alpha3DeviceRequest item : items) {
            V1alpha3DeviceRequestBuilder builder = new V1alpha3DeviceRequestBuilder(item);
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        }
        return (A)this;
    }

    public A addAllToRequests(Collection<V1alpha3DeviceRequest> items) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        for (V1alpha3DeviceRequest item : items) {
            V1alpha3DeviceRequestBuilder builder = new V1alpha3DeviceRequestBuilder(item);
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        }
        return (A)this;
    }

    public A removeFromRequests(V1alpha3DeviceRequest ... items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (V1alpha3DeviceRequest item : items) {
            V1alpha3DeviceRequestBuilder builder = new V1alpha3DeviceRequestBuilder(item);
            this._visitables.get("requests").remove(builder);
            this.requests.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRequests(Collection<V1alpha3DeviceRequest> items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (V1alpha3DeviceRequest item : items) {
            V1alpha3DeviceRequestBuilder builder = new V1alpha3DeviceRequestBuilder(item);
            this._visitables.get("requests").remove(builder);
            this.requests.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRequests(Predicate<V1alpha3DeviceRequestBuilder> predicate) {
        if (this.requests == null) {
            return (A)this;
        }
        Iterator<V1alpha3DeviceRequestBuilder> each = this.requests.iterator();
        Object visitables = this._visitables.get("requests");
        while (each.hasNext()) {
            V1alpha3DeviceRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha3DeviceRequest> buildRequests() {
        return this.requests != null ? V1alpha3DeviceClaimFluent.build(this.requests) : null;
    }

    public V1alpha3DeviceRequest buildRequest(int index) {
        return this.requests.get(index).build();
    }

    public V1alpha3DeviceRequest buildFirstRequest() {
        return this.requests.get(0).build();
    }

    public V1alpha3DeviceRequest buildLastRequest() {
        return this.requests.get(this.requests.size() - 1).build();
    }

    public V1alpha3DeviceRequest buildMatchingRequest(Predicate<V1alpha3DeviceRequestBuilder> predicate) {
        for (V1alpha3DeviceRequestBuilder item : this.requests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<V1alpha3DeviceRequestBuilder> predicate) {
        for (V1alpha3DeviceRequestBuilder item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequests(List<V1alpha3DeviceRequest> requests) {
        if (this.requests != null) {
            this._visitables.get("requests").clear();
        }
        if (requests != null) {
            this.requests = new ArrayList();
            for (V1alpha3DeviceRequest item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)this;
    }

    public A withRequests(V1alpha3DeviceRequest ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove("requests");
        }
        if (requests != null) {
            for (V1alpha3DeviceRequest item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public RequestsNested<A> addNewRequest() {
        return new RequestsNested(-1, null);
    }

    public RequestsNested<A> addNewRequestLike(V1alpha3DeviceRequest item) {
        return new RequestsNested(-1, item);
    }

    public RequestsNested<A> setNewRequestLike(int index, V1alpha3DeviceRequest item) {
        return new RequestsNested(index, item);
    }

    public RequestsNested<A> editRequest(int index) {
        if (this.requests.size() <= index) {
            throw new RuntimeException("Can't edit requests. Index exceeds size.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestsNested<A> editFirstRequest() {
        if (this.requests.size() == 0) {
            throw new RuntimeException("Can't edit first requests. The list is empty.");
        }
        return this.setNewRequestLike(0, this.buildRequest(0));
    }

    public RequestsNested<A> editLastRequest() {
        int index = this.requests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last requests. The list is empty.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestsNested<A> editMatchingRequest(Predicate<V1alpha3DeviceRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requests.size(); ++i) {
            if (!predicate.test(this.requests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching requests. No match found.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha3DeviceClaimFluent that = (V1alpha3DeviceClaimFluent)o;
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.constraints, that.constraints)) {
            return false;
        }
        return Objects.equals(this.requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.config, this.constraints, this.requests, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.constraints != null && !this.constraints.isEmpty()) {
            sb.append("constraints:");
            sb.append(this.constraints + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigNested<N>
    extends V1alpha3DeviceClaimConfigurationFluent<ConfigNested<N>>
    implements Nested<N> {
        V1alpha3DeviceClaimConfigurationBuilder builder;
        int index;

        ConfigNested(int index, V1alpha3DeviceClaimConfiguration item) {
            this.index = index;
            this.builder = new V1alpha3DeviceClaimConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha3DeviceClaimFluent.this.setToConfig(this.index, this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }

    public class ConstraintsNested<N>
    extends V1alpha3DeviceConstraintFluent<ConstraintsNested<N>>
    implements Nested<N> {
        V1alpha3DeviceConstraintBuilder builder;
        int index;

        ConstraintsNested(int index, V1alpha3DeviceConstraint item) {
            this.index = index;
            this.builder = new V1alpha3DeviceConstraintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha3DeviceClaimFluent.this.setToConstraints(this.index, this.builder.build());
        }

        public N endConstraint() {
            return this.and();
        }
    }

    public class RequestsNested<N>
    extends V1alpha3DeviceRequestFluent<RequestsNested<N>>
    implements Nested<N> {
        V1alpha3DeviceRequestBuilder builder;
        int index;

        RequestsNested(int index, V1alpha3DeviceRequest item) {
            this.index = index;
            this.builder = new V1alpha3DeviceRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha3DeviceClaimFluent.this.setToRequests(this.index, this.builder.build());
        }

        public N endRequest() {
            return this.and();
        }
    }
}

