/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha3DeviceRequest;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelector;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelectorBuilder;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha3DeviceRequestFluent<A extends V1alpha3DeviceRequestFluent<A>>
extends BaseFluent<A> {
    private Boolean adminAccess;
    private String allocationMode;
    private Long count;
    private String deviceClassName;
    private String name;
    private ArrayList<V1alpha3DeviceSelectorBuilder> selectors;

    public V1alpha3DeviceRequestFluent() {
    }

    public V1alpha3DeviceRequestFluent(V1alpha3DeviceRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha3DeviceRequest instance) {
        V1alpha3DeviceRequest v1alpha3DeviceRequest = instance = instance != null ? instance : new V1alpha3DeviceRequest();
        if (instance != null) {
            this.withAdminAccess(instance.getAdminAccess());
            this.withAllocationMode(instance.getAllocationMode());
            this.withCount(instance.getCount());
            this.withDeviceClassName(instance.getDeviceClassName());
            this.withName(instance.getName());
            this.withSelectors(instance.getSelectors());
        }
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public A withAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (A)this;
    }

    public boolean hasAdminAccess() {
        return this.adminAccess != null;
    }

    public String getAllocationMode() {
        return this.allocationMode;
    }

    public A withAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return (A)this;
    }

    public boolean hasAllocationMode() {
        return this.allocationMode != null;
    }

    public Long getCount() {
        return this.count;
    }

    public A withCount(Long count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public A withDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return (A)this;
    }

    public boolean hasDeviceClassName() {
        return this.deviceClassName != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToSelectors(int index, V1alpha3DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(index, builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToSelectors(int index, V1alpha3DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").set(index, builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToSelectors(V1alpha3DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToSelectors(Collection<V1alpha3DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromSelectors(V1alpha3DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSelectors(Collection<V1alpha3DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<V1alpha3DeviceSelectorBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            V1alpha3DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha3DeviceSelector> buildSelectors() {
        return this.selectors != null ? V1alpha3DeviceRequestFluent.build(this.selectors) : null;
    }

    public V1alpha3DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public V1alpha3DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public V1alpha3DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public V1alpha3DeviceSelector buildMatchingSelector(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        for (V1alpha3DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSelector(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        for (V1alpha3DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSelectors(List<V1alpha3DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (V1alpha3DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(V1alpha3DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (V1alpha3DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(V1alpha3DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, V1alpha3DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException("Can't edit selectors. Index exceeds size.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException("Can't edit first selectors. The list is empty.");
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last selectors. The list is empty.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching selectors. No match found.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha3DeviceRequestFluent that = (V1alpha3DeviceRequestFluent)o;
        if (!Objects.equals(this.adminAccess, that.adminAccess)) {
            return false;
        }
        if (!Objects.equals(this.allocationMode, that.allocationMode)) {
            return false;
        }
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.deviceClassName, that.deviceClassName)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.selectors, that.selectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.adminAccess, this.allocationMode, this.count, this.deviceClassName, this.name, this.selectors, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adminAccess != null) {
            sb.append("adminAccess:");
            sb.append(this.adminAccess + ",");
        }
        if (this.allocationMode != null) {
            sb.append("allocationMode:");
            sb.append(this.allocationMode + ",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.deviceClassName != null) {
            sb.append("deviceClassName:");
            sb.append(this.deviceClassName + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAdminAccess() {
        return this.withAdminAccess(true);
    }

    public class SelectorsNested<N>
    extends V1alpha3DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        V1alpha3DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, V1alpha3DeviceSelector item) {
            this.index = index;
            this.builder = new V1alpha3DeviceSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha3DeviceRequestFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

