/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1beta1AuditAnnotation;
import io.kubernetes.client.openapi.models.V1beta1AuditAnnotationBuilder;
import io.kubernetes.client.openapi.models.V1beta1AuditAnnotationFluent;
import io.kubernetes.client.openapi.models.V1beta1MatchCondition;
import io.kubernetes.client.openapi.models.V1beta1MatchConditionBuilder;
import io.kubernetes.client.openapi.models.V1beta1MatchConditionFluent;
import io.kubernetes.client.openapi.models.V1beta1MatchResources;
import io.kubernetes.client.openapi.models.V1beta1MatchResourcesBuilder;
import io.kubernetes.client.openapi.models.V1beta1MatchResourcesFluent;
import io.kubernetes.client.openapi.models.V1beta1ParamKind;
import io.kubernetes.client.openapi.models.V1beta1ParamKindBuilder;
import io.kubernetes.client.openapi.models.V1beta1ParamKindFluent;
import io.kubernetes.client.openapi.models.V1beta1ValidatingAdmissionPolicySpec;
import io.kubernetes.client.openapi.models.V1beta1Validation;
import io.kubernetes.client.openapi.models.V1beta1ValidationBuilder;
import io.kubernetes.client.openapi.models.V1beta1ValidationFluent;
import io.kubernetes.client.openapi.models.V1beta1Variable;
import io.kubernetes.client.openapi.models.V1beta1VariableBuilder;
import io.kubernetes.client.openapi.models.V1beta1VariableFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1beta1ValidatingAdmissionPolicySpecFluent<A extends V1beta1ValidatingAdmissionPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1beta1AuditAnnotationBuilder> auditAnnotations;
    private String failurePolicy;
    private ArrayList<V1beta1MatchConditionBuilder> matchConditions;
    private V1beta1MatchResourcesBuilder matchConstraints;
    private V1beta1ParamKindBuilder paramKind;
    private ArrayList<V1beta1ValidationBuilder> validations;
    private ArrayList<V1beta1VariableBuilder> variables;

    public V1beta1ValidatingAdmissionPolicySpecFluent() {
    }

    public V1beta1ValidatingAdmissionPolicySpecFluent(V1beta1ValidatingAdmissionPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta1ValidatingAdmissionPolicySpec instance) {
        V1beta1ValidatingAdmissionPolicySpec v1beta1ValidatingAdmissionPolicySpec = instance = instance != null ? instance : new V1beta1ValidatingAdmissionPolicySpec();
        if (instance != null) {
            this.withAuditAnnotations(instance.getAuditAnnotations());
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConditions(instance.getMatchConditions());
            this.withMatchConstraints(instance.getMatchConstraints());
            this.withParamKind(instance.getParamKind());
            this.withValidations(instance.getValidations());
            this.withVariables(instance.getVariables());
        }
    }

    public A addToAuditAnnotations(int index, V1beta1AuditAnnotation item) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        V1beta1AuditAnnotationBuilder builder = new V1beta1AuditAnnotationBuilder(item);
        if (index < 0 || index >= this.auditAnnotations.size()) {
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        } else {
            this._visitables.get("auditAnnotations").add(index, builder);
            this.auditAnnotations.add(index, builder);
        }
        return (A)this;
    }

    public A setToAuditAnnotations(int index, V1beta1AuditAnnotation item) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        V1beta1AuditAnnotationBuilder builder = new V1beta1AuditAnnotationBuilder(item);
        if (index < 0 || index >= this.auditAnnotations.size()) {
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        } else {
            this._visitables.get("auditAnnotations").set(index, builder);
            this.auditAnnotations.set(index, builder);
        }
        return (A)this;
    }

    public A addToAuditAnnotations(V1beta1AuditAnnotation ... items) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        for (V1beta1AuditAnnotation item : items) {
            V1beta1AuditAnnotationBuilder builder = new V1beta1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        }
        return (A)this;
    }

    public A addAllToAuditAnnotations(Collection<V1beta1AuditAnnotation> items) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        for (V1beta1AuditAnnotation item : items) {
            V1beta1AuditAnnotationBuilder builder = new V1beta1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        }
        return (A)this;
    }

    public A removeFromAuditAnnotations(V1beta1AuditAnnotation ... items) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        for (V1beta1AuditAnnotation item : items) {
            V1beta1AuditAnnotationBuilder builder = new V1beta1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").remove(builder);
            this.auditAnnotations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAuditAnnotations(Collection<V1beta1AuditAnnotation> items) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        for (V1beta1AuditAnnotation item : items) {
            V1beta1AuditAnnotationBuilder builder = new V1beta1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").remove(builder);
            this.auditAnnotations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAuditAnnotations(Predicate<V1beta1AuditAnnotationBuilder> predicate) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        Iterator<V1beta1AuditAnnotationBuilder> each = this.auditAnnotations.iterator();
        Object visitables = this._visitables.get("auditAnnotations");
        while (each.hasNext()) {
            V1beta1AuditAnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta1AuditAnnotation> buildAuditAnnotations() {
        return this.auditAnnotations != null ? V1beta1ValidatingAdmissionPolicySpecFluent.build(this.auditAnnotations) : null;
    }

    public V1beta1AuditAnnotation buildAuditAnnotation(int index) {
        return this.auditAnnotations.get(index).build();
    }

    public V1beta1AuditAnnotation buildFirstAuditAnnotation() {
        return this.auditAnnotations.get(0).build();
    }

    public V1beta1AuditAnnotation buildLastAuditAnnotation() {
        return this.auditAnnotations.get(this.auditAnnotations.size() - 1).build();
    }

    public V1beta1AuditAnnotation buildMatchingAuditAnnotation(Predicate<V1beta1AuditAnnotationBuilder> predicate) {
        for (V1beta1AuditAnnotationBuilder item : this.auditAnnotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAuditAnnotation(Predicate<V1beta1AuditAnnotationBuilder> predicate) {
        for (V1beta1AuditAnnotationBuilder item : this.auditAnnotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAuditAnnotations(List<V1beta1AuditAnnotation> auditAnnotations) {
        if (this.auditAnnotations != null) {
            this._visitables.get("auditAnnotations").clear();
        }
        if (auditAnnotations != null) {
            this.auditAnnotations = new ArrayList();
            for (V1beta1AuditAnnotation item : auditAnnotations) {
                this.addToAuditAnnotations(item);
            }
        } else {
            this.auditAnnotations = null;
        }
        return (A)this;
    }

    public A withAuditAnnotations(V1beta1AuditAnnotation ... auditAnnotations) {
        if (this.auditAnnotations != null) {
            this.auditAnnotations.clear();
            this._visitables.remove("auditAnnotations");
        }
        if (auditAnnotations != null) {
            for (V1beta1AuditAnnotation item : auditAnnotations) {
                this.addToAuditAnnotations(item);
            }
        }
        return (A)this;
    }

    public boolean hasAuditAnnotations() {
        return this.auditAnnotations != null && !this.auditAnnotations.isEmpty();
    }

    public AuditAnnotationsNested<A> addNewAuditAnnotation() {
        return new AuditAnnotationsNested(-1, null);
    }

    public AuditAnnotationsNested<A> addNewAuditAnnotationLike(V1beta1AuditAnnotation item) {
        return new AuditAnnotationsNested(-1, item);
    }

    public AuditAnnotationsNested<A> setNewAuditAnnotationLike(int index, V1beta1AuditAnnotation item) {
        return new AuditAnnotationsNested(index, item);
    }

    public AuditAnnotationsNested<A> editAuditAnnotation(int index) {
        if (this.auditAnnotations.size() <= index) {
            throw new RuntimeException("Can't edit auditAnnotations. Index exceeds size.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public AuditAnnotationsNested<A> editFirstAuditAnnotation() {
        if (this.auditAnnotations.size() == 0) {
            throw new RuntimeException("Can't edit first auditAnnotations. The list is empty.");
        }
        return this.setNewAuditAnnotationLike(0, this.buildAuditAnnotation(0));
    }

    public AuditAnnotationsNested<A> editLastAuditAnnotation() {
        int index = this.auditAnnotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last auditAnnotations. The list is empty.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public AuditAnnotationsNested<A> editMatchingAuditAnnotation(Predicate<V1beta1AuditAnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.auditAnnotations.size(); ++i) {
            if (!predicate.test(this.auditAnnotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching auditAnnotations. No match found.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    public boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A addToMatchConditions(int index, V1beta1MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        V1beta1MatchConditionBuilder builder = new V1beta1MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").add(index, builder);
            this.matchConditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchConditions(int index, V1beta1MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        V1beta1MatchConditionBuilder builder = new V1beta1MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").set(index, builder);
            this.matchConditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchConditions(V1beta1MatchCondition ... items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (V1beta1MatchCondition item : items) {
            V1beta1MatchConditionBuilder builder = new V1beta1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchConditions(Collection<V1beta1MatchCondition> items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (V1beta1MatchCondition item : items) {
            V1beta1MatchConditionBuilder builder = new V1beta1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchConditions(V1beta1MatchCondition ... items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (V1beta1MatchCondition item : items) {
            V1beta1MatchConditionBuilder builder = new V1beta1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchConditions(Collection<V1beta1MatchCondition> items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (V1beta1MatchCondition item : items) {
            V1beta1MatchConditionBuilder builder = new V1beta1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchConditions(Predicate<V1beta1MatchConditionBuilder> predicate) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        Iterator<V1beta1MatchConditionBuilder> each = this.matchConditions.iterator();
        Object visitables = this._visitables.get("matchConditions");
        while (each.hasNext()) {
            V1beta1MatchConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta1MatchCondition> buildMatchConditions() {
        return this.matchConditions != null ? V1beta1ValidatingAdmissionPolicySpecFluent.build(this.matchConditions) : null;
    }

    public V1beta1MatchCondition buildMatchCondition(int index) {
        return this.matchConditions.get(index).build();
    }

    public V1beta1MatchCondition buildFirstMatchCondition() {
        return this.matchConditions.get(0).build();
    }

    public V1beta1MatchCondition buildLastMatchCondition() {
        return this.matchConditions.get(this.matchConditions.size() - 1).build();
    }

    public V1beta1MatchCondition buildMatchingMatchCondition(Predicate<V1beta1MatchConditionBuilder> predicate) {
        for (V1beta1MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchCondition(Predicate<V1beta1MatchConditionBuilder> predicate) {
        for (V1beta1MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchConditions(List<V1beta1MatchCondition> matchConditions) {
        if (this.matchConditions != null) {
            this._visitables.get("matchConditions").clear();
        }
        if (matchConditions != null) {
            this.matchConditions = new ArrayList();
            for (V1beta1MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        } else {
            this.matchConditions = null;
        }
        return (A)this;
    }

    public A withMatchConditions(V1beta1MatchCondition ... matchConditions) {
        if (this.matchConditions != null) {
            this.matchConditions.clear();
            this._visitables.remove("matchConditions");
        }
        if (matchConditions != null) {
            for (V1beta1MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchConditions() {
        return this.matchConditions != null && !this.matchConditions.isEmpty();
    }

    public MatchConditionsNested<A> addNewMatchCondition() {
        return new MatchConditionsNested(-1, null);
    }

    public MatchConditionsNested<A> addNewMatchConditionLike(V1beta1MatchCondition item) {
        return new MatchConditionsNested(-1, item);
    }

    public MatchConditionsNested<A> setNewMatchConditionLike(int index, V1beta1MatchCondition item) {
        return new MatchConditionsNested(index, item);
    }

    public MatchConditionsNested<A> editMatchCondition(int index) {
        if (this.matchConditions.size() <= index) {
            throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editFirstMatchCondition() {
        if (this.matchConditions.size() == 0) {
            throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(0, this.buildMatchCondition(0));
    }

    public MatchConditionsNested<A> editLastMatchCondition() {
        int index = this.matchConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<V1beta1MatchConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchConditions.size(); ++i) {
            if (!predicate.test(this.matchConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchConditions. No match found.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public V1beta1MatchResources buildMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints.build() : null;
    }

    public A withMatchConstraints(V1beta1MatchResources matchConstraints) {
        this._visitables.remove("matchConstraints");
        if (matchConstraints != null) {
            this.matchConstraints = new V1beta1MatchResourcesBuilder(matchConstraints);
            this._visitables.get("matchConstraints").add(this.matchConstraints);
        } else {
            this.matchConstraints = null;
            this._visitables.get("matchConstraints").remove(this.matchConstraints);
        }
        return (A)this;
    }

    public boolean hasMatchConstraints() {
        return this.matchConstraints != null;
    }

    public MatchConstraintsNested<A> withNewMatchConstraints() {
        return new MatchConstraintsNested(null);
    }

    public MatchConstraintsNested<A> withNewMatchConstraintsLike(V1beta1MatchResources item) {
        return new MatchConstraintsNested(item);
    }

    public MatchConstraintsNested<A> editMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(null));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(new V1beta1MatchResourcesBuilder().build()));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraintsLike(V1beta1MatchResources item) {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(item));
    }

    public V1beta1ParamKind buildParamKind() {
        return this.paramKind != null ? this.paramKind.build() : null;
    }

    public A withParamKind(V1beta1ParamKind paramKind) {
        this._visitables.remove("paramKind");
        if (paramKind != null) {
            this.paramKind = new V1beta1ParamKindBuilder(paramKind);
            this._visitables.get("paramKind").add(this.paramKind);
        } else {
            this.paramKind = null;
            this._visitables.get("paramKind").remove(this.paramKind);
        }
        return (A)this;
    }

    public boolean hasParamKind() {
        return this.paramKind != null;
    }

    public ParamKindNested<A> withNewParamKind() {
        return new ParamKindNested(null);
    }

    public ParamKindNested<A> withNewParamKindLike(V1beta1ParamKind item) {
        return new ParamKindNested(item);
    }

    public ParamKindNested<A> editParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(null));
    }

    public ParamKindNested<A> editOrNewParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(new V1beta1ParamKindBuilder().build()));
    }

    public ParamKindNested<A> editOrNewParamKindLike(V1beta1ParamKind item) {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(item));
    }

    public A addToValidations(int index, V1beta1Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        V1beta1ValidationBuilder builder = new V1beta1ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get("validations").add(index, builder);
            this.validations.add(index, builder);
        }
        return (A)this;
    }

    public A setToValidations(int index, V1beta1Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        V1beta1ValidationBuilder builder = new V1beta1ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get("validations").set(index, builder);
            this.validations.set(index, builder);
        }
        return (A)this;
    }

    public A addToValidations(V1beta1Validation ... items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (V1beta1Validation item : items) {
            V1beta1ValidationBuilder builder = new V1beta1ValidationBuilder(item);
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    public A addAllToValidations(Collection<V1beta1Validation> items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (V1beta1Validation item : items) {
            V1beta1ValidationBuilder builder = new V1beta1ValidationBuilder(item);
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    public A removeFromValidations(V1beta1Validation ... items) {
        if (this.validations == null) {
            return (A)this;
        }
        for (V1beta1Validation item : items) {
            V1beta1ValidationBuilder builder = new V1beta1ValidationBuilder(item);
            this._visitables.get("validations").remove(builder);
            this.validations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromValidations(Collection<V1beta1Validation> items) {
        if (this.validations == null) {
            return (A)this;
        }
        for (V1beta1Validation item : items) {
            V1beta1ValidationBuilder builder = new V1beta1ValidationBuilder(item);
            this._visitables.get("validations").remove(builder);
            this.validations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromValidations(Predicate<V1beta1ValidationBuilder> predicate) {
        if (this.validations == null) {
            return (A)this;
        }
        Iterator<V1beta1ValidationBuilder> each = this.validations.iterator();
        Object visitables = this._visitables.get("validations");
        while (each.hasNext()) {
            V1beta1ValidationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta1Validation> buildValidations() {
        return this.validations != null ? V1beta1ValidatingAdmissionPolicySpecFluent.build(this.validations) : null;
    }

    public V1beta1Validation buildValidation(int index) {
        return this.validations.get(index).build();
    }

    public V1beta1Validation buildFirstValidation() {
        return this.validations.get(0).build();
    }

    public V1beta1Validation buildLastValidation() {
        return this.validations.get(this.validations.size() - 1).build();
    }

    public V1beta1Validation buildMatchingValidation(Predicate<V1beta1ValidationBuilder> predicate) {
        for (V1beta1ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingValidation(Predicate<V1beta1ValidationBuilder> predicate) {
        for (V1beta1ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValidations(List<V1beta1Validation> validations) {
        if (this.validations != null) {
            this._visitables.get("validations").clear();
        }
        if (validations != null) {
            this.validations = new ArrayList();
            for (V1beta1Validation item : validations) {
                this.addToValidations(item);
            }
        } else {
            this.validations = null;
        }
        return (A)this;
    }

    public A withValidations(V1beta1Validation ... validations) {
        if (this.validations != null) {
            this.validations.clear();
            this._visitables.remove("validations");
        }
        if (validations != null) {
            for (V1beta1Validation item : validations) {
                this.addToValidations(item);
            }
        }
        return (A)this;
    }

    public boolean hasValidations() {
        return this.validations != null && !this.validations.isEmpty();
    }

    public ValidationsNested<A> addNewValidation() {
        return new ValidationsNested(-1, null);
    }

    public ValidationsNested<A> addNewValidationLike(V1beta1Validation item) {
        return new ValidationsNested(-1, item);
    }

    public ValidationsNested<A> setNewValidationLike(int index, V1beta1Validation item) {
        return new ValidationsNested(index, item);
    }

    public ValidationsNested<A> editValidation(int index) {
        if (this.validations.size() <= index) {
            throw new RuntimeException("Can't edit validations. Index exceeds size.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public ValidationsNested<A> editFirstValidation() {
        if (this.validations.size() == 0) {
            throw new RuntimeException("Can't edit first validations. The list is empty.");
        }
        return this.setNewValidationLike(0, this.buildValidation(0));
    }

    public ValidationsNested<A> editLastValidation() {
        int index = this.validations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last validations. The list is empty.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public ValidationsNested<A> editMatchingValidation(Predicate<V1beta1ValidationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.validations.size(); ++i) {
            if (!predicate.test(this.validations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching validations. No match found.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public A addToVariables(int index, V1beta1Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        V1beta1VariableBuilder builder = new V1beta1VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get("variables").add(index, builder);
            this.variables.add(index, builder);
        }
        return (A)this;
    }

    public A setToVariables(int index, V1beta1Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        V1beta1VariableBuilder builder = new V1beta1VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get("variables").set(index, builder);
            this.variables.set(index, builder);
        }
        return (A)this;
    }

    public A addToVariables(V1beta1Variable ... items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (V1beta1Variable item : items) {
            V1beta1VariableBuilder builder = new V1beta1VariableBuilder(item);
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        }
        return (A)this;
    }

    public A addAllToVariables(Collection<V1beta1Variable> items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (V1beta1Variable item : items) {
            V1beta1VariableBuilder builder = new V1beta1VariableBuilder(item);
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        }
        return (A)this;
    }

    public A removeFromVariables(V1beta1Variable ... items) {
        if (this.variables == null) {
            return (A)this;
        }
        for (V1beta1Variable item : items) {
            V1beta1VariableBuilder builder = new V1beta1VariableBuilder(item);
            this._visitables.get("variables").remove(builder);
            this.variables.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVariables(Collection<V1beta1Variable> items) {
        if (this.variables == null) {
            return (A)this;
        }
        for (V1beta1Variable item : items) {
            V1beta1VariableBuilder builder = new V1beta1VariableBuilder(item);
            this._visitables.get("variables").remove(builder);
            this.variables.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVariables(Predicate<V1beta1VariableBuilder> predicate) {
        if (this.variables == null) {
            return (A)this;
        }
        Iterator<V1beta1VariableBuilder> each = this.variables.iterator();
        Object visitables = this._visitables.get("variables");
        while (each.hasNext()) {
            V1beta1VariableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta1Variable> buildVariables() {
        return this.variables != null ? V1beta1ValidatingAdmissionPolicySpecFluent.build(this.variables) : null;
    }

    public V1beta1Variable buildVariable(int index) {
        return this.variables.get(index).build();
    }

    public V1beta1Variable buildFirstVariable() {
        return this.variables.get(0).build();
    }

    public V1beta1Variable buildLastVariable() {
        return this.variables.get(this.variables.size() - 1).build();
    }

    public V1beta1Variable buildMatchingVariable(Predicate<V1beta1VariableBuilder> predicate) {
        for (V1beta1VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVariable(Predicate<V1beta1VariableBuilder> predicate) {
        for (V1beta1VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVariables(List<V1beta1Variable> variables) {
        if (this.variables != null) {
            this._visitables.get("variables").clear();
        }
        if (variables != null) {
            this.variables = new ArrayList();
            for (V1beta1Variable item : variables) {
                this.addToVariables(item);
            }
        } else {
            this.variables = null;
        }
        return (A)this;
    }

    public A withVariables(V1beta1Variable ... variables) {
        if (this.variables != null) {
            this.variables.clear();
            this._visitables.remove("variables");
        }
        if (variables != null) {
            for (V1beta1Variable item : variables) {
                this.addToVariables(item);
            }
        }
        return (A)this;
    }

    public boolean hasVariables() {
        return this.variables != null && !this.variables.isEmpty();
    }

    public VariablesNested<A> addNewVariable() {
        return new VariablesNested(-1, null);
    }

    public VariablesNested<A> addNewVariableLike(V1beta1Variable item) {
        return new VariablesNested(-1, item);
    }

    public VariablesNested<A> setNewVariableLike(int index, V1beta1Variable item) {
        return new VariablesNested(index, item);
    }

    public VariablesNested<A> editVariable(int index) {
        if (this.variables.size() <= index) {
            throw new RuntimeException("Can't edit variables. Index exceeds size.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public VariablesNested<A> editFirstVariable() {
        if (this.variables.size() == 0) {
            throw new RuntimeException("Can't edit first variables. The list is empty.");
        }
        return this.setNewVariableLike(0, this.buildVariable(0));
    }

    public VariablesNested<A> editLastVariable() {
        int index = this.variables.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last variables. The list is empty.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public VariablesNested<A> editMatchingVariable(Predicate<V1beta1VariableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!predicate.test(this.variables.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching variables. No match found.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1ValidatingAdmissionPolicySpecFluent that = (V1beta1ValidatingAdmissionPolicySpecFluent)o;
        if (!Objects.equals(this.auditAnnotations, that.auditAnnotations)) {
            return false;
        }
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConditions, that.matchConditions)) {
            return false;
        }
        if (!Objects.equals(this.matchConstraints, that.matchConstraints)) {
            return false;
        }
        if (!Objects.equals(this.paramKind, that.paramKind)) {
            return false;
        }
        if (!Objects.equals(this.validations, that.validations)) {
            return false;
        }
        return Objects.equals(this.variables, that.variables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.auditAnnotations, this.failurePolicy, this.matchConditions, this.matchConstraints, this.paramKind, this.validations, this.variables, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auditAnnotations != null && !this.auditAnnotations.isEmpty()) {
            sb.append("auditAnnotations:");
            sb.append(this.auditAnnotations + ",");
        }
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy + ",");
        }
        if (this.matchConditions != null && !this.matchConditions.isEmpty()) {
            sb.append("matchConditions:");
            sb.append(this.matchConditions + ",");
        }
        if (this.matchConstraints != null) {
            sb.append("matchConstraints:");
            sb.append(this.matchConstraints + ",");
        }
        if (this.paramKind != null) {
            sb.append("paramKind:");
            sb.append(this.paramKind + ",");
        }
        if (this.validations != null && !this.validations.isEmpty()) {
            sb.append("validations:");
            sb.append(this.validations + ",");
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            sb.append("variables:");
            sb.append(this.variables);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AuditAnnotationsNested<N>
    extends V1beta1AuditAnnotationFluent<AuditAnnotationsNested<N>>
    implements Nested<N> {
        V1beta1AuditAnnotationBuilder builder;
        int index;

        AuditAnnotationsNested(int index, V1beta1AuditAnnotation item) {
            this.index = index;
            this.builder = new V1beta1AuditAnnotationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingAdmissionPolicySpecFluent.this.setToAuditAnnotations(this.index, this.builder.build());
        }

        public N endAuditAnnotation() {
            return this.and();
        }
    }

    public class MatchConditionsNested<N>
    extends V1beta1MatchConditionFluent<MatchConditionsNested<N>>
    implements Nested<N> {
        V1beta1MatchConditionBuilder builder;
        int index;

        MatchConditionsNested(int index, V1beta1MatchCondition item) {
            this.index = index;
            this.builder = new V1beta1MatchConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingAdmissionPolicySpecFluent.this.setToMatchConditions(this.index, this.builder.build());
        }

        public N endMatchCondition() {
            return this.and();
        }
    }

    public class MatchConstraintsNested<N>
    extends V1beta1MatchResourcesFluent<MatchConstraintsNested<N>>
    implements Nested<N> {
        V1beta1MatchResourcesBuilder builder;

        MatchConstraintsNested(V1beta1MatchResources item) {
            this.builder = new V1beta1MatchResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingAdmissionPolicySpecFluent.this.withMatchConstraints(this.builder.build());
        }

        public N endMatchConstraints() {
            return this.and();
        }
    }

    public class ParamKindNested<N>
    extends V1beta1ParamKindFluent<ParamKindNested<N>>
    implements Nested<N> {
        V1beta1ParamKindBuilder builder;

        ParamKindNested(V1beta1ParamKind item) {
            this.builder = new V1beta1ParamKindBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingAdmissionPolicySpecFluent.this.withParamKind(this.builder.build());
        }

        public N endParamKind() {
            return this.and();
        }
    }

    public class ValidationsNested<N>
    extends V1beta1ValidationFluent<ValidationsNested<N>>
    implements Nested<N> {
        V1beta1ValidationBuilder builder;
        int index;

        ValidationsNested(int index, V1beta1Validation item) {
            this.index = index;
            this.builder = new V1beta1ValidationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingAdmissionPolicySpecFluent.this.setToValidations(this.index, this.builder.build());
        }

        public N endValidation() {
            return this.and();
        }
    }

    public class VariablesNested<N>
    extends V1beta1VariableFluent<VariablesNested<N>>
    implements Nested<N> {
        V1beta1VariableBuilder builder;
        int index;

        VariablesNested(int index, V1beta1Variable item) {
            this.index = index;
            this.builder = new V1beta1VariableBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingAdmissionPolicySpecFluent.this.setToVariables(this.index, this.builder.build());
        }

        public N endVariable() {
            return this.and();
        }
    }
}

