package io.kubernetes.client.openapi.models;

import java.lang.SuppressWarnings;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class V1alpha3CounterSetFluent<A extends V1alpha3CounterSetFluent<A>> extends BaseFluent<A>{
  public V1alpha3CounterSetFluent() {
  }
  
  public V1alpha3CounterSetFluent(V1alpha3CounterSet instance) {
    this.copyInstance(instance);
  }
  private Map<String,V1alpha3Counter> counters;
  private String name;
  
  protected void copyInstance(V1alpha3CounterSet instance) {
    instance = (instance != null ? instance : new V1alpha3CounterSet());
    if (instance != null) {
          this.withCounters(instance.getCounters());
          this.withName(instance.getName());
        }
  }
  
  public A addToCounters(String key,V1alpha3Counter value) {
    if(this.counters == null && key != null && value != null) { this.counters = new LinkedHashMap(); }
    if(key != null && value != null) {this.counters.put(key, value);} return (A)this;
  }
  
  public A addToCounters(Map<String,V1alpha3Counter> map) {
    if(this.counters == null && map != null) { this.counters = new LinkedHashMap(); }
    if(map != null) { this.counters.putAll(map);} return (A)this;
  }
  
  public A removeFromCounters(String key) {
    if(this.counters == null) { return (A) this; }
    if(key != null && this.counters != null) {this.counters.remove(key);} return (A)this;
  }
  
  public A removeFromCounters(Map<String,V1alpha3Counter> map) {
    if(this.counters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.counters != null){this.counters.remove(key);}}} return (A)this;
  }
  
  public Map<String,V1alpha3Counter> getCounters() {
    return this.counters;
  }
  
  public <K,V>A withCounters(Map<String,V1alpha3Counter> counters) {
    if (counters == null) {
      this.counters = null;
    } else {
      this.counters = new LinkedHashMap(counters);
    }
    return (A) this;
  }
  
  public boolean hasCounters() {
    return this.counters != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    V1alpha3CounterSetFluent that = (V1alpha3CounterSetFluent) o;
    if (!java.util.Objects.equals(counters, that.counters)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(counters,  name,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (counters != null && !counters.isEmpty()) { sb.append("counters:"); sb.append(counters + ","); }
    if (name != null) { sb.append("name:"); sb.append(name); }
    sb.append("}");
    return sb.toString();
  }
  

}