/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeploymentCondition;
import io.kubernetes.client.openapi.models.V1DeploymentConditionBuilder;
import io.kubernetes.client.openapi.models.V1DeploymentConditionFluent;
import io.kubernetes.client.openapi.models.V1DeploymentStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1DeploymentStatusFluent<A extends V1DeploymentStatusFluent<A>>
extends BaseFluent<A> {
    private Integer availableReplicas;
    private Integer collisionCount;
    private ArrayList<V1DeploymentConditionBuilder> conditions;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private Integer terminatingReplicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;

    public V1DeploymentStatusFluent() {
    }

    public V1DeploymentStatusFluent(V1DeploymentStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1DeploymentStatus instance) {
        V1DeploymentStatus v1DeploymentStatus = instance = instance != null ? instance : new V1DeploymentStatus();
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
            this.withTerminatingReplicas(instance.getTerminatingReplicas());
            this.withUnavailableReplicas(instance.getUnavailableReplicas());
            this.withUpdatedReplicas(instance.getUpdatedReplicas());
        }
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    public boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    public boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    public A addToConditions(int index, V1DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1DeploymentConditionBuilder builder = new V1DeploymentConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1DeploymentConditionBuilder builder = new V1DeploymentConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1DeploymentCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1DeploymentCondition item : items) {
            V1DeploymentConditionBuilder builder = new V1DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1DeploymentCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1DeploymentCondition item : items) {
            V1DeploymentConditionBuilder builder = new V1DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1DeploymentCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1DeploymentCondition item : items) {
            V1DeploymentConditionBuilder builder = new V1DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1DeploymentCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1DeploymentCondition item : items) {
            V1DeploymentConditionBuilder builder = new V1DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1DeploymentConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1DeploymentConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1DeploymentConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1DeploymentCondition> buildConditions() {
        return this.conditions != null ? V1DeploymentStatusFluent.build(this.conditions) : null;
    }

    public V1DeploymentCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1DeploymentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1DeploymentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1DeploymentCondition buildMatchingCondition(Predicate<V1DeploymentConditionBuilder> predicate) {
        for (V1DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1DeploymentConditionBuilder> predicate) {
        for (V1DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1DeploymentCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1DeploymentCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1DeploymentCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1DeploymentCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1DeploymentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    public boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Integer getTerminatingReplicas() {
        return this.terminatingReplicas;
    }

    public A withTerminatingReplicas(Integer terminatingReplicas) {
        this.terminatingReplicas = terminatingReplicas;
        return (A)this;
    }

    public boolean hasTerminatingReplicas() {
        return this.terminatingReplicas != null;
    }

    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public A withUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return (A)this;
    }

    public boolean hasUnavailableReplicas() {
        return this.unavailableReplicas != null;
    }

    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    public boolean hasUpdatedReplicas() {
        return this.updatedReplicas != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeploymentStatusFluent that = (V1DeploymentStatusFluent)o;
        if (!Objects.equals(this.availableReplicas, that.availableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.collisionCount, that.collisionCount)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyReplicas, that.readyReplicas)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.terminatingReplicas, that.terminatingReplicas)) {
            return false;
        }
        if (!Objects.equals(this.unavailableReplicas, that.unavailableReplicas)) {
            return false;
        }
        return Objects.equals(this.updatedReplicas, that.updatedReplicas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.observedGeneration, this.readyReplicas, this.replicas, this.terminatingReplicas, this.unavailableReplicas, this.updatedReplicas, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas + ",");
        }
        if (this.collisionCount != null) {
            sb.append("collisionCount:");
            sb.append(this.collisionCount + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.terminatingReplicas != null) {
            sb.append("terminatingReplicas:");
            sb.append(this.terminatingReplicas + ",");
        }
        if (this.unavailableReplicas != null) {
            sb.append("unavailableReplicas:");
            sb.append(this.unavailableReplicas + ",");
        }
        if (this.updatedReplicas != null) {
            sb.append("updatedReplicas:");
            sb.append(this.updatedReplicas);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1DeploymentConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1DeploymentConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1DeploymentCondition item) {
            this.index = index;
            this.builder = new V1DeploymentConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeploymentStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

