/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1FlowDistinguisherMethod;
import io.kubernetes.client.openapi.models.V1FlowDistinguisherMethodBuilder;
import io.kubernetes.client.openapi.models.V1FlowDistinguisherMethodFluent;
import io.kubernetes.client.openapi.models.V1FlowSchemaSpec;
import io.kubernetes.client.openapi.models.V1PolicyRulesWithSubjects;
import io.kubernetes.client.openapi.models.V1PolicyRulesWithSubjectsBuilder;
import io.kubernetes.client.openapi.models.V1PolicyRulesWithSubjectsFluent;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationReference;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationReferenceBuilder;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1FlowSchemaSpecFluent<A extends V1FlowSchemaSpecFluent<A>>
extends BaseFluent<A> {
    private V1FlowDistinguisherMethodBuilder distinguisherMethod;
    private Integer matchingPrecedence;
    private V1PriorityLevelConfigurationReferenceBuilder priorityLevelConfiguration;
    private ArrayList<V1PolicyRulesWithSubjectsBuilder> rules;

    public V1FlowSchemaSpecFluent() {
    }

    public V1FlowSchemaSpecFluent(V1FlowSchemaSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1FlowSchemaSpec instance) {
        V1FlowSchemaSpec v1FlowSchemaSpec = instance = instance != null ? instance : new V1FlowSchemaSpec();
        if (instance != null) {
            this.withDistinguisherMethod(instance.getDistinguisherMethod());
            this.withMatchingPrecedence(instance.getMatchingPrecedence());
            this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration());
            this.withRules(instance.getRules());
        }
    }

    public V1FlowDistinguisherMethod buildDistinguisherMethod() {
        return this.distinguisherMethod != null ? this.distinguisherMethod.build() : null;
    }

    public A withDistinguisherMethod(V1FlowDistinguisherMethod distinguisherMethod) {
        this._visitables.remove("distinguisherMethod");
        if (distinguisherMethod != null) {
            this.distinguisherMethod = new V1FlowDistinguisherMethodBuilder(distinguisherMethod);
            this._visitables.get("distinguisherMethod").add(this.distinguisherMethod);
        } else {
            this.distinguisherMethod = null;
            this._visitables.get("distinguisherMethod").remove(this.distinguisherMethod);
        }
        return (A)this;
    }

    public boolean hasDistinguisherMethod() {
        return this.distinguisherMethod != null;
    }

    public DistinguisherMethodNested<A> withNewDistinguisherMethod() {
        return new DistinguisherMethodNested(null);
    }

    public DistinguisherMethodNested<A> withNewDistinguisherMethodLike(V1FlowDistinguisherMethod item) {
        return new DistinguisherMethodNested(item);
    }

    public DistinguisherMethodNested<A> editDistinguisherMethod() {
        return this.withNewDistinguisherMethodLike(Optional.ofNullable(this.buildDistinguisherMethod()).orElse(null));
    }

    public DistinguisherMethodNested<A> editOrNewDistinguisherMethod() {
        return this.withNewDistinguisherMethodLike(Optional.ofNullable(this.buildDistinguisherMethod()).orElse(new V1FlowDistinguisherMethodBuilder().build()));
    }

    public DistinguisherMethodNested<A> editOrNewDistinguisherMethodLike(V1FlowDistinguisherMethod item) {
        return this.withNewDistinguisherMethodLike(Optional.ofNullable(this.buildDistinguisherMethod()).orElse(item));
    }

    public Integer getMatchingPrecedence() {
        return this.matchingPrecedence;
    }

    public A withMatchingPrecedence(Integer matchingPrecedence) {
        this.matchingPrecedence = matchingPrecedence;
        return (A)this;
    }

    public boolean hasMatchingPrecedence() {
        return this.matchingPrecedence != null;
    }

    public V1PriorityLevelConfigurationReference buildPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration != null ? this.priorityLevelConfiguration.build() : null;
    }

    public A withPriorityLevelConfiguration(V1PriorityLevelConfigurationReference priorityLevelConfiguration) {
        this._visitables.remove("priorityLevelConfiguration");
        if (priorityLevelConfiguration != null) {
            this.priorityLevelConfiguration = new V1PriorityLevelConfigurationReferenceBuilder(priorityLevelConfiguration);
            this._visitables.get("priorityLevelConfiguration").add(this.priorityLevelConfiguration);
        } else {
            this.priorityLevelConfiguration = null;
            this._visitables.get("priorityLevelConfiguration").remove(this.priorityLevelConfiguration);
        }
        return (A)this;
    }

    public boolean hasPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration != null;
    }

    public PriorityLevelConfigurationNested<A> withNewPriorityLevelConfiguration() {
        return new PriorityLevelConfigurationNested(null);
    }

    public PriorityLevelConfigurationNested<A> withNewPriorityLevelConfigurationLike(V1PriorityLevelConfigurationReference item) {
        return new PriorityLevelConfigurationNested(item);
    }

    public PriorityLevelConfigurationNested<A> editPriorityLevelConfiguration() {
        return this.withNewPriorityLevelConfigurationLike(Optional.ofNullable(this.buildPriorityLevelConfiguration()).orElse(null));
    }

    public PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfiguration() {
        return this.withNewPriorityLevelConfigurationLike(Optional.ofNullable(this.buildPriorityLevelConfiguration()).orElse(new V1PriorityLevelConfigurationReferenceBuilder().build()));
    }

    public PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfigurationLike(V1PriorityLevelConfigurationReference item) {
        return this.withNewPriorityLevelConfigurationLike(Optional.ofNullable(this.buildPriorityLevelConfiguration()).orElse(item));
    }

    public A addToRules(int index, V1PolicyRulesWithSubjects item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1PolicyRulesWithSubjectsBuilder builder = new V1PolicyRulesWithSubjectsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    public A setToRules(int index, V1PolicyRulesWithSubjects item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1PolicyRulesWithSubjectsBuilder builder = new V1PolicyRulesWithSubjectsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    public A addToRules(V1PolicyRulesWithSubjects ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1PolicyRulesWithSubjects item : items) {
            V1PolicyRulesWithSubjectsBuilder builder = new V1PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<V1PolicyRulesWithSubjects> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1PolicyRulesWithSubjects item : items) {
            V1PolicyRulesWithSubjectsBuilder builder = new V1PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A removeFromRules(V1PolicyRulesWithSubjects ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (V1PolicyRulesWithSubjects item : items) {
            V1PolicyRulesWithSubjectsBuilder builder = new V1PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<V1PolicyRulesWithSubjects> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (V1PolicyRulesWithSubjects item : items) {
            V1PolicyRulesWithSubjectsBuilder builder = new V1PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRules(Predicate<V1PolicyRulesWithSubjectsBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1PolicyRulesWithSubjectsBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1PolicyRulesWithSubjectsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PolicyRulesWithSubjects> buildRules() {
        return this.rules != null ? V1FlowSchemaSpecFluent.build(this.rules) : null;
    }

    public V1PolicyRulesWithSubjects buildRule(int index) {
        return this.rules.get(index).build();
    }

    public V1PolicyRulesWithSubjects buildFirstRule() {
        return this.rules.get(0).build();
    }

    public V1PolicyRulesWithSubjects buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public V1PolicyRulesWithSubjects buildMatchingRule(Predicate<V1PolicyRulesWithSubjectsBuilder> predicate) {
        for (V1PolicyRulesWithSubjectsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<V1PolicyRulesWithSubjectsBuilder> predicate) {
        for (V1PolicyRulesWithSubjectsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<V1PolicyRulesWithSubjects> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (V1PolicyRulesWithSubjects item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(V1PolicyRulesWithSubjects ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (V1PolicyRulesWithSubjects item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(V1PolicyRulesWithSubjects item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, V1PolicyRulesWithSubjects item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<V1PolicyRulesWithSubjectsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1FlowSchemaSpecFluent that = (V1FlowSchemaSpecFluent)o;
        if (!Objects.equals(this.distinguisherMethod, that.distinguisherMethod)) {
            return false;
        }
        if (!Objects.equals(this.matchingPrecedence, that.matchingPrecedence)) {
            return false;
        }
        if (!Objects.equals(this.priorityLevelConfiguration, that.priorityLevelConfiguration)) {
            return false;
        }
        return Objects.equals(this.rules, that.rules);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinguisherMethod, this.matchingPrecedence, this.priorityLevelConfiguration, this.rules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.distinguisherMethod != null) {
            sb.append("distinguisherMethod:");
            sb.append(this.distinguisherMethod + ",");
        }
        if (this.matchingPrecedence != null) {
            sb.append("matchingPrecedence:");
            sb.append(this.matchingPrecedence + ",");
        }
        if (this.priorityLevelConfiguration != null) {
            sb.append("priorityLevelConfiguration:");
            sb.append(this.priorityLevelConfiguration + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DistinguisherMethodNested<N>
    extends V1FlowDistinguisherMethodFluent<DistinguisherMethodNested<N>>
    implements Nested<N> {
        V1FlowDistinguisherMethodBuilder builder;

        DistinguisherMethodNested(V1FlowDistinguisherMethod item) {
            this.builder = new V1FlowDistinguisherMethodBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1FlowSchemaSpecFluent.this.withDistinguisherMethod(this.builder.build());
        }

        public N endDistinguisherMethod() {
            return this.and();
        }
    }

    public class PriorityLevelConfigurationNested<N>
    extends V1PriorityLevelConfigurationReferenceFluent<PriorityLevelConfigurationNested<N>>
    implements Nested<N> {
        V1PriorityLevelConfigurationReferenceBuilder builder;

        PriorityLevelConfigurationNested(V1PriorityLevelConfigurationReference item) {
            this.builder = new V1PriorityLevelConfigurationReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1FlowSchemaSpecFluent.this.withPriorityLevelConfiguration(this.builder.build());
        }

        public N endPriorityLevelConfiguration() {
            return this.and();
        }
    }

    public class RulesNested<N>
    extends V1PolicyRulesWithSubjectsFluent<RulesNested<N>>
    implements Nested<N> {
        V1PolicyRulesWithSubjectsBuilder builder;
        int index;

        RulesNested(int index, V1PolicyRulesWithSubjects item) {
            this.index = index;
            this.builder = new V1PolicyRulesWithSubjectsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1FlowSchemaSpecFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }
}

