/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1MatchResources;
import io.kubernetes.client.openapi.models.V1NamedRuleWithOperations;
import io.kubernetes.client.openapi.models.V1NamedRuleWithOperationsBuilder;
import io.kubernetes.client.openapi.models.V1NamedRuleWithOperationsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1MatchResourcesFluent<A extends V1MatchResourcesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1NamedRuleWithOperationsBuilder> excludeResourceRules;
    private String matchPolicy;
    private V1LabelSelectorBuilder namespaceSelector;
    private V1LabelSelectorBuilder objectSelector;
    private ArrayList<V1NamedRuleWithOperationsBuilder> resourceRules;

    public V1MatchResourcesFluent() {
    }

    public V1MatchResourcesFluent(V1MatchResources instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1MatchResources instance) {
        V1MatchResources v1MatchResources = instance = instance != null ? instance : new V1MatchResources();
        if (instance != null) {
            this.withExcludeResourceRules(instance.getExcludeResourceRules());
            this.withMatchPolicy(instance.getMatchPolicy());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObjectSelector(instance.getObjectSelector());
            this.withResourceRules(instance.getResourceRules());
        }
    }

    public A addToExcludeResourceRules(int index, V1NamedRuleWithOperations item) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.excludeResourceRules.size()) {
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        } else {
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToExcludeResourceRules(int index, V1NamedRuleWithOperations item) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.excludeResourceRules.size()) {
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        } else {
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToExcludeResourceRules(V1NamedRuleWithOperations ... items) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToExcludeResourceRules(Collection<V1NamedRuleWithOperations> items) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromExcludeResourceRules(V1NamedRuleWithOperations ... items) {
        if (this.excludeResourceRules == null) {
            return (A)this;
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").remove(builder);
            this.excludeResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromExcludeResourceRules(Collection<V1NamedRuleWithOperations> items) {
        if (this.excludeResourceRules == null) {
            return (A)this;
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").remove(builder);
            this.excludeResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromExcludeResourceRules(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        if (this.excludeResourceRules == null) {
            return (A)this;
        }
        Iterator<V1NamedRuleWithOperationsBuilder> each = this.excludeResourceRules.iterator();
        Object visitables = this._visitables.get("excludeResourceRules");
        while (each.hasNext()) {
            V1NamedRuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NamedRuleWithOperations> buildExcludeResourceRules() {
        return this.excludeResourceRules != null ? V1MatchResourcesFluent.build(this.excludeResourceRules) : null;
    }

    public V1NamedRuleWithOperations buildExcludeResourceRule(int index) {
        return this.excludeResourceRules.get(index).build();
    }

    public V1NamedRuleWithOperations buildFirstExcludeResourceRule() {
        return this.excludeResourceRules.get(0).build();
    }

    public V1NamedRuleWithOperations buildLastExcludeResourceRule() {
        return this.excludeResourceRules.get(this.excludeResourceRules.size() - 1).build();
    }

    public V1NamedRuleWithOperations buildMatchingExcludeResourceRule(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        for (V1NamedRuleWithOperationsBuilder item : this.excludeResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExcludeResourceRule(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        for (V1NamedRuleWithOperationsBuilder item : this.excludeResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExcludeResourceRules(List<V1NamedRuleWithOperations> excludeResourceRules) {
        if (this.excludeResourceRules != null) {
            this._visitables.get("excludeResourceRules").clear();
        }
        if (excludeResourceRules != null) {
            this.excludeResourceRules = new ArrayList();
            for (V1NamedRuleWithOperations item : excludeResourceRules) {
                this.addToExcludeResourceRules(item);
            }
        } else {
            this.excludeResourceRules = null;
        }
        return (A)this;
    }

    public A withExcludeResourceRules(V1NamedRuleWithOperations ... excludeResourceRules) {
        if (this.excludeResourceRules != null) {
            this.excludeResourceRules.clear();
            this._visitables.remove("excludeResourceRules");
        }
        if (excludeResourceRules != null) {
            for (V1NamedRuleWithOperations item : excludeResourceRules) {
                this.addToExcludeResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasExcludeResourceRules() {
        return this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty();
    }

    public ExcludeResourceRulesNested<A> addNewExcludeResourceRule() {
        return new ExcludeResourceRulesNested(-1, null);
    }

    public ExcludeResourceRulesNested<A> addNewExcludeResourceRuleLike(V1NamedRuleWithOperations item) {
        return new ExcludeResourceRulesNested(-1, item);
    }

    public ExcludeResourceRulesNested<A> setNewExcludeResourceRuleLike(int index, V1NamedRuleWithOperations item) {
        return new ExcludeResourceRulesNested(index, item);
    }

    public ExcludeResourceRulesNested<A> editExcludeResourceRule(int index) {
        if (this.excludeResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit excludeResourceRules. Index exceeds size.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    public ExcludeResourceRulesNested<A> editFirstExcludeResourceRule() {
        if (this.excludeResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first excludeResourceRules. The list is empty.");
        }
        return this.setNewExcludeResourceRuleLike(0, this.buildExcludeResourceRule(0));
    }

    public ExcludeResourceRulesNested<A> editLastExcludeResourceRule() {
        int index = this.excludeResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last excludeResourceRules. The list is empty.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    public ExcludeResourceRulesNested<A> editMatchingExcludeResourceRule(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.excludeResourceRules.size(); ++i) {
            if (!predicate.test(this.excludeResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching excludeResourceRules. No match found.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)this;
    }

    public boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public V1LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(V1LabelSelector namespaceSelector) {
        this._visitables.remove("namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new V1LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(V1LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(V1LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public V1LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    public A withObjectSelector(V1LabelSelector objectSelector) {
        this._visitables.remove("objectSelector");
        if (objectSelector != null) {
            this.objectSelector = new V1LabelSelectorBuilder(objectSelector);
            this._visitables.get("objectSelector").add(this.objectSelector);
        } else {
            this.objectSelector = null;
            this._visitables.get("objectSelector").remove(this.objectSelector);
        }
        return (A)this;
    }

    public boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNested(null);
    }

    public ObjectSelectorNested<A> withNewObjectSelectorLike(V1LabelSelector item) {
        return new ObjectSelectorNested(item);
    }

    public ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(null));
    }

    public ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public ObjectSelectorNested<A> editOrNewObjectSelectorLike(V1LabelSelector item) {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(item));
    }

    public A addToResourceRules(int index, V1NamedRuleWithOperations item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceRules(int index, V1NamedRuleWithOperations item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceRules(V1NamedRuleWithOperations ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceRules(Collection<V1NamedRuleWithOperations> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceRules(V1NamedRuleWithOperations ... items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceRules(Collection<V1NamedRuleWithOperations> items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1NamedRuleWithOperations item : items) {
            V1NamedRuleWithOperationsBuilder builder = new V1NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<V1NamedRuleWithOperationsBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            V1NamedRuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NamedRuleWithOperations> buildResourceRules() {
        return this.resourceRules != null ? V1MatchResourcesFluent.build(this.resourceRules) : null;
    }

    public V1NamedRuleWithOperations buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public V1NamedRuleWithOperations buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public V1NamedRuleWithOperations buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public V1NamedRuleWithOperations buildMatchingResourceRule(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        for (V1NamedRuleWithOperationsBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        for (V1NamedRuleWithOperationsBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<V1NamedRuleWithOperations> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (V1NamedRuleWithOperations item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    public A withResourceRules(V1NamedRuleWithOperations ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove("resourceRules");
        }
        if (resourceRules != null) {
            for (V1NamedRuleWithOperations item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(V1NamedRuleWithOperations item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, V1NamedRuleWithOperations item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<V1NamedRuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1MatchResourcesFluent that = (V1MatchResourcesFluent)o;
        if (!Objects.equals(this.excludeResourceRules, that.excludeResourceRules)) {
            return false;
        }
        if (!Objects.equals(this.matchPolicy, that.matchPolicy)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.objectSelector, that.objectSelector)) {
            return false;
        }
        return Objects.equals(this.resourceRules, that.resourceRules);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.excludeResourceRules, this.matchPolicy, this.namespaceSelector, this.objectSelector, this.resourceRules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty()) {
            sb.append("excludeResourceRules:");
            sb.append(this.excludeResourceRules + ",");
        }
        if (this.matchPolicy != null) {
            sb.append("matchPolicy:");
            sb.append(this.matchPolicy + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.objectSelector != null) {
            sb.append("objectSelector:");
            sb.append(this.objectSelector + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExcludeResourceRulesNested<N>
    extends V1NamedRuleWithOperationsFluent<ExcludeResourceRulesNested<N>>
    implements Nested<N> {
        V1NamedRuleWithOperationsBuilder builder;
        int index;

        ExcludeResourceRulesNested(int index, V1NamedRuleWithOperations item) {
            this.index = index;
            this.builder = new V1NamedRuleWithOperationsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1MatchResourcesFluent.this.setToExcludeResourceRules(this.index, this.builder.build());
        }

        public N endExcludeResourceRule() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends V1LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        NamespaceSelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1MatchResourcesFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class ObjectSelectorNested<N>
    extends V1LabelSelectorFluent<ObjectSelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        ObjectSelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1MatchResourcesFluent.this.withObjectSelector(this.builder.build());
        }

        public N endObjectSelector() {
            return this.and();
        }
    }

    public class ResourceRulesNested<N>
    extends V1NamedRuleWithOperationsFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        V1NamedRuleWithOperationsBuilder builder;
        int index;

        ResourceRulesNested(int index, V1NamedRuleWithOperations item) {
            this.index = index;
            this.builder = new V1NamedRuleWithOperationsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1MatchResourcesFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }
}

