/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRuleBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRuleFluent;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRuleBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRuleFluent;
import io.kubernetes.client.openapi.models.V1NetworkPolicySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1NetworkPolicySpecFluent<A extends V1NetworkPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1NetworkPolicyEgressRuleBuilder> egress;
    private ArrayList<V1NetworkPolicyIngressRuleBuilder> ingress;
    private V1LabelSelectorBuilder podSelector;
    private List<String> policyTypes;

    public V1NetworkPolicySpecFluent() {
    }

    public V1NetworkPolicySpecFluent(V1NetworkPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1NetworkPolicySpec instance) {
        V1NetworkPolicySpec v1NetworkPolicySpec = instance = instance != null ? instance : new V1NetworkPolicySpec();
        if (instance != null) {
            this.withEgress(instance.getEgress());
            this.withIngress(instance.getIngress());
            this.withPodSelector(instance.getPodSelector());
            this.withPolicyTypes(instance.getPolicyTypes());
        }
    }

    public A addToEgress(int index, V1NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get("egress").add(builder);
            this.egress.add(index, builder);
        }
        return (A)this;
    }

    public A setToEgress(int index, V1NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get("egress").add(builder);
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    public A addToEgress(V1NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    public A addAllToEgress(Collection<V1NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    public A removeFromEgress(V1NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            return (A)this;
        }
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            this.egress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEgress(Collection<V1NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            return (A)this;
        }
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            this.egress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyEgressRuleBuilder> each = this.egress.iterator();
        Object visitables = this._visitables.get("egress");
        while (each.hasNext()) {
            V1NetworkPolicyEgressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NetworkPolicyEgressRule> buildEgress() {
        return this.egress != null ? V1NetworkPolicySpecFluent.build(this.egress) : null;
    }

    public V1NetworkPolicyEgressRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    public V1NetworkPolicyEgressRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    public V1NetworkPolicyEgressRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    public V1NetworkPolicyEgressRule buildMatchingEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        for (V1NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        for (V1NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgress(List<V1NetworkPolicyEgressRule> egress) {
        if (this.egress != null) {
            this._visitables.get("egress").clear();
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (V1NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    public A withEgress(V1NetworkPolicyEgressRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
            this._visitables.remove("egress");
        }
        if (egress != null) {
            for (V1NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    public boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    public EgressNested<A> addNewEgress() {
        return new EgressNested(-1, null);
    }

    public EgressNested<A> addNewEgressLike(V1NetworkPolicyEgressRule item) {
        return new EgressNested(-1, item);
    }

    public EgressNested<A> setNewEgressLike(int index, V1NetworkPolicyEgressRule item) {
        return new EgressNested(index, item);
    }

    public EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    public EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editMatchingEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public A addToIngress(int index, V1NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    public A setToIngress(int index, V1NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    public A addToIngress(V1NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A addAllToIngress(Collection<V1NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A removeFromIngress(V1NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIngress(Collection<V1NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyIngressRuleBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1NetworkPolicyIngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NetworkPolicyIngressRule> buildIngress() {
        return this.ingress != null ? V1NetworkPolicySpecFluent.build(this.ingress) : null;
    }

    public V1NetworkPolicyIngressRule buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public V1NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public V1NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public V1NetworkPolicyIngressRule buildMatchingIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        for (V1NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        for (V1NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<V1NetworkPolicyIngressRule> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (V1NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    public A withIngress(V1NetworkPolicyIngressRule ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (V1NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(V1NetworkPolicyIngressRule item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, V1NetworkPolicyIngressRule item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public V1LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    public A withPodSelector(V1LabelSelector podSelector) {
        this._visitables.remove("podSelector");
        if (podSelector != null) {
            this.podSelector = new V1LabelSelectorBuilder(podSelector);
            this._visitables.get("podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get("podSelector").remove(this.podSelector);
        }
        return (A)this;
    }

    public boolean hasPodSelector() {
        return this.podSelector != null;
    }

    public PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNested(null);
    }

    public PodSelectorNested<A> withNewPodSelectorLike(V1LabelSelector item) {
        return new PodSelectorNested(item);
    }

    public PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(null));
    }

    public PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public PodSelectorNested<A> editOrNewPodSelectorLike(V1LabelSelector item) {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(item));
    }

    public A addToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(index, item);
        return (A)this;
    }

    public A setToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.set(index, item);
        return (A)this;
    }

    public A addToPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    public A addAllToPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    public A removeFromPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public String getPolicyType(int index) {
        return this.policyTypes.get(index);
    }

    public String getFirstPolicyType() {
        return this.policyTypes.get(0);
    }

    public String getLastPolicyType() {
        return this.policyTypes.get(this.policyTypes.size() - 1);
    }

    public String getMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicyTypes(List<String> policyTypes) {
        if (policyTypes != null) {
            this.policyTypes = new ArrayList<String>();
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        } else {
            this.policyTypes = null;
        }
        return (A)this;
    }

    public A withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes != null) {
            this.policyTypes.clear();
            this._visitables.remove("policyTypes");
        }
        if (policyTypes != null) {
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        }
        return (A)this;
    }

    public boolean hasPolicyTypes() {
        return this.policyTypes != null && !this.policyTypes.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NetworkPolicySpecFluent that = (V1NetworkPolicySpecFluent)o;
        if (!Objects.equals(this.egress, that.egress)) {
            return false;
        }
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.policyTypes, that.policyTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null && !this.egress.isEmpty()) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.policyTypes != null && !this.policyTypes.isEmpty()) {
            sb.append("policyTypes:");
            sb.append(this.policyTypes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EgressNested<N>
    extends V1NetworkPolicyEgressRuleFluent<EgressNested<N>>
    implements Nested<N> {
        V1NetworkPolicyEgressRuleBuilder builder;
        int index;

        EgressNested(int index, V1NetworkPolicyEgressRule item) {
            this.index = index;
            this.builder = new V1NetworkPolicyEgressRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicySpecFluent.this.setToEgress(this.index, this.builder.build());
        }

        public N endEgress() {
            return this.and();
        }
    }

    public class IngressNested<N>
    extends V1NetworkPolicyIngressRuleFluent<IngressNested<N>>
    implements Nested<N> {
        V1NetworkPolicyIngressRuleBuilder builder;
        int index;

        IngressNested(int index, V1NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new V1NetworkPolicyIngressRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicySpecFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }

    public class PodSelectorNested<N>
    extends V1LabelSelectorFluent<PodSelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        PodSelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicySpecFluent.this.withPodSelector(this.builder.build());
        }

        public N endPodSelector() {
            return this.and();
        }
    }
}

