/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1NonResourceRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NonResourceRuleFluent<A extends V1NonResourceRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> nonResourceURLs;
    private List<String> verbs;

    public V1NonResourceRuleFluent() {
    }

    public V1NonResourceRuleFluent(V1NonResourceRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1NonResourceRule instance) {
        V1NonResourceRule v1NonResourceRule = instance = instance != null ? instance : new V1NonResourceRule();
        if (instance != null) {
            this.withNonResourceURLs(instance.getNonResourceURLs());
            this.withVerbs(instance.getVerbs());
        }
    }

    public A addToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)this;
    }

    public A setToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)this;
    }

    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    public A removeFromNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public String getNonResourceURL(int index) {
        return this.nonResourceURLs.get(index);
    }

    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)this;
    }

    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
            this._visitables.remove("nonResourceURLs");
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    public A setToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A removeFromVerbs(String ... items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public List<String> getVerbs() {
        return this.verbs;
    }

    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
            this._visitables.remove("verbs");
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    public boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NonResourceRuleFluent that = (V1NonResourceRuleFluent)o;
        if (!Objects.equals(this.nonResourceURLs, that.nonResourceURLs)) {
            return false;
        }
        return Objects.equals(this.verbs, that.verbs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty()) {
            sb.append("nonResourceURLs:");
            sb.append(this.nonResourceURLs + ",");
        }
        if (this.verbs != null && !this.verbs.isEmpty()) {
            sb.append("verbs:");
            sb.append(this.verbs);
        }
        sb.append("}");
        return sb.toString();
    }
}

