/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationCondition;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationConditionBuilder;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationConditionFluent;
import io.kubernetes.client.openapi.models.V1PriorityLevelConfigurationStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PriorityLevelConfigurationStatusFluent<A extends V1PriorityLevelConfigurationStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1PriorityLevelConfigurationConditionBuilder> conditions;

    public V1PriorityLevelConfigurationStatusFluent() {
    }

    public V1PriorityLevelConfigurationStatusFluent(V1PriorityLevelConfigurationStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PriorityLevelConfigurationStatus instance) {
        V1PriorityLevelConfigurationStatus v1PriorityLevelConfigurationStatus = instance = instance != null ? instance : new V1PriorityLevelConfigurationStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
        }
    }

    public A addToConditions(int index, V1PriorityLevelConfigurationCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1PriorityLevelConfigurationConditionBuilder builder = new V1PriorityLevelConfigurationConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1PriorityLevelConfigurationCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1PriorityLevelConfigurationConditionBuilder builder = new V1PriorityLevelConfigurationConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1PriorityLevelConfigurationCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1PriorityLevelConfigurationCondition item : items) {
            V1PriorityLevelConfigurationConditionBuilder builder = new V1PriorityLevelConfigurationConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1PriorityLevelConfigurationCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1PriorityLevelConfigurationCondition item : items) {
            V1PriorityLevelConfigurationConditionBuilder builder = new V1PriorityLevelConfigurationConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1PriorityLevelConfigurationCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1PriorityLevelConfigurationCondition item : items) {
            V1PriorityLevelConfigurationConditionBuilder builder = new V1PriorityLevelConfigurationConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1PriorityLevelConfigurationCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1PriorityLevelConfigurationCondition item : items) {
            V1PriorityLevelConfigurationConditionBuilder builder = new V1PriorityLevelConfigurationConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1PriorityLevelConfigurationConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1PriorityLevelConfigurationConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1PriorityLevelConfigurationConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PriorityLevelConfigurationCondition> buildConditions() {
        return this.conditions != null ? V1PriorityLevelConfigurationStatusFluent.build(this.conditions) : null;
    }

    public V1PriorityLevelConfigurationCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1PriorityLevelConfigurationCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1PriorityLevelConfigurationCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1PriorityLevelConfigurationCondition buildMatchingCondition(Predicate<V1PriorityLevelConfigurationConditionBuilder> predicate) {
        for (V1PriorityLevelConfigurationConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1PriorityLevelConfigurationConditionBuilder> predicate) {
        for (V1PriorityLevelConfigurationConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1PriorityLevelConfigurationCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1PriorityLevelConfigurationCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1PriorityLevelConfigurationCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1PriorityLevelConfigurationCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1PriorityLevelConfigurationCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1PriorityLevelConfigurationCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1PriorityLevelConfigurationConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PriorityLevelConfigurationStatusFluent that = (V1PriorityLevelConfigurationStatusFluent)o;
        return Objects.equals(this.conditions, that.conditions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1PriorityLevelConfigurationConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1PriorityLevelConfigurationConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1PriorityLevelConfigurationCondition item) {
            this.index = index;
            this.builder = new V1PriorityLevelConfigurationConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PriorityLevelConfigurationStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

