/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1StatefulSetOrdinals;
import io.kubernetes.client.openapi.models.V1StatefulSetPersistentVolumeClaimRetentionPolicy;
import io.kubernetes.client.openapi.models.V1StatefulSetUpdateStrategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A StatefulSetSpec is the specification of a StatefulSet.")
public class V1StatefulSetSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_ORDINALS = "ordinals";
    @SerializedName(value="ordinals")
    private V1StatefulSetOrdinals ordinals;
    public static final String SERIALIZED_NAME_PERSISTENT_VOLUME_CLAIM_RETENTION_POLICY = "persistentVolumeClaimRetentionPolicy";
    @SerializedName(value="persistentVolumeClaimRetentionPolicy")
    private V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy;
    public static final String SERIALIZED_NAME_POD_MANAGEMENT_POLICY = "podManagementPolicy";
    @SerializedName(value="podManagementPolicy")
    private String podManagementPolicy;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    @SerializedName(value="revisionHistoryLimit")
    private Integer revisionHistoryLimit;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_SERVICE_NAME = "serviceName";
    @SerializedName(value="serviceName")
    private String serviceName;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    public static final String SERIALIZED_NAME_UPDATE_STRATEGY = "updateStrategy";
    @SerializedName(value="updateStrategy")
    private V1StatefulSetUpdateStrategy updateStrategy;
    public static final String SERIALIZED_NAME_VOLUME_CLAIM_TEMPLATES = "volumeClaimTemplates";
    @SerializedName(value="volumeClaimTemplates")
    private List<V1PersistentVolumeClaim> volumeClaimTemplates = null;

    public V1StatefulSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1StatefulSetSpec ordinals(V1StatefulSetOrdinals ordinals) {
        this.ordinals = ordinals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1StatefulSetOrdinals getOrdinals() {
        return this.ordinals;
    }

    public void setOrdinals(V1StatefulSetOrdinals ordinals) {
        this.ordinals = ordinals;
    }

    public V1StatefulSetSpec persistentVolumeClaimRetentionPolicy(V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy;
    }

    public void setPersistentVolumeClaimRetentionPolicy(V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
    }

    public V1StatefulSetSpec podManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.")
    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    public void setPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
    }

    public V1StatefulSetSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1StatefulSetSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.")
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1StatefulSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1StatefulSetSpec serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public V1StatefulSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1StatefulSetSpec updateStrategy(V1StatefulSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1StatefulSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(V1StatefulSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public V1StatefulSetSpec volumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
        return this;
    }

    public V1StatefulSetSpec addVolumeClaimTemplatesItem(V1PersistentVolumeClaim volumeClaimTemplatesItem) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaim>();
        }
        this.volumeClaimTemplates.add(volumeClaimTemplatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.")
    public List<V1PersistentVolumeClaim> getVolumeClaimTemplates() {
        return this.volumeClaimTemplates;
    }

    public void setVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetSpec v1StatefulSetSpec = (V1StatefulSetSpec)o;
        return Objects.equals(this.minReadySeconds, v1StatefulSetSpec.minReadySeconds) && Objects.equals(this.ordinals, v1StatefulSetSpec.ordinals) && Objects.equals(this.persistentVolumeClaimRetentionPolicy, v1StatefulSetSpec.persistentVolumeClaimRetentionPolicy) && Objects.equals(this.podManagementPolicy, v1StatefulSetSpec.podManagementPolicy) && Objects.equals(this.replicas, v1StatefulSetSpec.replicas) && Objects.equals(this.revisionHistoryLimit, v1StatefulSetSpec.revisionHistoryLimit) && Objects.equals(this.selector, v1StatefulSetSpec.selector) && Objects.equals(this.serviceName, v1StatefulSetSpec.serviceName) && Objects.equals(this.template, v1StatefulSetSpec.template) && Objects.equals(this.updateStrategy, v1StatefulSetSpec.updateStrategy) && Objects.equals(this.volumeClaimTemplates, v1StatefulSetSpec.volumeClaimTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.ordinals, this.persistentVolumeClaimRetentionPolicy, this.podManagementPolicy, this.replicas, this.revisionHistoryLimit, this.selector, this.serviceName, this.template, this.updateStrategy, this.volumeClaimTemplates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    ordinals: ").append(this.toIndentedString(this.ordinals)).append("\n");
        sb.append("    persistentVolumeClaimRetentionPolicy: ").append(this.toIndentedString(this.persistentVolumeClaimRetentionPolicy)).append("\n");
        sb.append("    podManagementPolicy: ").append(this.toIndentedString(this.podManagementPolicy)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    revisionHistoryLimit: ").append(this.toIndentedString(this.revisionHistoryLimit)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    updateStrategy: ").append(this.toIndentedString(this.updateStrategy)).append("\n");
        sb.append("    volumeClaimTemplates: ").append(this.toIndentedString(this.volumeClaimTemplates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

