/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1StorageClass;
import io.kubernetes.client.openapi.models.V1TopologySelectorTerm;
import io.kubernetes.client.openapi.models.V1TopologySelectorTermBuilder;
import io.kubernetes.client.openapi.models.V1TopologySelectorTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1StorageClassFluent<A extends V1StorageClassFluent<A>>
extends BaseFluent<A> {
    private Boolean allowVolumeExpansion;
    private ArrayList<V1TopologySelectorTermBuilder> allowedTopologies;
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<String> mountOptions;
    private Map<String, String> parameters;
    private String provisioner;
    private String reclaimPolicy;
    private String volumeBindingMode;

    public V1StorageClassFluent() {
    }

    public V1StorageClassFluent(V1StorageClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1StorageClass instance) {
        V1StorageClass v1StorageClass = instance = instance != null ? instance : new V1StorageClass();
        if (instance != null) {
            this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
            this.withAllowedTopologies(instance.getAllowedTopologies());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withMountOptions(instance.getMountOptions());
            this.withParameters(instance.getParameters());
            this.withProvisioner(instance.getProvisioner());
            this.withReclaimPolicy(instance.getReclaimPolicy());
            this.withVolumeBindingMode(instance.getVolumeBindingMode());
        }
    }

    public Boolean getAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return (A)this;
    }

    public boolean hasAllowVolumeExpansion() {
        return this.allowVolumeExpansion != null;
    }

    public A addToAllowedTopologies(int index, V1TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList();
        }
        V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
        if (index < 0 || index >= this.allowedTopologies.size()) {
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(builder);
        } else {
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(index, builder);
        }
        return (A)this;
    }

    public A setToAllowedTopologies(int index, V1TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList();
        }
        V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
        if (index < 0 || index >= this.allowedTopologies.size()) {
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(builder);
        } else {
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.set(index, builder);
        }
        return (A)this;
    }

    public A addToAllowedTopologies(V1TopologySelectorTerm ... items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList();
        }
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(builder);
        }
        return (A)this;
    }

    public A addAllToAllowedTopologies(Collection<V1TopologySelectorTerm> items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList();
        }
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(builder);
        }
        return (A)this;
    }

    public A removeFromAllowedTopologies(V1TopologySelectorTerm ... items) {
        if (this.allowedTopologies == null) {
            return (A)this;
        }
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").remove(builder);
            this.allowedTopologies.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAllowedTopologies(Collection<V1TopologySelectorTerm> items) {
        if (this.allowedTopologies == null) {
            return (A)this;
        }
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").remove(builder);
            this.allowedTopologies.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAllowedTopologies(Predicate<V1TopologySelectorTermBuilder> predicate) {
        if (this.allowedTopologies == null) {
            return (A)this;
        }
        Iterator<V1TopologySelectorTermBuilder> each = this.allowedTopologies.iterator();
        Object visitables = this._visitables.get("allowedTopologies");
        while (each.hasNext()) {
            V1TopologySelectorTermBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1TopologySelectorTerm> buildAllowedTopologies() {
        return this.allowedTopologies != null ? V1StorageClassFluent.build(this.allowedTopologies) : null;
    }

    public V1TopologySelectorTerm buildAllowedTopology(int index) {
        return this.allowedTopologies.get(index).build();
    }

    public V1TopologySelectorTerm buildFirstAllowedTopology() {
        return this.allowedTopologies.get(0).build();
    }

    public V1TopologySelectorTerm buildLastAllowedTopology() {
        return this.allowedTopologies.get(this.allowedTopologies.size() - 1).build();
    }

    public V1TopologySelectorTerm buildMatchingAllowedTopology(Predicate<V1TopologySelectorTermBuilder> predicate) {
        for (V1TopologySelectorTermBuilder item : this.allowedTopologies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllowedTopology(Predicate<V1TopologySelectorTermBuilder> predicate) {
        for (V1TopologySelectorTermBuilder item : this.allowedTopologies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedTopologies(List<V1TopologySelectorTerm> allowedTopologies) {
        if (this.allowedTopologies != null) {
            this._visitables.get("allowedTopologies").clear();
        }
        if (allowedTopologies != null) {
            this.allowedTopologies = new ArrayList();
            for (V1TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        } else {
            this.allowedTopologies = null;
        }
        return (A)this;
    }

    public A withAllowedTopologies(V1TopologySelectorTerm ... allowedTopologies) {
        if (this.allowedTopologies != null) {
            this.allowedTopologies.clear();
            this._visitables.remove("allowedTopologies");
        }
        if (allowedTopologies != null) {
            for (V1TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedTopologies() {
        return this.allowedTopologies != null && !this.allowedTopologies.isEmpty();
    }

    public AllowedTopologiesNested<A> addNewAllowedTopology() {
        return new AllowedTopologiesNested(-1, null);
    }

    public AllowedTopologiesNested<A> addNewAllowedTopologyLike(V1TopologySelectorTerm item) {
        return new AllowedTopologiesNested(-1, item);
    }

    public AllowedTopologiesNested<A> setNewAllowedTopologyLike(int index, V1TopologySelectorTerm item) {
        return new AllowedTopologiesNested(index, item);
    }

    public AllowedTopologiesNested<A> editAllowedTopology(int index) {
        if (this.allowedTopologies.size() <= index) {
            throw new RuntimeException("Can't edit allowedTopologies. Index exceeds size.");
        }
        return this.setNewAllowedTopologyLike(index, this.buildAllowedTopology(index));
    }

    public AllowedTopologiesNested<A> editFirstAllowedTopology() {
        if (this.allowedTopologies.size() == 0) {
            throw new RuntimeException("Can't edit first allowedTopologies. The list is empty.");
        }
        return this.setNewAllowedTopologyLike(0, this.buildAllowedTopology(0));
    }

    public AllowedTopologiesNested<A> editLastAllowedTopology() {
        int index = this.allowedTopologies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedTopologies. The list is empty.");
        }
        return this.setNewAllowedTopologyLike(index, this.buildAllowedTopology(index));
    }

    public AllowedTopologiesNested<A> editMatchingAllowedTopology(Predicate<V1TopologySelectorTermBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedTopologies.size(); ++i) {
            if (!predicate.test(this.allowedTopologies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedTopologies. No match found.");
        }
        return this.setNewAllowedTopologyLike(index, this.buildAllowedTopology(index));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(index, item);
        return (A)this;
    }

    public A setToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.set(index, item);
        return (A)this;
    }

    public A addToMountOptions(String ... items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    public A addAllToMountOptions(Collection<String> items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    public A removeFromMountOptions(String ... items) {
        if (this.mountOptions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMountOptions(Collection<String> items) {
        if (this.mountOptions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public String getMountOption(int index) {
        return this.mountOptions.get(index);
    }

    public String getFirstMountOption() {
        return this.mountOptions.get(0);
    }

    public String getLastMountOption() {
        return this.mountOptions.get(this.mountOptions.size() - 1);
    }

    public String getMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMountOptions(List<String> mountOptions) {
        if (mountOptions != null) {
            this.mountOptions = new ArrayList<String>();
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        } else {
            this.mountOptions = null;
        }
        return (A)this;
    }

    public A withMountOptions(String ... mountOptions) {
        if (this.mountOptions != null) {
            this.mountOptions.clear();
            this._visitables.remove("mountOptions");
        }
        if (mountOptions != null) {
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMountOptions() {
        return this.mountOptions != null && !this.mountOptions.isEmpty();
    }

    public A addToParameters(String key, String value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)this;
    }

    public A addToParameters(Map<String, String> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)this;
    }

    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)this;
    }

    public A removeFromParameters(Map<String, String> map) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public <K, V> A withParameters(Map<String, String> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, String>(parameters);
        return (A)this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public String getProvisioner() {
        return this.provisioner;
    }

    public A withProvisioner(String provisioner) {
        this.provisioner = provisioner;
        return (A)this;
    }

    public boolean hasProvisioner() {
        return this.provisioner != null;
    }

    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public A withReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return (A)this;
    }

    public boolean hasReclaimPolicy() {
        return this.reclaimPolicy != null;
    }

    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    public A withVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return (A)this;
    }

    public boolean hasVolumeBindingMode() {
        return this.volumeBindingMode != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StorageClassFluent that = (V1StorageClassFluent)o;
        if (!Objects.equals(this.allowVolumeExpansion, that.allowVolumeExpansion)) {
            return false;
        }
        if (!Objects.equals(this.allowedTopologies, that.allowedTopologies)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.mountOptions, that.mountOptions)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.provisioner, that.provisioner)) {
            return false;
        }
        if (!Objects.equals(this.reclaimPolicy, that.reclaimPolicy)) {
            return false;
        }
        return Objects.equals(this.volumeBindingMode, that.volumeBindingMode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy, this.volumeBindingMode, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowVolumeExpansion != null) {
            sb.append("allowVolumeExpansion:");
            sb.append(this.allowVolumeExpansion + ",");
        }
        if (this.allowedTopologies != null && !this.allowedTopologies.isEmpty()) {
            sb.append("allowedTopologies:");
            sb.append(this.allowedTopologies + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.mountOptions != null && !this.mountOptions.isEmpty()) {
            sb.append("mountOptions:");
            sb.append(this.mountOptions + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.provisioner != null) {
            sb.append("provisioner:");
            sb.append(this.provisioner + ",");
        }
        if (this.reclaimPolicy != null) {
            sb.append("reclaimPolicy:");
            sb.append(this.reclaimPolicy + ",");
        }
        if (this.volumeBindingMode != null) {
            sb.append("volumeBindingMode:");
            sb.append(this.volumeBindingMode);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowVolumeExpansion() {
        return this.withAllowVolumeExpansion(true);
    }

    public class AllowedTopologiesNested<N>
    extends V1TopologySelectorTermFluent<AllowedTopologiesNested<N>>
    implements Nested<N> {
        V1TopologySelectorTermBuilder builder;
        int index;

        AllowedTopologiesNested(int index, V1TopologySelectorTerm item) {
            this.index = index;
            this.builder = new V1TopologySelectorTermBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1StorageClassFluent.this.setToAllowedTopologies(this.index, this.builder.build());
        }

        public N endAllowedTopology() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1StorageClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

