/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1ValidatingWebhook;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookBuilder;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookConfiguration;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ValidatingWebhookConfigurationFluent<A extends V1ValidatingWebhookConfigurationFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<V1ValidatingWebhookBuilder> webhooks;

    public V1ValidatingWebhookConfigurationFluent() {
    }

    public V1ValidatingWebhookConfigurationFluent(V1ValidatingWebhookConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ValidatingWebhookConfiguration instance) {
        V1ValidatingWebhookConfiguration v1ValidatingWebhookConfiguration = instance = instance != null ? instance : new V1ValidatingWebhookConfiguration();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withWebhooks(instance.getWebhooks());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToWebhooks(int index, V1ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
        if (index < 0 || index >= this.webhooks.size()) {
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        } else {
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(index, builder);
        }
        return (A)this;
    }

    public A setToWebhooks(int index, V1ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
        if (index < 0 || index >= this.webhooks.size()) {
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        } else {
            this._visitables.get("webhooks").add(builder);
            this.webhooks.set(index, builder);
        }
        return (A)this;
    }

    public A addToWebhooks(V1ValidatingWebhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    public A addAllToWebhooks(Collection<V1ValidatingWebhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    public A removeFromWebhooks(V1ValidatingWebhook ... items) {
        if (this.webhooks == null) {
            return (A)this;
        }
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromWebhooks(Collection<V1ValidatingWebhook> items) {
        if (this.webhooks == null) {
            return (A)this;
        }
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromWebhooks(Predicate<V1ValidatingWebhookBuilder> predicate) {
        if (this.webhooks == null) {
            return (A)this;
        }
        Iterator<V1ValidatingWebhookBuilder> each = this.webhooks.iterator();
        Object visitables = this._visitables.get("webhooks");
        while (each.hasNext()) {
            V1ValidatingWebhookBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ValidatingWebhook> buildWebhooks() {
        return this.webhooks != null ? V1ValidatingWebhookConfigurationFluent.build(this.webhooks) : null;
    }

    public V1ValidatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    public V1ValidatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    public V1ValidatingWebhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    public V1ValidatingWebhook buildMatchingWebhook(Predicate<V1ValidatingWebhookBuilder> predicate) {
        for (V1ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWebhook(Predicate<V1ValidatingWebhookBuilder> predicate) {
        for (V1ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWebhooks(List<V1ValidatingWebhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get("webhooks").clear();
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList();
            for (V1ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)this;
    }

    public A withWebhooks(V1ValidatingWebhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
            this._visitables.remove("webhooks");
        }
        if (webhooks != null) {
            for (V1ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)this;
    }

    public boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    public WebhooksNested<A> addNewWebhook() {
        return new WebhooksNested(-1, null);
    }

    public WebhooksNested<A> addNewWebhookLike(V1ValidatingWebhook item) {
        return new WebhooksNested(-1, item);
    }

    public WebhooksNested<A> setNewWebhookLike(int index, V1ValidatingWebhook item) {
        return new WebhooksNested(index, item);
    }

    public WebhooksNested<A> editWebhook(int index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    public WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public WebhooksNested<A> editMatchingWebhook(Predicate<V1ValidatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.test(this.webhooks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ValidatingWebhookConfigurationFluent that = (V1ValidatingWebhookConfigurationFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.webhooks, that.webhooks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.webhooks != null && !this.webhooks.isEmpty()) {
            sb.append("webhooks:");
            sb.append(this.webhooks);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookConfigurationFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class WebhooksNested<N>
    extends V1ValidatingWebhookFluent<WebhooksNested<N>>
    implements Nested<N> {
        V1ValidatingWebhookBuilder builder;
        int index;

        WebhooksNested(int index, V1ValidatingWebhook item) {
            this.index = index;
            this.builder = new V1ValidatingWebhookBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookConfigurationFluent.this.setToWebhooks(this.index, this.builder.build());
        }

        public N endWebhook() {
            return this.and();
        }
    }
}

