/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.")
public class V1alpha3DeviceTaintSelector {
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private String device;
    public static final String SERIALIZED_NAME_DEVICE_CLASS_NAME = "deviceClassName";
    @SerializedName(value="deviceClassName")
    private String deviceClassName;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    private String pool;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    private List<V1alpha3DeviceSelector> selectors = null;

    public V1alpha3DeviceTaintSelector device(String device) {
        this.device = device;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.  Setting also driver and pool may be required to avoid ambiguity, but is not required.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public V1alpha3DeviceTaintSelector deviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If DeviceClassName is set, the selectors defined there must be satisfied by a device to be selected. This field corresponds to class.metadata.name.")
    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public void setDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }

    public V1alpha3DeviceTaintSelector driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1alpha3DeviceTaintSelector pool(String pool) {
        this.pool = pool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If pool is set, only devices in that pool are selected.  Also setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public V1alpha3DeviceTaintSelector selectors(List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1alpha3DeviceTaintSelector addSelectorsItem(V1alpha3DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1alpha3DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selectors contains the same selection criteria as a ResourceClaim. Currently, CEL expressions are supported. All of these selectors must be satisfied.")
    public List<V1alpha3DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3DeviceTaintSelector v1alpha3DeviceTaintSelector = (V1alpha3DeviceTaintSelector)o;
        return Objects.equals(this.device, v1alpha3DeviceTaintSelector.device) && Objects.equals(this.deviceClassName, v1alpha3DeviceTaintSelector.deviceClassName) && Objects.equals(this.driver, v1alpha3DeviceTaintSelector.driver) && Objects.equals(this.pool, v1alpha3DeviceTaintSelector.pool) && Objects.equals(this.selectors, v1alpha3DeviceTaintSelector.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.device, this.deviceClassName, this.driver, this.pool, this.selectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3DeviceTaintSelector {\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    deviceClassName: ").append(this.toIndentedString(this.deviceClassName)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

