/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelector;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelectorBuilder;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelectorFluent;
import io.kubernetes.client.openapi.models.V1alpha3DeviceTaintSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha3DeviceTaintSelectorFluent<A extends V1alpha3DeviceTaintSelectorFluent<A>>
extends BaseFluent<A> {
    private String device;
    private String deviceClassName;
    private String driver;
    private String pool;
    private ArrayList<V1alpha3DeviceSelectorBuilder> selectors;

    public V1alpha3DeviceTaintSelectorFluent() {
    }

    public V1alpha3DeviceTaintSelectorFluent(V1alpha3DeviceTaintSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha3DeviceTaintSelector instance) {
        V1alpha3DeviceTaintSelector v1alpha3DeviceTaintSelector = instance = instance != null ? instance : new V1alpha3DeviceTaintSelector();
        if (instance != null) {
            this.withDevice(instance.getDevice());
            this.withDeviceClassName(instance.getDeviceClassName());
            this.withDriver(instance.getDriver());
            this.withPool(instance.getPool());
            this.withSelectors(instance.getSelectors());
        }
    }

    public String getDevice() {
        return this.device;
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)this;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public A withDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return (A)this;
    }

    public boolean hasDeviceClassName() {
        return this.deviceClassName != null;
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getPool() {
        return this.pool;
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)this;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public A addToSelectors(int index, V1alpha3DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToSelectors(int index, V1alpha3DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToSelectors(V1alpha3DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToSelectors(Collection<V1alpha3DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromSelectors(V1alpha3DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSelectors(Collection<V1alpha3DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (V1alpha3DeviceSelector item : items) {
            V1alpha3DeviceSelectorBuilder builder = new V1alpha3DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<V1alpha3DeviceSelectorBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            V1alpha3DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha3DeviceSelector> buildSelectors() {
        return this.selectors != null ? V1alpha3DeviceTaintSelectorFluent.build(this.selectors) : null;
    }

    public V1alpha3DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public V1alpha3DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public V1alpha3DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public V1alpha3DeviceSelector buildMatchingSelector(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        for (V1alpha3DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSelector(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        for (V1alpha3DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSelectors(List<V1alpha3DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (V1alpha3DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(V1alpha3DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (V1alpha3DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(V1alpha3DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, V1alpha3DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException("Can't edit selectors. Index exceeds size.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException("Can't edit first selectors. The list is empty.");
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last selectors. The list is empty.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<V1alpha3DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching selectors. No match found.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha3DeviceTaintSelectorFluent that = (V1alpha3DeviceTaintSelectorFluent)o;
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.deviceClassName, that.deviceClassName)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        return Objects.equals(this.selectors, that.selectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.device, this.deviceClassName, this.driver, this.pool, this.selectors, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device + ",");
        }
        if (this.deviceClassName != null) {
            sb.append("deviceClassName:");
            sb.append(this.deviceClassName + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool + ",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorsNested<N>
    extends V1alpha3DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        V1alpha3DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, V1alpha3DeviceSelector item) {
            this.index = index;
            this.builder = new V1alpha3DeviceSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha3DeviceTaintSelectorFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

