/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1beta1DeviceAttribute;
import io.kubernetes.client.openapi.models.V1beta1DeviceCapacity;
import io.kubernetes.client.openapi.models.V1beta1DeviceCounterConsumption;
import io.kubernetes.client.openapi.models.V1beta1DeviceTaint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="BasicDevice defines one device instance.")
public class V1beta1BasicDevice {
    public static final String SERIALIZED_NAME_ALL_NODES = "allNodes";
    @SerializedName(value="allNodes")
    private Boolean allNodes;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, V1beta1DeviceAttribute> attributes = null;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, V1beta1DeviceCapacity> capacity = null;
    public static final String SERIALIZED_NAME_CONSUMES_COUNTERS = "consumesCounters";
    @SerializedName(value="consumesCounters")
    private List<V1beta1DeviceCounterConsumption> consumesCounters = null;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_TAINTS = "taints";
    @SerializedName(value="taints")
    private List<V1beta1DeviceTaint> taints = null;

    public V1beta1BasicDevice allNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllNodes indicates that all nodes have access to the device.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1beta1BasicDevice attributes(Map<String, V1beta1DeviceAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public V1beta1BasicDevice putAttributesItem(String key, V1beta1DeviceAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, V1beta1DeviceAttribute>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1beta1DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, V1beta1DeviceAttribute> attributes) {
        this.attributes = attributes;
    }

    public V1beta1BasicDevice capacity(Map<String, V1beta1DeviceCapacity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1beta1BasicDevice putCapacityItem(String key, V1beta1DeviceCapacity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, V1beta1DeviceCapacity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1beta1DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, V1beta1DeviceCapacity> capacity) {
        this.capacity = capacity;
    }

    public V1beta1BasicDevice consumesCounters(List<V1beta1DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
        return this;
    }

    public V1beta1BasicDevice addConsumesCountersItem(V1beta1DeviceCounterConsumption consumesCountersItem) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList<V1beta1DeviceCounterConsumption>();
        }
        this.consumesCounters.add(consumesCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.  There can only be a single entry per counterSet.  The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).")
    public List<V1beta1DeviceCounterConsumption> getConsumesCounters() {
        return this.consumesCounters;
    }

    public void setConsumesCounters(List<V1beta1DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
    }

    public V1beta1BasicDevice nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node where the device is available.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1beta1BasicDevice nodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1beta1BasicDevice taints(List<V1beta1DeviceTaint> taints) {
        this.taints = taints;
        return this;
    }

    public V1beta1BasicDevice addTaintsItem(V1beta1DeviceTaint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1beta1DeviceTaint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, these are the driver-defined taints.  The maximum number of taints is 4.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta1DeviceTaint> getTaints() {
        return this.taints;
    }

    public void setTaints(List<V1beta1DeviceTaint> taints) {
        this.taints = taints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1BasicDevice v1beta1BasicDevice = (V1beta1BasicDevice)o;
        return Objects.equals(this.allNodes, v1beta1BasicDevice.allNodes) && Objects.equals(this.attributes, v1beta1BasicDevice.attributes) && Objects.equals(this.capacity, v1beta1BasicDevice.capacity) && Objects.equals(this.consumesCounters, v1beta1BasicDevice.consumesCounters) && Objects.equals(this.nodeName, v1beta1BasicDevice.nodeName) && Objects.equals(this.nodeSelector, v1beta1BasicDevice.nodeSelector) && Objects.equals(this.taints, v1beta1BasicDevice.taints);
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.attributes, this.capacity, this.consumesCounters, this.nodeName, this.nodeSelector, this.taints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1BasicDevice {\n");
        sb.append("    allNodes: ").append(this.toIndentedString(this.allNodes)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    consumesCounters: ").append(this.toIndentedString(this.consumesCounters)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

