/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AggregationRule;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1AggregationRuleFluent<A extends V1AggregationRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1LabelSelectorBuilder> clusterRoleSelectors;

    public V1AggregationRuleFluent() {
    }

    public V1AggregationRuleFluent(V1AggregationRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1AggregationRule instance) {
        V1AggregationRule v1AggregationRule = instance = instance != null ? instance : new V1AggregationRule();
        if (instance != null) {
            this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        }
    }

    public A addToClusterRoleSelectors(int index, V1LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        } else {
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToClusterRoleSelectors(int index, V1LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        } else {
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToClusterRoleSelectors(V1LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToClusterRoleSelectors(Collection<V1LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromClusterRoleSelectors(V1LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            return (A)this;
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromClusterRoleSelectors(Collection<V1LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            return (A)this;
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromClusterRoleSelectors(Predicate<V1LabelSelectorBuilder> predicate) {
        if (this.clusterRoleSelectors == null) {
            return (A)this;
        }
        Iterator<V1LabelSelectorBuilder> each = this.clusterRoleSelectors.iterator();
        Object visitables = this._visitables.get("clusterRoleSelectors");
        while (each.hasNext()) {
            V1LabelSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1LabelSelector> buildClusterRoleSelectors() {
        return this.clusterRoleSelectors != null ? V1AggregationRuleFluent.build(this.clusterRoleSelectors) : null;
    }

    public V1LabelSelector buildClusterRoleSelector(int index) {
        return this.clusterRoleSelectors.get(index).build();
    }

    public V1LabelSelector buildFirstClusterRoleSelector() {
        return this.clusterRoleSelectors.get(0).build();
    }

    public V1LabelSelector buildLastClusterRoleSelector() {
        return this.clusterRoleSelectors.get(this.clusterRoleSelectors.size() - 1).build();
    }

    public V1LabelSelector buildMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        for (V1LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        for (V1LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterRoleSelectors(List<V1LabelSelector> clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this._visitables.get("clusterRoleSelectors").clear();
        }
        if (clusterRoleSelectors != null) {
            this.clusterRoleSelectors = new ArrayList();
            for (V1LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        } else {
            this.clusterRoleSelectors = null;
        }
        return (A)this;
    }

    public A withClusterRoleSelectors(V1LabelSelector ... clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this.clusterRoleSelectors.clear();
            this._visitables.remove("clusterRoleSelectors");
        }
        if (clusterRoleSelectors != null) {
            for (V1LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasClusterRoleSelectors() {
        return this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty();
    }

    public ClusterRoleSelectorsNested<A> addNewClusterRoleSelector() {
        return new ClusterRoleSelectorsNested(-1, null);
    }

    public ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(V1LabelSelector item) {
        return new ClusterRoleSelectorsNested(-1, item);
    }

    public ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index, V1LabelSelector item) {
        return new ClusterRoleSelectorsNested(index, item);
    }

    public ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index) {
        if (index <= this.clusterRoleSelectors.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "clusterRoleSelectors"));
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector() {
        if (this.clusterRoleSelectors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "clusterRoleSelectors"));
        }
        return this.setNewClusterRoleSelectorLike(0, this.buildClusterRoleSelector(0));
    }

    public ClusterRoleSelectorsNested<A> editLastClusterRoleSelector() {
        int index = this.clusterRoleSelectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "clusterRoleSelectors"));
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterRoleSelectors.size(); ++i) {
            if (!predicate.test(this.clusterRoleSelectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "clusterRoleSelectors"));
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1AggregationRuleFluent that = (V1AggregationRuleFluent)o;
        return Objects.equals(this.clusterRoleSelectors, that.clusterRoleSelectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterRoleSelectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty()) {
            sb.append("clusterRoleSelectors:");
            sb.append(this.clusterRoleSelectors);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterRoleSelectorsNested<N>
    extends V1LabelSelectorFluent<ClusterRoleSelectorsNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;
        int index;

        ClusterRoleSelectorsNested(int index, V1LabelSelector item) {
            this.index = index;
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1AggregationRuleFluent.this.setToClusterRoleSelectors(this.index, this.builder.build());
        }

        public N endClusterRoleSelector() {
            return this.and();
        }
    }
}

