/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AppArmorProfile defines a pod or container's AppArmor settings.")
public class V1AppArmorProfile {
    public static final String SERIALIZED_NAME_LOCALHOST_PROFILE = "localhostProfile";
    @SerializedName(value="localhostProfile")
    private String localhostProfile;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1AppArmorProfile localhostProfile(String localhostProfile) {
        this.localhostProfile = localhostProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is \"Localhost\".")
    public String getLocalhostProfile() {
        return this.localhostProfile;
    }

    public void setLocalhostProfile(String localhostProfile) {
        this.localhostProfile = localhostProfile;
    }

    public V1AppArmorProfile type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type indicates which kind of AppArmor profile will be applied. Valid options are:   Localhost - a profile pre-loaded on the node.   RuntimeDefault - the container runtime's default profile.   Unconfined - no AppArmor enforcement.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AppArmorProfile v1AppArmorProfile = (V1AppArmorProfile)o;
        return Objects.equals(this.localhostProfile, v1AppArmorProfile.localhostProfile) && Objects.equals(this.type, v1AppArmorProfile.type);
    }

    public int hashCode() {
        return Objects.hash(this.localhostProfile, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AppArmorProfile {\n");
        sb.append("    localhostProfile: ").append(this.toIndentedString(this.localhostProfile)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

