/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CSIStorageCapacity;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import java.util.Objects;
import java.util.Optional;

public class V1CSIStorageCapacityFluent<A extends V1CSIStorageCapacityFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Quantity capacity;
    private String kind;
    private Quantity maximumVolumeSize;
    private V1ObjectMetaBuilder metadata;
    private V1LabelSelectorBuilder nodeTopology;
    private String storageClassName;

    public V1CSIStorageCapacityFluent() {
    }

    public V1CSIStorageCapacityFluent(V1CSIStorageCapacity instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CSIStorageCapacity instance) {
        V1CSIStorageCapacity v1CSIStorageCapacity = instance = instance != null ? instance : new V1CSIStorageCapacity();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCapacity(instance.getCapacity());
            this.withKind(instance.getKind());
            this.withMaximumVolumeSize(instance.getMaximumVolumeSize());
            this.withMetadata(instance.getMetadata());
            this.withNodeTopology(instance.getNodeTopology());
            this.withStorageClassName(instance.getStorageClassName());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Quantity getCapacity() {
        return this.capacity;
    }

    public A withCapacity(Quantity capacity) {
        this.capacity = capacity;
        return (A)this;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public A withNewCapacity(String value) {
        return this.withCapacity(new Quantity(value));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Quantity getMaximumVolumeSize() {
        return this.maximumVolumeSize;
    }

    public A withMaximumVolumeSize(Quantity maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
        return (A)this;
    }

    public boolean hasMaximumVolumeSize() {
        return this.maximumVolumeSize != null;
    }

    public A withNewMaximumVolumeSize(String value) {
        return this.withMaximumVolumeSize(new Quantity(value));
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1LabelSelector buildNodeTopology() {
        return this.nodeTopology != null ? this.nodeTopology.build() : null;
    }

    public A withNodeTopology(V1LabelSelector nodeTopology) {
        this._visitables.remove("nodeTopology");
        if (nodeTopology != null) {
            this.nodeTopology = new V1LabelSelectorBuilder(nodeTopology);
            this._visitables.get("nodeTopology").add(this.nodeTopology);
        } else {
            this.nodeTopology = null;
            this._visitables.get("nodeTopology").remove(this.nodeTopology);
        }
        return (A)this;
    }

    public boolean hasNodeTopology() {
        return this.nodeTopology != null;
    }

    public NodeTopologyNested<A> withNewNodeTopology() {
        return new NodeTopologyNested(null);
    }

    public NodeTopologyNested<A> withNewNodeTopologyLike(V1LabelSelector item) {
        return new NodeTopologyNested(item);
    }

    public NodeTopologyNested<A> editNodeTopology() {
        return this.withNewNodeTopologyLike(Optional.ofNullable(this.buildNodeTopology()).orElse(null));
    }

    public NodeTopologyNested<A> editOrNewNodeTopology() {
        return this.withNewNodeTopologyLike(Optional.ofNullable(this.buildNodeTopology()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public NodeTopologyNested<A> editOrNewNodeTopologyLike(V1LabelSelector item) {
        return this.withNewNodeTopologyLike(Optional.ofNullable(this.buildNodeTopology()).orElse(item));
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)this;
    }

    public boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CSIStorageCapacityFluent that = (V1CSIStorageCapacityFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.maximumVolumeSize, that.maximumVolumeSize)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.nodeTopology, that.nodeTopology)) {
            return false;
        }
        return Objects.equals(this.storageClassName, that.storageClassName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.capacity, this.kind, this.maximumVolumeSize, this.metadata, this.nodeTopology, this.storageClassName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.capacity != null) {
            sb.append("capacity:");
            sb.append(this.capacity);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.maximumVolumeSize != null) {
            sb.append("maximumVolumeSize:");
            sb.append(this.maximumVolumeSize);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.nodeTopology != null) {
            sb.append("nodeTopology:");
            sb.append(this.nodeTopology);
            sb.append(",");
        }
        if (this.storageClassName != null) {
            sb.append("storageClassName:");
            sb.append(this.storageClassName);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CSIStorageCapacityFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class NodeTopologyNested<N>
    extends V1LabelSelectorFluent<NodeTopologyNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        NodeTopologyNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CSIStorageCapacityFluent.this.withNodeTopology(this.builder.build());
        }

        public N endNodeTopology() {
            return this.and();
        }
    }
}

