/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestCondition;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestConditionBuilder;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestConditionFluent;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CertificateSigningRequestStatusFluent<A extends V1CertificateSigningRequestStatusFluent<A>>
extends BaseFluent<A> {
    private List<Byte> certificate;
    private ArrayList<V1CertificateSigningRequestConditionBuilder> conditions;

    public V1CertificateSigningRequestStatusFluent() {
    }

    public V1CertificateSigningRequestStatusFluent(V1CertificateSigningRequestStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CertificateSigningRequestStatus instance) {
        V1CertificateSigningRequestStatus v1CertificateSigningRequestStatus = instance = instance != null ? instance : new V1CertificateSigningRequestStatus();
        if (instance != null) {
            this.withCertificate(instance.getCertificate());
            this.withConditions(instance.getConditions());
        }
    }

    public A withCertificate(byte ... certificate) {
        if (this.certificate != null) {
            this.certificate.clear();
            this._visitables.remove("certificate");
        }
        if (certificate != null) {
            for (byte item : certificate) {
                this.addToCertificate(item);
            }
        }
        return (A)this;
    }

    public byte[] getCertificate() {
        int size = this.certificate != null ? this.certificate.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.certificate) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCertificate(int index, Byte item) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        this.certificate.add(index, item);
        return (A)this;
    }

    public A setToCertificate(int index, Byte item) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        this.certificate.set(index, item);
        return (A)this;
    }

    public A addToCertificate(Byte ... items) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    public A addAllToCertificate(Collection<Byte> items) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    public A removeFromCertificate(Byte ... items) {
        if (this.certificate == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.certificate.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCertificate(Collection<Byte> items) {
        if (this.certificate == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.certificate.remove(item);
        }
        return (A)this;
    }

    public boolean hasCertificate() {
        return this.certificate != null && !this.certificate.isEmpty();
    }

    public A addToConditions(int index, V1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1CertificateSigningRequestCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1CertificateSigningRequestCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1CertificateSigningRequestConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1CertificateSigningRequestConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1CertificateSigningRequestCondition> buildConditions() {
        return this.conditions != null ? V1CertificateSigningRequestStatusFluent.build(this.conditions) : null;
    }

    public V1CertificateSigningRequestCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1CertificateSigningRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1CertificateSigningRequestCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1CertificateSigningRequestCondition buildMatchingCondition(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1CertificateSigningRequestCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1CertificateSigningRequestCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1CertificateSigningRequestCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1CertificateSigningRequestCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (index <= this.conditions.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CertificateSigningRequestStatusFluent that = (V1CertificateSigningRequestStatusFluent)o;
        if (!Objects.equals(this.certificate, that.certificate)) {
            return false;
        }
        return Objects.equals(this.conditions, that.conditions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.certificate, this.conditions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificate != null && !this.certificate.isEmpty()) {
            sb.append("certificate:");
            sb.append(this.certificate);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1CertificateSigningRequestConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1CertificateSigningRequestConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1CertificateSigningRequestCondition item) {
            this.index = index;
            this.builder = new V1CertificateSigningRequestConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CertificateSigningRequestStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

