/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CustomResourceConversion;
import io.kubernetes.client.openapi.models.V1WebhookConversion;
import io.kubernetes.client.openapi.models.V1WebhookConversionBuilder;
import io.kubernetes.client.openapi.models.V1WebhookConversionFluent;
import java.util.Objects;
import java.util.Optional;

public class V1CustomResourceConversionFluent<A extends V1CustomResourceConversionFluent<A>>
extends BaseFluent<A> {
    private String strategy;
    private V1WebhookConversionBuilder webhook;

    public V1CustomResourceConversionFluent() {
    }

    public V1CustomResourceConversionFluent(V1CustomResourceConversion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CustomResourceConversion instance) {
        V1CustomResourceConversion v1CustomResourceConversion = instance = instance != null ? instance : new V1CustomResourceConversion();
        if (instance != null) {
            this.withStrategy(instance.getStrategy());
            this.withWebhook(instance.getWebhook());
        }
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public V1WebhookConversion buildWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    public A withWebhook(V1WebhookConversion webhook) {
        this._visitables.remove("webhook");
        if (webhook != null) {
            this.webhook = new V1WebhookConversionBuilder(webhook);
            this._visitables.get("webhook").add(this.webhook);
        } else {
            this.webhook = null;
            this._visitables.get("webhook").remove(this.webhook);
        }
        return (A)this;
    }

    public boolean hasWebhook() {
        return this.webhook != null;
    }

    public WebhookNested<A> withNewWebhook() {
        return new WebhookNested(null);
    }

    public WebhookNested<A> withNewWebhookLike(V1WebhookConversion item) {
        return new WebhookNested(item);
    }

    public WebhookNested<A> editWebhook() {
        return this.withNewWebhookLike(Optional.ofNullable(this.buildWebhook()).orElse(null));
    }

    public WebhookNested<A> editOrNewWebhook() {
        return this.withNewWebhookLike(Optional.ofNullable(this.buildWebhook()).orElse(new V1WebhookConversionBuilder().build()));
    }

    public WebhookNested<A> editOrNewWebhookLike(V1WebhookConversion item) {
        return this.withNewWebhookLike(Optional.ofNullable(this.buildWebhook()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CustomResourceConversionFluent that = (V1CustomResourceConversionFluent)o;
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        return Objects.equals(this.webhook, that.webhook);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.strategy, this.webhook);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy);
            sb.append(",");
        }
        if (this.webhook != null) {
            sb.append("webhook:");
            sb.append(this.webhook);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WebhookNested<N>
    extends V1WebhookConversionFluent<WebhookNested<N>>
    implements Nested<N> {
        V1WebhookConversionBuilder builder;

        WebhookNested(V1WebhookConversion item) {
            this.builder = new V1WebhookConversionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceConversionFluent.this.withWebhook(this.builder.build());
        }

        public N endWebhook() {
            return this.and();
        }
    }
}

