/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CustomResourceValidation;
import io.kubernetes.client.openapi.models.V1JSONSchemaProps;
import io.kubernetes.client.openapi.models.V1JSONSchemaPropsBuilder;
import io.kubernetes.client.openapi.models.V1JSONSchemaPropsFluent;
import java.util.Objects;
import java.util.Optional;

public class V1CustomResourceValidationFluent<A extends V1CustomResourceValidationFluent<A>>
extends BaseFluent<A> {
    private V1JSONSchemaPropsBuilder openAPIV3Schema;

    public V1CustomResourceValidationFluent() {
    }

    public V1CustomResourceValidationFluent(V1CustomResourceValidation instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CustomResourceValidation instance) {
        V1CustomResourceValidation v1CustomResourceValidation = instance = instance != null ? instance : new V1CustomResourceValidation();
        if (instance != null) {
            this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        }
    }

    public V1JSONSchemaProps buildOpenAPIV3Schema() {
        return this.openAPIV3Schema != null ? this.openAPIV3Schema.build() : null;
    }

    public A withOpenAPIV3Schema(V1JSONSchemaProps openAPIV3Schema) {
        this._visitables.remove("openAPIV3Schema");
        if (openAPIV3Schema != null) {
            this.openAPIV3Schema = new V1JSONSchemaPropsBuilder(openAPIV3Schema);
            this._visitables.get("openAPIV3Schema").add(this.openAPIV3Schema);
        } else {
            this.openAPIV3Schema = null;
            this._visitables.get("openAPIV3Schema").remove(this.openAPIV3Schema);
        }
        return (A)this;
    }

    public boolean hasOpenAPIV3Schema() {
        return this.openAPIV3Schema != null;
    }

    public OpenAPIV3SchemaNested<A> withNewOpenAPIV3Schema() {
        return new OpenAPIV3SchemaNested(null);
    }

    public OpenAPIV3SchemaNested<A> withNewOpenAPIV3SchemaLike(V1JSONSchemaProps item) {
        return new OpenAPIV3SchemaNested(item);
    }

    public OpenAPIV3SchemaNested<A> editOpenAPIV3Schema() {
        return this.withNewOpenAPIV3SchemaLike(Optional.ofNullable(this.buildOpenAPIV3Schema()).orElse(null));
    }

    public OpenAPIV3SchemaNested<A> editOrNewOpenAPIV3Schema() {
        return this.withNewOpenAPIV3SchemaLike(Optional.ofNullable(this.buildOpenAPIV3Schema()).orElse(new V1JSONSchemaPropsBuilder().build()));
    }

    public OpenAPIV3SchemaNested<A> editOrNewOpenAPIV3SchemaLike(V1JSONSchemaProps item) {
        return this.withNewOpenAPIV3SchemaLike(Optional.ofNullable(this.buildOpenAPIV3Schema()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CustomResourceValidationFluent that = (V1CustomResourceValidationFluent)o;
        return Objects.equals(this.openAPIV3Schema, that.openAPIV3Schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.openAPIV3Schema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.openAPIV3Schema != null) {
            sb.append("openAPIV3Schema:");
            sb.append(this.openAPIV3Schema);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OpenAPIV3SchemaNested<N>
    extends V1JSONSchemaPropsFluent<OpenAPIV3SchemaNested<N>>
    implements Nested<N> {
        V1JSONSchemaPropsBuilder builder;

        OpenAPIV3SchemaNested(V1JSONSchemaProps item) {
            this.builder = new V1JSONSchemaPropsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceValidationFluent.this.withOpenAPIV3Schema(this.builder.build());
        }

        public N endOpenAPIV3Schema() {
            return this.and();
        }
    }
}

