/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1DeviceAttribute;
import io.kubernetes.client.openapi.models.V1DeviceCapacity;
import io.kubernetes.client.openapi.models.V1DeviceCounterConsumption;
import io.kubernetes.client.openapi.models.V1DeviceTaint;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.")
public class V1Device {
    public static final String SERIALIZED_NAME_ALL_NODES = "allNodes";
    @SerializedName(value="allNodes")
    private Boolean allNodes;
    public static final String SERIALIZED_NAME_ALLOW_MULTIPLE_ALLOCATIONS = "allowMultipleAllocations";
    @SerializedName(value="allowMultipleAllocations")
    private Boolean allowMultipleAllocations;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, V1DeviceAttribute> attributes = null;
    public static final String SERIALIZED_NAME_BINDING_CONDITIONS = "bindingConditions";
    @SerializedName(value="bindingConditions")
    private List<String> bindingConditions = null;
    public static final String SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS = "bindingFailureConditions";
    @SerializedName(value="bindingFailureConditions")
    private List<String> bindingFailureConditions = null;
    public static final String SERIALIZED_NAME_BINDS_TO_NODE = "bindsToNode";
    @SerializedName(value="bindsToNode")
    private Boolean bindsToNode;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, V1DeviceCapacity> capacity = null;
    public static final String SERIALIZED_NAME_CONSUMES_COUNTERS = "consumesCounters";
    @SerializedName(value="consumesCounters")
    private List<V1DeviceCounterConsumption> consumesCounters = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_TAINTS = "taints";
    @SerializedName(value="taints")
    private List<V1DeviceTaint> taints = null;

    public V1Device allNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllNodes indicates that all nodes have access to the device.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1Device allowMultipleAllocations(Boolean allowMultipleAllocations) {
        this.allowMultipleAllocations = allowMultipleAllocations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllowMultipleAllocations marks whether the device is allowed to be allocated to multiple DeviceRequests.  If AllowMultipleAllocations is set to true, the device can be allocated more than once, and all of its capacity is consumable, regardless of whether the requestPolicy is defined or not.")
    public Boolean getAllowMultipleAllocations() {
        return this.allowMultipleAllocations;
    }

    public void setAllowMultipleAllocations(Boolean allowMultipleAllocations) {
        this.allowMultipleAllocations = allowMultipleAllocations;
    }

    public V1Device attributes(Map<String, V1DeviceAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public V1Device putAttributesItem(String key, V1DeviceAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, V1DeviceAttribute>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, V1DeviceAttribute> attributes) {
        this.attributes = attributes;
    }

    public V1Device bindingConditions(List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
        return this;
    }

    public V1Device addBindingConditionsItem(String bindingConditionsItem) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.add(bindingConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingConditions defines the conditions for proceeding with binding. All of these conditions must be set in the per-device status conditions with a value of True to proceed with binding the pod to the node while scheduling the pod.  The maximum number of binding conditions is 4.  The conditions must be a valid condition type string.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingConditions() {
        return this.bindingConditions;
    }

    public void setBindingConditions(List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
    }

    public V1Device bindingFailureConditions(List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
        return this;
    }

    public V1Device addBindingFailureConditionsItem(String bindingFailureConditionsItem) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.add(bindingFailureConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingFailureConditions defines the conditions for binding failure. They may be set in the per-device status conditions. If any is set to \"True\", a binding failure occurred.  The maximum number of binding failure conditions is 4.  The conditions must be a valid condition type string.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingFailureConditions() {
        return this.bindingFailureConditions;
    }

    public void setBindingFailureConditions(List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
    }

    public V1Device bindsToNode(Boolean bindsToNode) {
        this.bindsToNode = bindsToNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindsToNode indicates if the usage of an allocation involving this device has to be limited to exactly the node that was chosen when allocating the claim. If set to true, the scheduler will set the ResourceClaim.Status.Allocation.NodeSelector to match the node where the allocation was made.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public Boolean getBindsToNode() {
        return this.bindsToNode;
    }

    public void setBindsToNode(Boolean bindsToNode) {
        this.bindsToNode = bindsToNode;
    }

    public V1Device capacity(Map<String, V1DeviceCapacity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1Device putCapacityItem(String key, V1DeviceCapacity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, V1DeviceCapacity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, V1DeviceCapacity> capacity) {
        this.capacity = capacity;
    }

    public V1Device consumesCounters(List<V1DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
        return this;
    }

    public V1Device addConsumesCountersItem(V1DeviceCounterConsumption consumesCountersItem) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList<V1DeviceCounterConsumption>();
        }
        this.consumesCounters.add(consumesCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.  There can only be a single entry per counterSet.  The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).")
    public List<V1DeviceCounterConsumption> getConsumesCounters() {
        return this.consumesCounters;
    }

    public void setConsumesCounters(List<V1DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
    }

    public V1Device name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Device nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node where the device is available.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1Device nodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1Device taints(List<V1DeviceTaint> taints) {
        this.taints = taints;
        return this;
    }

    public V1Device addTaintsItem(V1DeviceTaint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1DeviceTaint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, these are the driver-defined taints.  The maximum number of taints is 4.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1DeviceTaint> getTaints() {
        return this.taints;
    }

    public void setTaints(List<V1DeviceTaint> taints) {
        this.taints = taints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Device v1Device = (V1Device)o;
        return Objects.equals(this.allNodes, v1Device.allNodes) && Objects.equals(this.allowMultipleAllocations, v1Device.allowMultipleAllocations) && Objects.equals(this.attributes, v1Device.attributes) && Objects.equals(this.bindingConditions, v1Device.bindingConditions) && Objects.equals(this.bindingFailureConditions, v1Device.bindingFailureConditions) && Objects.equals(this.bindsToNode, v1Device.bindsToNode) && Objects.equals(this.capacity, v1Device.capacity) && Objects.equals(this.consumesCounters, v1Device.consumesCounters) && Objects.equals(this.name, v1Device.name) && Objects.equals(this.nodeName, v1Device.nodeName) && Objects.equals(this.nodeSelector, v1Device.nodeSelector) && Objects.equals(this.taints, v1Device.taints);
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.allowMultipleAllocations, this.attributes, this.bindingConditions, this.bindingFailureConditions, this.bindsToNode, this.capacity, this.consumesCounters, this.name, this.nodeName, this.nodeSelector, this.taints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Device {\n");
        sb.append("    allNodes: ").append(this.toIndentedString(this.allNodes)).append("\n");
        sb.append("    allowMultipleAllocations: ").append(this.toIndentedString(this.allowMultipleAllocations)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    bindingConditions: ").append(this.toIndentedString(this.bindingConditions)).append("\n");
        sb.append("    bindingFailureConditions: ").append(this.toIndentedString(this.bindingFailureConditions)).append("\n");
        sb.append("    bindsToNode: ").append(this.toIndentedString(this.bindsToNode)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    consumesCounters: ").append(this.toIndentedString(this.consumesCounters)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

