/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeviceClassConfiguration;
import io.kubernetes.client.openapi.models.V1DeviceClassConfigurationBuilder;
import io.kubernetes.client.openapi.models.V1DeviceClassConfigurationFluent;
import io.kubernetes.client.openapi.models.V1DeviceClassSpec;
import io.kubernetes.client.openapi.models.V1DeviceSelector;
import io.kubernetes.client.openapi.models.V1DeviceSelectorBuilder;
import io.kubernetes.client.openapi.models.V1DeviceSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1DeviceClassSpecFluent<A extends V1DeviceClassSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1DeviceClassConfigurationBuilder> config;
    private String extendedResourceName;
    private ArrayList<V1DeviceSelectorBuilder> selectors;

    public V1DeviceClassSpecFluent() {
    }

    public V1DeviceClassSpecFluent(V1DeviceClassSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1DeviceClassSpec instance) {
        V1DeviceClassSpec v1DeviceClassSpec = instance = instance != null ? instance : new V1DeviceClassSpec();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withExtendedResourceName(instance.getExtendedResourceName());
            this.withSelectors(instance.getSelectors());
        }
    }

    public A addToConfig(int index, V1DeviceClassConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        V1DeviceClassConfigurationBuilder builder = new V1DeviceClassConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get("config").add(builder);
            this.config.add(index, builder);
        }
        return (A)this;
    }

    public A setToConfig(int index, V1DeviceClassConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        V1DeviceClassConfigurationBuilder builder = new V1DeviceClassConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get("config").add(builder);
            this.config.set(index, builder);
        }
        return (A)this;
    }

    public A addToConfig(V1DeviceClassConfiguration ... items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (V1DeviceClassConfiguration item : items) {
            V1DeviceClassConfigurationBuilder builder = new V1DeviceClassConfigurationBuilder(item);
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        }
        return (A)this;
    }

    public A addAllToConfig(Collection<V1DeviceClassConfiguration> items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (V1DeviceClassConfiguration item : items) {
            V1DeviceClassConfigurationBuilder builder = new V1DeviceClassConfigurationBuilder(item);
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        }
        return (A)this;
    }

    public A removeFromConfig(V1DeviceClassConfiguration ... items) {
        if (this.config == null) {
            return (A)this;
        }
        for (V1DeviceClassConfiguration item : items) {
            V1DeviceClassConfigurationBuilder builder = new V1DeviceClassConfigurationBuilder(item);
            this._visitables.get("config").remove(builder);
            this.config.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConfig(Collection<V1DeviceClassConfiguration> items) {
        if (this.config == null) {
            return (A)this;
        }
        for (V1DeviceClassConfiguration item : items) {
            V1DeviceClassConfigurationBuilder builder = new V1DeviceClassConfigurationBuilder(item);
            this._visitables.get("config").remove(builder);
            this.config.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConfig(Predicate<V1DeviceClassConfigurationBuilder> predicate) {
        if (this.config == null) {
            return (A)this;
        }
        Iterator<V1DeviceClassConfigurationBuilder> each = this.config.iterator();
        Object visitables = this._visitables.get("config");
        while (each.hasNext()) {
            V1DeviceClassConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1DeviceClassConfiguration> buildConfig() {
        return this.config != null ? V1DeviceClassSpecFluent.build(this.config) : null;
    }

    public V1DeviceClassConfiguration buildConfig(int index) {
        return this.config.get(index).build();
    }

    public V1DeviceClassConfiguration buildFirstConfig() {
        return this.config.get(0).build();
    }

    public V1DeviceClassConfiguration buildLastConfig() {
        return this.config.get(this.config.size() - 1).build();
    }

    public V1DeviceClassConfiguration buildMatchingConfig(Predicate<V1DeviceClassConfigurationBuilder> predicate) {
        for (V1DeviceClassConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfig(Predicate<V1DeviceClassConfigurationBuilder> predicate) {
        for (V1DeviceClassConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfig(List<V1DeviceClassConfiguration> config) {
        if (this.config != null) {
            this._visitables.get("config").clear();
        }
        if (config != null) {
            this.config = new ArrayList();
            for (V1DeviceClassConfiguration item : config) {
                this.addToConfig(item);
            }
        } else {
            this.config = null;
        }
        return (A)this;
    }

    public A withConfig(V1DeviceClassConfiguration ... config) {
        if (this.config != null) {
            this.config.clear();
            this._visitables.remove("config");
        }
        if (config != null) {
            for (V1DeviceClassConfiguration item : config) {
                this.addToConfig(item);
            }
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null && !this.config.isEmpty();
    }

    public ConfigNested<A> addNewConfig() {
        return new ConfigNested(-1, null);
    }

    public ConfigNested<A> addNewConfigLike(V1DeviceClassConfiguration item) {
        return new ConfigNested(-1, item);
    }

    public ConfigNested<A> setNewConfigLike(int index, V1DeviceClassConfiguration item) {
        return new ConfigNested(index, item);
    }

    public ConfigNested<A> editConfig(int index) {
        if (index <= this.config.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "config"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editFirstConfig() {
        if (this.config.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "config"));
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    public ConfigNested<A> editLastConfig() {
        int index = this.config.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "config"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editMatchingConfig(Predicate<V1DeviceClassConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.config.size(); ++i) {
            if (!predicate.test(this.config.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "config"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public String getExtendedResourceName() {
        return this.extendedResourceName;
    }

    public A withExtendedResourceName(String extendedResourceName) {
        this.extendedResourceName = extendedResourceName;
        return (A)this;
    }

    public boolean hasExtendedResourceName() {
        return this.extendedResourceName != null;
    }

    public A addToSelectors(int index, V1DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        V1DeviceSelectorBuilder builder = new V1DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToSelectors(int index, V1DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        V1DeviceSelectorBuilder builder = new V1DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToSelectors(V1DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (V1DeviceSelector item : items) {
            V1DeviceSelectorBuilder builder = new V1DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToSelectors(Collection<V1DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (V1DeviceSelector item : items) {
            V1DeviceSelectorBuilder builder = new V1DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromSelectors(V1DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (V1DeviceSelector item : items) {
            V1DeviceSelectorBuilder builder = new V1DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSelectors(Collection<V1DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (V1DeviceSelector item : items) {
            V1DeviceSelectorBuilder builder = new V1DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<V1DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<V1DeviceSelectorBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            V1DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1DeviceSelector> buildSelectors() {
        return this.selectors != null ? V1DeviceClassSpecFluent.build(this.selectors) : null;
    }

    public V1DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public V1DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public V1DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public V1DeviceSelector buildMatchingSelector(Predicate<V1DeviceSelectorBuilder> predicate) {
        for (V1DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSelector(Predicate<V1DeviceSelectorBuilder> predicate) {
        for (V1DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSelectors(List<V1DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (V1DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(V1DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (V1DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(V1DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, V1DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public SelectorsNested<A> editSelector(int index) {
        if (index <= this.selectors.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "selectors"));
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<V1DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeviceClassSpecFluent that = (V1DeviceClassSpecFluent)o;
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.extendedResourceName, that.extendedResourceName)) {
            return false;
        }
        return Objects.equals(this.selectors, that.selectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.config, this.extendedResourceName, this.selectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config);
            sb.append(",");
        }
        if (this.extendedResourceName != null) {
            sb.append("extendedResourceName:");
            sb.append(this.extendedResourceName);
            sb.append(",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigNested<N>
    extends V1DeviceClassConfigurationFluent<ConfigNested<N>>
    implements Nested<N> {
        V1DeviceClassConfigurationBuilder builder;
        int index;

        ConfigNested(int index, V1DeviceClassConfiguration item) {
            this.index = index;
            this.builder = new V1DeviceClassConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeviceClassSpecFluent.this.setToConfig(this.index, this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }

    public class SelectorsNested<N>
    extends V1DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        V1DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, V1DeviceSelector item) {
            this.index = index;
            this.builder = new V1DeviceSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeviceClassSpecFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

