/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeviceRequest;
import io.kubernetes.client.openapi.models.V1DeviceSubRequest;
import io.kubernetes.client.openapi.models.V1DeviceSubRequestBuilder;
import io.kubernetes.client.openapi.models.V1DeviceSubRequestFluent;
import io.kubernetes.client.openapi.models.V1ExactDeviceRequest;
import io.kubernetes.client.openapi.models.V1ExactDeviceRequestBuilder;
import io.kubernetes.client.openapi.models.V1ExactDeviceRequestFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1DeviceRequestFluent<A extends V1DeviceRequestFluent<A>>
extends BaseFluent<A> {
    private V1ExactDeviceRequestBuilder exactly;
    private ArrayList<V1DeviceSubRequestBuilder> firstAvailable;
    private String name;

    public V1DeviceRequestFluent() {
    }

    public V1DeviceRequestFluent(V1DeviceRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1DeviceRequest instance) {
        V1DeviceRequest v1DeviceRequest = instance = instance != null ? instance : new V1DeviceRequest();
        if (instance != null) {
            this.withExactly(instance.getExactly());
            this.withFirstAvailable(instance.getFirstAvailable());
            this.withName(instance.getName());
        }
    }

    public V1ExactDeviceRequest buildExactly() {
        return this.exactly != null ? this.exactly.build() : null;
    }

    public A withExactly(V1ExactDeviceRequest exactly) {
        this._visitables.remove("exactly");
        if (exactly != null) {
            this.exactly = new V1ExactDeviceRequestBuilder(exactly);
            this._visitables.get("exactly").add(this.exactly);
        } else {
            this.exactly = null;
            this._visitables.get("exactly").remove(this.exactly);
        }
        return (A)this;
    }

    public boolean hasExactly() {
        return this.exactly != null;
    }

    public ExactlyNested<A> withNewExactly() {
        return new ExactlyNested(null);
    }

    public ExactlyNested<A> withNewExactlyLike(V1ExactDeviceRequest item) {
        return new ExactlyNested(item);
    }

    public ExactlyNested<A> editExactly() {
        return this.withNewExactlyLike(Optional.ofNullable(this.buildExactly()).orElse(null));
    }

    public ExactlyNested<A> editOrNewExactly() {
        return this.withNewExactlyLike(Optional.ofNullable(this.buildExactly()).orElse(new V1ExactDeviceRequestBuilder().build()));
    }

    public ExactlyNested<A> editOrNewExactlyLike(V1ExactDeviceRequest item) {
        return this.withNewExactlyLike(Optional.ofNullable(this.buildExactly()).orElse(item));
    }

    public A addToFirstAvailable(int index, V1DeviceSubRequest item) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList();
        }
        V1DeviceSubRequestBuilder builder = new V1DeviceSubRequestBuilder(item);
        if (index < 0 || index >= this.firstAvailable.size()) {
            this._visitables.get("firstAvailable").add(builder);
            this.firstAvailable.add(builder);
        } else {
            this._visitables.get("firstAvailable").add(builder);
            this.firstAvailable.add(index, builder);
        }
        return (A)this;
    }

    public A setToFirstAvailable(int index, V1DeviceSubRequest item) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList();
        }
        V1DeviceSubRequestBuilder builder = new V1DeviceSubRequestBuilder(item);
        if (index < 0 || index >= this.firstAvailable.size()) {
            this._visitables.get("firstAvailable").add(builder);
            this.firstAvailable.add(builder);
        } else {
            this._visitables.get("firstAvailable").add(builder);
            this.firstAvailable.set(index, builder);
        }
        return (A)this;
    }

    public A addToFirstAvailable(V1DeviceSubRequest ... items) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList();
        }
        for (V1DeviceSubRequest item : items) {
            V1DeviceSubRequestBuilder builder = new V1DeviceSubRequestBuilder(item);
            this._visitables.get("firstAvailable").add(builder);
            this.firstAvailable.add(builder);
        }
        return (A)this;
    }

    public A addAllToFirstAvailable(Collection<V1DeviceSubRequest> items) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList();
        }
        for (V1DeviceSubRequest item : items) {
            V1DeviceSubRequestBuilder builder = new V1DeviceSubRequestBuilder(item);
            this._visitables.get("firstAvailable").add(builder);
            this.firstAvailable.add(builder);
        }
        return (A)this;
    }

    public A removeFromFirstAvailable(V1DeviceSubRequest ... items) {
        if (this.firstAvailable == null) {
            return (A)this;
        }
        for (V1DeviceSubRequest item : items) {
            V1DeviceSubRequestBuilder builder = new V1DeviceSubRequestBuilder(item);
            this._visitables.get("firstAvailable").remove(builder);
            this.firstAvailable.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFirstAvailable(Collection<V1DeviceSubRequest> items) {
        if (this.firstAvailable == null) {
            return (A)this;
        }
        for (V1DeviceSubRequest item : items) {
            V1DeviceSubRequestBuilder builder = new V1DeviceSubRequestBuilder(item);
            this._visitables.get("firstAvailable").remove(builder);
            this.firstAvailable.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFirstAvailable(Predicate<V1DeviceSubRequestBuilder> predicate) {
        if (this.firstAvailable == null) {
            return (A)this;
        }
        Iterator<V1DeviceSubRequestBuilder> each = this.firstAvailable.iterator();
        Object visitables = this._visitables.get("firstAvailable");
        while (each.hasNext()) {
            V1DeviceSubRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1DeviceSubRequest> buildFirstAvailable() {
        return this.firstAvailable != null ? V1DeviceRequestFluent.build(this.firstAvailable) : null;
    }

    public V1DeviceSubRequest buildFirstAvailable(int index) {
        return this.firstAvailable.get(index).build();
    }

    public V1DeviceSubRequest buildFirstFirstAvailable() {
        return this.firstAvailable.get(0).build();
    }

    public V1DeviceSubRequest buildLastFirstAvailable() {
        return this.firstAvailable.get(this.firstAvailable.size() - 1).build();
    }

    public V1DeviceSubRequest buildMatchingFirstAvailable(Predicate<V1DeviceSubRequestBuilder> predicate) {
        for (V1DeviceSubRequestBuilder item : this.firstAvailable) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFirstAvailable(Predicate<V1DeviceSubRequestBuilder> predicate) {
        for (V1DeviceSubRequestBuilder item : this.firstAvailable) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFirstAvailable(List<V1DeviceSubRequest> firstAvailable) {
        if (this.firstAvailable != null) {
            this._visitables.get("firstAvailable").clear();
        }
        if (firstAvailable != null) {
            this.firstAvailable = new ArrayList();
            for (V1DeviceSubRequest item : firstAvailable) {
                this.addToFirstAvailable(item);
            }
        } else {
            this.firstAvailable = null;
        }
        return (A)this;
    }

    public A withFirstAvailable(V1DeviceSubRequest ... firstAvailable) {
        if (this.firstAvailable != null) {
            this.firstAvailable.clear();
            this._visitables.remove("firstAvailable");
        }
        if (firstAvailable != null) {
            for (V1DeviceSubRequest item : firstAvailable) {
                this.addToFirstAvailable(item);
            }
        }
        return (A)this;
    }

    public boolean hasFirstAvailable() {
        return this.firstAvailable != null && !this.firstAvailable.isEmpty();
    }

    public FirstAvailableNested<A> addNewFirstAvailable() {
        return new FirstAvailableNested(-1, null);
    }

    public FirstAvailableNested<A> addNewFirstAvailableLike(V1DeviceSubRequest item) {
        return new FirstAvailableNested(-1, item);
    }

    public FirstAvailableNested<A> setNewFirstAvailableLike(int index, V1DeviceSubRequest item) {
        return new FirstAvailableNested(index, item);
    }

    public FirstAvailableNested<A> editFirstAvailable(int index) {
        if (index <= this.firstAvailable.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "firstAvailable"));
        }
        return this.setNewFirstAvailableLike(index, this.buildFirstAvailable(index));
    }

    public FirstAvailableNested<A> editFirstFirstAvailable() {
        if (this.firstAvailable.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "firstAvailable"));
        }
        return this.setNewFirstAvailableLike(0, this.buildFirstAvailable(0));
    }

    public FirstAvailableNested<A> editLastFirstAvailable() {
        int index = this.firstAvailable.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "firstAvailable"));
        }
        return this.setNewFirstAvailableLike(index, this.buildFirstAvailable(index));
    }

    public FirstAvailableNested<A> editMatchingFirstAvailable(Predicate<V1DeviceSubRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.firstAvailable.size(); ++i) {
            if (!predicate.test(this.firstAvailable.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "firstAvailable"));
        }
        return this.setNewFirstAvailableLike(index, this.buildFirstAvailable(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeviceRequestFluent that = (V1DeviceRequestFluent)o;
        if (!Objects.equals(this.exactly, that.exactly)) {
            return false;
        }
        if (!Objects.equals(this.firstAvailable, that.firstAvailable)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exactly, this.firstAvailable, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exactly != null) {
            sb.append("exactly:");
            sb.append(this.exactly);
            sb.append(",");
        }
        if (this.firstAvailable != null && !this.firstAvailable.isEmpty()) {
            sb.append("firstAvailable:");
            sb.append(this.firstAvailable);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExactlyNested<N>
    extends V1ExactDeviceRequestFluent<ExactlyNested<N>>
    implements Nested<N> {
        V1ExactDeviceRequestBuilder builder;

        ExactlyNested(V1ExactDeviceRequest item) {
            this.builder = new V1ExactDeviceRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeviceRequestFluent.this.withExactly(this.builder.build());
        }

        public N endExactly() {
            return this.and();
        }
    }

    public class FirstAvailableNested<N>
    extends V1DeviceSubRequestFluent<FirstAvailableNested<N>>
    implements Nested<N> {
        V1DeviceSubRequestBuilder builder;
        int index;

        FirstAvailableNested(int index, V1DeviceSubRequest item) {
            this.index = index;
            this.builder = new V1DeviceSubRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeviceRequestFluent.this.setToFirstAvailable(this.index, this.builder.build());
        }

        public N endFirstAvailable() {
            return this.and();
        }
    }
}

