/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngressBuilder;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngressFluent;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1IngressLoadBalancerStatusFluent<A extends V1IngressLoadBalancerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1IngressLoadBalancerIngressBuilder> ingress;

    public V1IngressLoadBalancerStatusFluent() {
    }

    public V1IngressLoadBalancerStatusFluent(V1IngressLoadBalancerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IngressLoadBalancerStatus instance) {
        V1IngressLoadBalancerStatus v1IngressLoadBalancerStatus = instance = instance != null ? instance : new V1IngressLoadBalancerStatus();
        if (instance != null) {
            this.withIngress(instance.getIngress());
        }
    }

    public A addToIngress(int index, V1IngressLoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    public A setToIngress(int index, V1IngressLoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    public A addToIngress(V1IngressLoadBalancerIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A addAllToIngress(Collection<V1IngressLoadBalancerIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A removeFromIngress(V1IngressLoadBalancerIngress ... items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIngress(Collection<V1IngressLoadBalancerIngress> items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1IngressLoadBalancerIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1IngressLoadBalancerIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1IngressLoadBalancerIngress> buildIngress() {
        return this.ingress != null ? V1IngressLoadBalancerStatusFluent.build(this.ingress) : null;
    }

    public V1IngressLoadBalancerIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public V1IngressLoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public V1IngressLoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public V1IngressLoadBalancerIngress buildMatchingIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        for (V1IngressLoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        for (V1IngressLoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<V1IngressLoadBalancerIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (V1IngressLoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    public A withIngress(V1IngressLoadBalancerIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (V1IngressLoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(V1IngressLoadBalancerIngress item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, V1IngressLoadBalancerIngress item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (index <= this.ingress.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "ingress"));
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "ingress"));
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "ingress"));
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "ingress"));
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressLoadBalancerStatusFluent that = (V1IngressLoadBalancerStatusFluent)o;
        return Objects.equals(this.ingress, that.ingress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressNested<N>
    extends V1IngressLoadBalancerIngressFluent<IngressNested<N>>
    implements Nested<N> {
        V1IngressLoadBalancerIngressBuilder builder;
        int index;

        IngressNested(int index, V1IngressLoadBalancerIngress item) {
            this.index = index;
            this.builder = new V1IngressLoadBalancerIngressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressLoadBalancerStatusFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }
}

