/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import io.kubernetes.client.openapi.models.V1ServiceBackendPortBuilder;
import io.kubernetes.client.openapi.models.V1ServiceBackendPortFluent;
import java.util.Objects;
import java.util.Optional;

public class V1IngressServiceBackendFluent<A extends V1IngressServiceBackendFluent<A>>
extends BaseFluent<A> {
    private String name;
    private V1ServiceBackendPortBuilder port;

    public V1IngressServiceBackendFluent() {
    }

    public V1IngressServiceBackendFluent(V1IngressServiceBackend instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IngressServiceBackend instance) {
        V1IngressServiceBackend v1IngressServiceBackend = instance = instance != null ? instance : new V1IngressServiceBackend();
        if (instance != null) {
            this.withName(instance.getName());
            this.withPort(instance.getPort());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public V1ServiceBackendPort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(V1ServiceBackendPort port) {
        this._visitables.remove("port");
        if (port != null) {
            this.port = new V1ServiceBackendPortBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(V1ServiceBackendPort item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new V1ServiceBackendPortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(V1ServiceBackendPort item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressServiceBackendFluent that = (V1IngressServiceBackendFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.port, that.port);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends V1ServiceBackendPortFluent<PortNested<N>>
    implements Nested<N> {
        V1ServiceBackendPortBuilder builder;

        PortNested(V1ServiceBackendPort item) {
            this.builder = new V1ServiceBackendPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressServiceBackendFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

