/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirementBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LabelSelectorFluent<A extends V1LabelSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1LabelSelectorRequirementBuilder> matchExpressions;
    private Map<String, String> matchLabels;

    public V1LabelSelectorFluent() {
    }

    public V1LabelSelectorFluent(V1LabelSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1LabelSelector instance) {
        V1LabelSelector v1LabelSelector = instance = instance != null ? instance : new V1LabelSelector();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchLabels(instance.getMatchLabels());
        }
    }

    public A addToMatchExpressions(int index, V1LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchExpressions(int index, V1LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchExpressions(V1LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (V1LabelSelectorRequirement item : items) {
            V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchExpressions(Collection<V1LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (V1LabelSelectorRequirement item : items) {
            V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchExpressions(V1LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        for (V1LabelSelectorRequirement item : items) {
            V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<V1LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        for (V1LabelSelectorRequirement item : items) {
            V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchExpressions(Predicate<V1LabelSelectorRequirementBuilder> predicate) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        Iterator<V1LabelSelectorRequirementBuilder> each = this.matchExpressions.iterator();
        Object visitables = this._visitables.get("matchExpressions");
        while (each.hasNext()) {
            V1LabelSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1LabelSelectorRequirement> buildMatchExpressions() {
        return this.matchExpressions != null ? V1LabelSelectorFluent.build(this.matchExpressions) : null;
    }

    public V1LabelSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public V1LabelSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public V1LabelSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    public V1LabelSelectorRequirement buildMatchingMatchExpression(Predicate<V1LabelSelectorRequirementBuilder> predicate) {
        for (V1LabelSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<V1LabelSelectorRequirementBuilder> predicate) {
        for (V1LabelSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<V1LabelSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.get("matchExpressions").clear();
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList();
            for (V1LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)this;
    }

    public A withMatchExpressions(V1LabelSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove("matchExpressions");
        }
        if (matchExpressions != null) {
            for (V1LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNested(-1, null);
    }

    public MatchExpressionsNested<A> addNewMatchExpressionLike(V1LabelSelectorRequirement item) {
        return new MatchExpressionsNested(-1, item);
    }

    public MatchExpressionsNested<A> setNewMatchExpressionLike(int index, V1LabelSelectorRequirement item) {
        return new MatchExpressionsNested(index, item);
    }

    public MatchExpressionsNested<A> editMatchExpression(int index) {
        if (index <= this.matchExpressions.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "matchExpressions"));
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "matchExpressions"));
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    public MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "matchExpressions"));
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<V1LabelSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.test(this.matchExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "matchExpressions"));
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)this;
    }

    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)this;
    }

    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)this;
    }

    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public <K, V> A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? null : new LinkedHashMap<String, String>(matchLabels);
        return (A)this;
    }

    public boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LabelSelectorFluent that = (V1LabelSelectorFluent)o;
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        return Objects.equals(this.matchLabels, that.matchLabels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.matchLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions);
            sb.append(",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchExpressionsNested<N>
    extends V1LabelSelectorRequirementFluent<MatchExpressionsNested<N>>
    implements Nested<N> {
        V1LabelSelectorRequirementBuilder builder;
        int index;

        MatchExpressionsNested(int index, V1LabelSelectorRequirement item) {
            this.index = index;
            this.builder = new V1LabelSelectorRequirementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1LabelSelectorFluent.this.setToMatchExpressions(this.index, this.builder.build());
        }

        public N endMatchExpression() {
            return this.and();
        }
    }
}

