/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LeaseSpec is a specification of a Lease.")
public class V1LeaseSpec {
    public static final String SERIALIZED_NAME_ACQUIRE_TIME = "acquireTime";
    @SerializedName(value="acquireTime")
    private OffsetDateTime acquireTime;
    public static final String SERIALIZED_NAME_HOLDER_IDENTITY = "holderIdentity";
    @SerializedName(value="holderIdentity")
    private String holderIdentity;
    public static final String SERIALIZED_NAME_LEASE_DURATION_SECONDS = "leaseDurationSeconds";
    @SerializedName(value="leaseDurationSeconds")
    private Integer leaseDurationSeconds;
    public static final String SERIALIZED_NAME_LEASE_TRANSITIONS = "leaseTransitions";
    @SerializedName(value="leaseTransitions")
    private Integer leaseTransitions;
    public static final String SERIALIZED_NAME_PREFERRED_HOLDER = "preferredHolder";
    @SerializedName(value="preferredHolder")
    private String preferredHolder;
    public static final String SERIALIZED_NAME_RENEW_TIME = "renewTime";
    @SerializedName(value="renewTime")
    private OffsetDateTime renewTime;
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    private String strategy;

    public V1LeaseSpec acquireTime(OffsetDateTime acquireTime) {
        this.acquireTime = acquireTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="acquireTime is a time when the current lease was acquired.")
    public OffsetDateTime getAcquireTime() {
        return this.acquireTime;
    }

    public void setAcquireTime(OffsetDateTime acquireTime) {
        this.acquireTime = acquireTime;
    }

    public V1LeaseSpec holderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="holderIdentity contains the identity of the holder of a current lease. If Coordinated Leader Election is used, the holder identity must be equal to the elected LeaseCandidate.metadata.name field.")
    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public void setHolderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
    }

    public V1LeaseSpec leaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measured against the time of last observed renewTime.")
    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public void setLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
    }

    public V1LeaseSpec leaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="leaseTransitions is the number of transitions of a lease between holders.")
    public Integer getLeaseTransitions() {
        return this.leaseTransitions;
    }

    public void setLeaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
    }

    public V1LeaseSpec preferredHolder(String preferredHolder) {
        this.preferredHolder = preferredHolder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PreferredHolder signals to a lease holder that the lease has a more optimal holder and should be given up. This field can only be set if Strategy is also set.")
    public String getPreferredHolder() {
        return this.preferredHolder;
    }

    public void setPreferredHolder(String preferredHolder) {
        this.preferredHolder = preferredHolder;
    }

    public V1LeaseSpec renewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="renewTime is a time when the current holder of a lease has last updated the lease.")
    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public void setRenewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
    }

    public V1LeaseSpec strategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Strategy indicates the strategy for picking the leader for coordinated leader election. If the field is not specified, there is no active coordination for this lease. (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.")
    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LeaseSpec v1LeaseSpec = (V1LeaseSpec)o;
        return Objects.equals(this.acquireTime, v1LeaseSpec.acquireTime) && Objects.equals(this.holderIdentity, v1LeaseSpec.holderIdentity) && Objects.equals(this.leaseDurationSeconds, v1LeaseSpec.leaseDurationSeconds) && Objects.equals(this.leaseTransitions, v1LeaseSpec.leaseTransitions) && Objects.equals(this.preferredHolder, v1LeaseSpec.preferredHolder) && Objects.equals(this.renewTime, v1LeaseSpec.renewTime) && Objects.equals(this.strategy, v1LeaseSpec.strategy);
    }

    public int hashCode() {
        return Objects.hash(this.acquireTime, this.holderIdentity, this.leaseDurationSeconds, this.leaseTransitions, this.preferredHolder, this.renewTime, this.strategy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LeaseSpec {\n");
        sb.append("    acquireTime: ").append(this.toIndentedString(this.acquireTime)).append("\n");
        sb.append("    holderIdentity: ").append(this.toIndentedString(this.holderIdentity)).append("\n");
        sb.append("    leaseDurationSeconds: ").append(this.toIndentedString(this.leaseDurationSeconds)).append("\n");
        sb.append("    leaseTransitions: ").append(this.toIndentedString(this.leaseTransitions)).append("\n");
        sb.append("    preferredHolder: ").append(this.toIndentedString(this.preferredHolder)).append("\n");
        sb.append("    renewTime: ").append(this.toIndentedString(this.renewTime)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

