/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1NamespaceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NamespaceSpecFluent<A extends V1NamespaceSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> finalizers;

    public V1NamespaceSpecFluent() {
    }

    public V1NamespaceSpecFluent(V1NamespaceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1NamespaceSpec instance) {
        V1NamespaceSpec v1NamespaceSpec = instance = instance != null ? instance : new V1NamespaceSpec();
        if (instance != null) {
            this.withFinalizers(instance.getFinalizers());
        }
    }

    public A addToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)this;
    }

    public A setToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)this;
    }

    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    public A removeFromFinalizers(String ... items) {
        if (this.finalizers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    public List<String> getFinalizers() {
        return this.finalizers;
    }

    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFinalizers(List<String> finalizers) {
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)this;
    }

    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
            this._visitables.remove("finalizers");
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    public boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NamespaceSpecFluent that = (V1NamespaceSpecFluent)o;
        return Objects.equals(this.finalizers, that.finalizers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.finalizers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.finalizers != null && !this.finalizers.isEmpty()) {
            sb.append("finalizers:");
            sb.append(this.finalizers);
        }
        sb.append("}");
        return sb.toString();
    }
}

