/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1Overhead;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class V1OverheadFluent<A extends V1OverheadFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> podFixed;

    public V1OverheadFluent() {
    }

    public V1OverheadFluent(V1Overhead instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1Overhead instance) {
        V1Overhead v1Overhead = instance = instance != null ? instance : new V1Overhead();
        if (instance != null) {
            this.withPodFixed(instance.getPodFixed());
        }
    }

    public A addToPodFixed(String key, Quantity value) {
        if (this.podFixed == null && key != null && value != null) {
            this.podFixed = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.podFixed.put(key, value);
        }
        return (A)this;
    }

    public A addToPodFixed(Map<String, Quantity> map) {
        if (this.podFixed == null && map != null) {
            this.podFixed = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.podFixed.putAll(map);
        }
        return (A)this;
    }

    public A removeFromPodFixed(String key) {
        if (this.podFixed == null) {
            return (A)this;
        }
        if (key != null && this.podFixed != null) {
            this.podFixed.remove(key);
        }
        return (A)this;
    }

    public A removeFromPodFixed(Map<String, Quantity> map) {
        if (this.podFixed == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.podFixed == null) continue;
                this.podFixed.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getPodFixed() {
        return this.podFixed;
    }

    public <K, V> A withPodFixed(Map<String, Quantity> podFixed) {
        this.podFixed = podFixed == null ? null : new LinkedHashMap<String, Quantity>(podFixed);
        return (A)this;
    }

    public boolean hasPodFixed() {
        return this.podFixed != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1OverheadFluent that = (V1OverheadFluent)o;
        return Objects.equals(this.podFixed, that.podFixed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.podFixed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.podFixed != null && !this.podFixed.isEmpty()) {
            sb.append("podFixed:");
            sb.append(this.podFixed);
        }
        sb.append("}");
        return sb.toString();
    }
}

