/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SecretKeySelector selects a key of a Secret.")
public class V1SecretKeySelector {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;

    public V1SecretKeySelector key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="The key of the secret to select from.  Must be a valid secret key.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1SecretKeySelector name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1SecretKeySelector optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the Secret or its key must be defined")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecretKeySelector v1SecretKeySelector = (V1SecretKeySelector)o;
        return Objects.equals(this.key, v1SecretKeySelector.key) && Objects.equals(this.name, v1SecretKeySelector.name) && Objects.equals(this.optional, v1SecretKeySelector.optional);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.optional);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SecretKeySelector {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

