/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1ConditionBuilder;
import io.kubernetes.client.openapi.models.V1ConditionFluent;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatusBuilder;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatusFluent;
import io.kubernetes.client.openapi.models.V1ServiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ServiceStatusFluent<A extends V1ServiceStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1ConditionBuilder> conditions;
    private V1LoadBalancerStatusBuilder loadBalancer;

    public V1ServiceStatusFluent() {
    }

    public V1ServiceStatusFluent(V1ServiceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ServiceStatus instance) {
        V1ServiceStatus v1ServiceStatus = instance = instance != null ? instance : new V1ServiceStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withLoadBalancer(instance.getLoadBalancer());
        }
    }

    public A addToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Condition> buildConditions() {
        return this.conditions != null ? V1ServiceStatusFluent.build(this.conditions) : null;
    }

    public V1Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1Condition buildMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (index <= this.conditions.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public V1LoadBalancerStatus buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    public A withLoadBalancer(V1LoadBalancerStatus loadBalancer) {
        this._visitables.remove("loadBalancer");
        if (loadBalancer != null) {
            this.loadBalancer = new V1LoadBalancerStatusBuilder(loadBalancer);
            this._visitables.get("loadBalancer").add(this.loadBalancer);
        } else {
            this.loadBalancer = null;
            this._visitables.get("loadBalancer").remove(this.loadBalancer);
        }
        return (A)this;
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNested(null);
    }

    public LoadBalancerNested<A> withNewLoadBalancerLike(V1LoadBalancerStatus item) {
        return new LoadBalancerNested(item);
    }

    public LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(null));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(new V1LoadBalancerStatusBuilder().build()));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancerLike(V1LoadBalancerStatus item) {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServiceStatusFluent that = (V1ServiceStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        return Objects.equals(this.loadBalancer, that.loadBalancer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.loadBalancer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(this.loadBalancer);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1ConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1Condition item) {
            this.index = index;
            this.builder = new V1ConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class LoadBalancerNested<N>
    extends V1LoadBalancerStatusFluent<LoadBalancerNested<N>>
    implements Nested<N> {
        V1LoadBalancerStatusBuilder builder;

        LoadBalancerNested(V1LoadBalancerStatus item) {
            this.builder = new V1LoadBalancerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceStatusFluent.this.withLoadBalancer(this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }
}

